/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.authentication.storage;

import com.github.benmanes.caffeine.cache.Expiry;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import lombok.Generated;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.util.DateTimeUtils;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultifactorAuthenticationTrustRecordExpiry
implements Expiry<String, MultifactorAuthenticationTrustRecord> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationTrustRecordExpiry.class);

    public long expireAfterCreate(@NonNull String key, @NonNull MultifactorAuthenticationTrustRecord value, long currentTime) {
        if (value.getExpirationDate() == null) {
            LOGGER.trace("Multifactor trust record [{}] will never expire", (Object)value);
            return Long.MAX_VALUE;
        }
        if (value.isExpired()) {
            LOGGER.trace("Multifactor trust record [{}] is expired", (Object)value);
            return 0L;
        }
        try {
            ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS);
            ZonedDateTime zonedExp = DateTimeUtils.zonedDateTimeOf((Date)value.getExpirationDate()).truncatedTo(ChronoUnit.SECONDS);
            long nanos = Duration.between(now, zonedExp).toNanos();
            LOGGER.trace("Multifactor trust record [{}] expires in [{}] nanoseconds", (Object)value, (Object)nanos);
            return nanos;
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            LOGGER.debug("Multifactor trust record [{}] will never expire", (Object)value);
            return Long.MAX_VALUE;
        }
    }

    public long expireAfterUpdate(@NonNull String key, @NonNull MultifactorAuthenticationTrustRecord value, long currentTime, @NonNegative long currentDuration) {
        return this.expireAfterCreate(key, value, currentTime);
    }

    public long expireAfterRead(@NonNull String key, @NonNull MultifactorAuthenticationTrustRecord value, long currentTime, @NonNegative long currentDuration) {
        return this.expireAfterCreate(key, value, currentTime);
    }
}

