/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.authentication.storage;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.mfa.trusteddevice.TrustedDevicesMultifactorProperties;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecordKeyGenerator;
import org.apereo.cas.trusted.authentication.storage.BaseMultifactorAuthenticationTrustStorage;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.io.FileWatcherService;
import org.apereo.cas.util.io.WatcherService;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.hjson.JsonValue;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.Resource;

public class JsonMultifactorAuthenticationTrustStorage
extends BaseMultifactorAuthenticationTrustStorage
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonMultifactorAuthenticationTrustStorage.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final Resource location;
    private Map<String, MultifactorAuthenticationTrustRecord> storage;
    private WatcherService watcherService;

    public JsonMultifactorAuthenticationTrustStorage(TrustedDevicesMultifactorProperties properties, CipherExecutor<Serializable, String> cipherExecutor, Resource location, MultifactorAuthenticationTrustRecordKeyGenerator keyGenerationStrategy) {
        super(properties, cipherExecutor, keyGenerationStrategy);
        this.location = location;
        this.readTrustedRecordsFromResource();
        if (ResourceUtils.isFile((Resource)location)) {
            Consumer callback = Unchecked.consumer(__ -> this.readTrustedRecordsFromResource());
            this.watcherService = new FileWatcherService((File)Unchecked.supplier(() -> ((Resource)location).getFile()).get(), callback);
            this.watcherService.start(this.getClass().getSimpleName());
        }
    }

    public void destroy() {
        FunctionUtils.doIfNotNull((Object)this.watcherService, WatcherService::close);
    }

    @Override
    public void remove(String key) {
        this.storage.keySet().removeIf(k -> k.equalsIgnoreCase(key));
        this.writeTrustedRecordsToResource();
    }

    @Override
    public void remove(ZonedDateTime expirationDate) {
        LinkedHashSet results = this.storage.values().stream().filter(entry -> entry.getExpirationDate() != null).filter(entry -> {
            Date expDate = DateTimeUtils.dateOf((ChronoZonedDateTime)expirationDate);
            return expDate.compareTo(entry.getExpirationDate()) >= 0;
        }).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        LOGGER.info("Found [{}] expired trusted-device records", (Object)results.size());
        if (!results.isEmpty()) {
            results.forEach(entry -> this.storage.remove(entry.getRecordKey()));
            LOGGER.info("Invalidated and removed [{}] expired records", (Object)results.size());
            this.writeTrustedRecordsToResource();
        }
    }

    @Override
    public Set<? extends MultifactorAuthenticationTrustRecord> getAll() {
        this.remove();
        return new TreeSet<MultifactorAuthenticationTrustRecord>(this.storage.values());
    }

    @Override
    public MultifactorAuthenticationTrustRecord get(long id) {
        this.remove();
        return this.storage.values().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)entry.getRecordKey())).filter(entry -> entry.getId() == id).sorted().findFirst().orElse(null);
    }

    @Override
    public Set<? extends MultifactorAuthenticationTrustRecord> get(ZonedDateTime onOrAfterDate) {
        this.remove();
        return this.storage.values().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)entry.getRecordKey())).filter(entry -> entry.getRecordDate().isEqual(onOrAfterDate) || entry.getRecordDate().isAfter(onOrAfterDate)).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Set<? extends MultifactorAuthenticationTrustRecord> get(String principal) {
        this.remove();
        return this.storage.values().stream().filter(entry -> entry.getPrincipal().equalsIgnoreCase(principal)).filter(entry -> StringUtils.isNotBlank((CharSequence)entry.getRecordKey())).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public MultifactorAuthenticationTrustRecord saveInternal(MultifactorAuthenticationTrustRecord record) {
        this.storage.put(record.getRecordKey(), record);
        this.writeTrustedRecordsToResource();
        return record;
    }

    private void readTrustedRecordsFromResource() {
        this.storage = new LinkedHashMap<String, MultifactorAuthenticationTrustRecord>();
        if (ResourceUtils.doesResourceExist((Resource)this.location)) {
            FunctionUtils.doUnchecked(__ -> {
                try (InputStreamReader reader = new InputStreamReader(this.location.getInputStream(), StandardCharsets.UTF_8);){
                    TypeReference<Map<String, MultifactorAuthenticationTrustRecord>> personList = new TypeReference<Map<String, MultifactorAuthenticationTrustRecord>>(this){};
                    this.storage = (Map)MAPPER.readValue(JsonValue.readHjson((Reader)reader).toString(), (TypeReference)personList);
                }
            }, (Object[])new Object[0]);
        }
    }

    private void writeTrustedRecordsToResource() {
        FunctionUtils.doUnchecked(__ -> {
            File file = this.location.getFile();
            boolean res = file.createNewFile();
            if (res) {
                LOGGER.debug("Created JSON resource @ [{}]", (Object)this.location);
            }
            MAPPER.writerWithDefaultPrettyPrinter().writeValue(file, this.storage);
            this.readTrustedRecordsFromResource();
        }, (Object[])new Object[0]);
    }
}

