/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import lombok.Generated;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyRequest;
import org.apereo.cas.services.RegisteredServiceExpirationPolicy;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.services.UnauthorizedServiceForPrincipalException;
import org.apereo.cas.services.UnauthorizedSsoServiceException;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegisteredServiceAccessStrategyUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceAccessStrategyUtils.class);

    public static void ensureServiceAccessIsAllowed(RegisteredService registeredService) {
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed(null, registeredService);
    }

    public static void ensureServiceAccessIsAllowed(@Nullable Service service, @Nullable RegisteredService registeredService) {
        String id;
        String string = id = service != null ? service.getId() : "unknown";
        if (registeredService == null) {
            LOGGER.warn("Unauthorized Service Access. Service [{}] is not registered in the service registry. Review the service access strategy to evaluate policies required for service access", (Object)id);
            throw UnauthorizedServiceException.denied((String)("Service " + id + " is not found or is disabled in the service registry."));
        }
        if (!registeredService.getAccessStrategy().isServiceAccessAllowed(registeredService, service)) {
            String msg = String.format("Unauthorized Service Access. Service [%s] is not enabled in service registry. You should review the service access strategy to evaluate the conditions and policies required for service access.", id);
            throw UnauthorizedServiceException.denied((String)msg);
        }
        if (!RegisteredServiceAccessStrategyUtils.ensureServiceIsNotExpired(registeredService)) {
            String msg = String.format("Expired service access is denied. Service [%s] has been expired", id);
            throw UnauthorizedServiceException.expired((String)msg);
        }
    }

    public static boolean ensureServiceIsNotExpired(RegisteredService registeredService) {
        return RegisteredServiceAccessStrategyUtils.getRegisteredServiceExpirationPolicyPredicate().test(registeredService);
    }

    public static void ensureServiceSsoAccessIsAllowed(RegisteredService registeredService, Service service, TicketGrantingTicket ticketGrantingTicket) {
        RegisteredServiceAccessStrategyUtils.ensureServiceSsoAccessIsAllowed(registeredService, service, ticketGrantingTicket, false);
    }

    public static void ensureServiceSsoAccessIsAllowed(RegisteredService registeredService, Service service, TicketGrantingTicket ticketGrantingTicket, boolean credentialsProvided) {
        if (registeredService == null || !registeredService.getAccessStrategy().isServiceAccessAllowedForSso(registeredService)) {
            LOGGER.debug("Service [{}] is configured to not use SSO", (Object)service.getId());
            if (ticketGrantingTicket.getProxiedBy() != null) {
                LOGGER.warn("Service [{}] is not allowed to use SSO for proxying.", (Object)service.getId());
            }
            if (ticketGrantingTicket.getCountOfUses() > 0 && !credentialsProvided) {
                LOGGER.warn("Service [{}] is not allowed to use SSO. The ticket-granting ticket [{}] is not proxied and it's been used at least once. The authentication request must provide credentials before access can be granted", (Object)ticketGrantingTicket.getId(), (Object)service.getId());
            }
            if (ticketGrantingTicket.getCountOfUses() == 0 && credentialsProvided) {
                LOGGER.debug("The ticket-granting ticket [{}] has never been used before and the authentication request has supplied credentials to access service [{}]", (Object)ticketGrantingTicket.getId(), (Object)service.getId());
            } else if (!credentialsProvided) {
                throw new UnauthorizedSsoServiceException();
            }
        }
        LOGGER.debug("Current authentication via ticket [{}] allows service [{}] to participate in the existing SSO session", (Object)ticketGrantingTicket.getId(), (Object)service.getId());
    }

    public static boolean ensurePrincipalAccessIsAllowedForService(Service service, RegisteredService registeredService, String principalId, Map<String, List<Object>> attributes) throws Throwable {
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed(service, registeredService);
        String serviceId = service != null ? service.getId() : "unknown";
        LOGGER.trace("Checking access strategy for service [{}], requested by [{}] with attributes [{}].", new Object[]{serviceId, principalId, attributes});
        RegisteredServiceAccessStrategyRequest accessRequest = RegisteredServiceAccessStrategyRequest.builder().service(service).principalId(principalId).attributes(attributes).registeredService(registeredService).build();
        if (!registeredService.getAccessStrategy().authorizeRequest(accessRequest)) {
            LOGGER.warn("Cannot grant access to service [{}]; it is not authorized for use by [{}].", (Object)serviceId, (Object)principalId);
            HashMap<String, UnauthorizedServiceForPrincipalException> handlerErrors = new HashMap<String, UnauthorizedServiceForPrincipalException>();
            String message = String.format("Cannot authorize principal %s to access service %s, likely due to insufficient permissions", principalId, serviceId);
            UnauthorizedServiceForPrincipalException exception = new UnauthorizedServiceForPrincipalException(message, registeredService, principalId, attributes);
            handlerErrors.put(UnauthorizedServiceForPrincipalException.class.getSimpleName(), exception);
            throw new PrincipalException(message, handlerErrors, new HashMap(0));
        }
        return true;
    }

    public static Predicate<RegisteredService> getRegisteredServiceExpirationPolicyPredicate() {
        return service -> {
            if (service == null) {
                return false;
            }
            RegisteredServiceExpirationPolicy policy = service.getExpirationPolicy();
            return policy == null || !policy.isExpired();
        };
    }

    @Generated
    private RegisteredServiceAccessStrategyUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

