/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import jakarta.persistence.PostLoad;
import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.attribute.CaseCanonicalizationMode;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.RegisteredServiceUsernameProviderContext;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class BaseRegisteredServiceUsernameAttributeProvider
implements RegisteredServiceUsernameAttributeProvider {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseRegisteredServiceUsernameAttributeProvider.class);
    private static final long serialVersionUID = -8381275200333399951L;
    private String canonicalizationMode = "NONE";
    private boolean encryptUsername;
    private String scope;
    private String removePattern;

    public final String resolveUsername(RegisteredServiceUsernameProviderContext context) throws Throwable {
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed(context.getService(), context.getRegisteredService());
        String resolvedUsername = this.resolveUsernameInternal(context);
        if (this.canonicalizationMode == null) {
            this.canonicalizationMode = "NONE";
        }
        String removedUsername = this.removePatternFromUsernameIfNecessary(resolvedUsername);
        String finalUsername = this.scopeUsernameIfNecessary(removedUsername);
        String uid = CaseCanonicalizationMode.valueOf((String)this.canonicalizationMode).canonicalize(finalUsername.trim(), Locale.getDefault());
        LOGGER.debug("Resolved username for [{}] is [{}]", (Object)context.getService(), (Object)uid);
        if (!this.encryptUsername) {
            return uid;
        }
        String encryptedId = this.encryptResolvedUsername(context, uid);
        if (StringUtils.isBlank((CharSequence)encryptedId)) {
            throw new IllegalArgumentException("Could not encrypt username " + uid + " for service " + String.valueOf(context.getService()));
        }
        return encryptedId;
    }

    @PostLoad
    public void initialize() {
        this.setCanonicalizationMode("NONE");
    }

    protected String removePatternFromUsernameIfNecessary(String username) {
        return (String)FunctionUtils.doIfNotNull((Object)this.removePattern, () -> RegExUtils.removePattern((String)username, (String)this.removePattern), () -> username).get();
    }

    protected String scopeUsernameIfNecessary(String resolved) {
        return (String)FunctionUtils.doIfNotNull((Object)this.scope, () -> String.format("%s@%s", resolved, this.scope), () -> resolved).get();
    }

    protected String encryptResolvedUsername(RegisteredServiceUsernameProviderContext context, String username) {
        ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
        RegisteredServiceCipherExecutor cipher = (RegisteredServiceCipherExecutor)applicationContext.getBean("registeredServiceCipherExecutor", RegisteredServiceCipherExecutor.class);
        return cipher.encode(username, Optional.of(context.getRegisteredService()));
    }

    protected abstract String resolveUsernameInternal(RegisteredServiceUsernameProviderContext var1) throws Throwable;

    @Generated
    public String getCanonicalizationMode() {
        return this.canonicalizationMode;
    }

    @Generated
    public boolean isEncryptUsername() {
        return this.encryptUsername;
    }

    @Generated
    public String getScope() {
        return this.scope;
    }

    @Generated
    public String getRemovePattern() {
        return this.removePattern;
    }

    @Generated
    public void setCanonicalizationMode(String canonicalizationMode) {
        this.canonicalizationMode = canonicalizationMode;
    }

    @Generated
    public void setEncryptUsername(boolean encryptUsername) {
        this.encryptUsername = encryptUsername;
    }

    @Generated
    public void setScope(String scope) {
        this.scope = scope;
    }

    @Generated
    public void setRemovePattern(String removePattern) {
        this.removePattern = removePattern;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseRegisteredServiceUsernameAttributeProvider)) {
            return false;
        }
        BaseRegisteredServiceUsernameAttributeProvider other = (BaseRegisteredServiceUsernameAttributeProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.encryptUsername != other.encryptUsername) {
            return false;
        }
        String this$canonicalizationMode = this.canonicalizationMode;
        String other$canonicalizationMode = other.canonicalizationMode;
        if (this$canonicalizationMode == null ? other$canonicalizationMode != null : !this$canonicalizationMode.equals(other$canonicalizationMode)) {
            return false;
        }
        String this$scope = this.scope;
        String other$scope = other.scope;
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$removePattern = this.removePattern;
        String other$removePattern = other.removePattern;
        return !(this$removePattern == null ? other$removePattern != null : !this$removePattern.equals(other$removePattern));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseRegisteredServiceUsernameAttributeProvider;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.encryptUsername ? 79 : 97);
        String $canonicalizationMode = this.canonicalizationMode;
        result = result * 59 + ($canonicalizationMode == null ? 43 : $canonicalizationMode.hashCode());
        String $scope = this.scope;
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $removePattern = this.removePattern;
        result = result * 59 + ($removePattern == null ? 43 : $removePattern.hashCode());
        return result;
    }

    @Generated
    protected BaseRegisteredServiceUsernameAttributeProvider(String canonicalizationMode, boolean encryptUsername, String scope, String removePattern) {
        this.canonicalizationMode = canonicalizationMode;
        this.encryptUsername = encryptUsername;
        this.scope = scope;
        this.removePattern = removePattern;
    }

    @Generated
    protected BaseRegisteredServiceUsernameAttributeProvider() {
    }
}

