/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.nativex;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.ReflectionUtils;
import org.jooq.lambda.Unchecked;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.Advised;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.core.DecoratingProxy;
import org.springframework.util.ClassUtils;

@FunctionalInterface
public interface CasRuntimeHintsRegistrar
extends RuntimeHintsRegistrar {
    public static final String PROPERTY_IMAGE_CODE_KEY = "org.graalvm.nativeimage.imagecode";
    public static final String PROPERTY_IMAGE_CODE_VALUE_BUILDTIME = "buildtime";
    public static final String PROPERTY_IMAGE_CODE_VALUE_RUNTIME = "runtime";
    public static final String SYSTEM_PROPERTY_SPRING_AOT_PROCESSING = "spring.aot.processing";

    @CanIgnoreReturnValue
    default public CasRuntimeHintsRegistrar registerSerializableSpringProxy(RuntimeHints hints, Class ... clazz) {
        List<Class> proxies = Arrays.stream(clazz).collect(Collectors.toList());
        proxies.add(Serializable.class);
        CasRuntimeHintsRegistrar.addSpringProxyInterfaces(proxies);
        hints.proxies().registerJdkProxy(clazz).registerJdkProxy(proxies.toArray(ArrayUtils.EMPTY_CLASS_ARRAY));
        return this;
    }

    @CanIgnoreReturnValue
    default public CasRuntimeHintsRegistrar registerSpringProxy(RuntimeHints hints, Class ... clazz) {
        List<Class> proxies = Arrays.stream(clazz).collect(Collectors.toList());
        CasRuntimeHintsRegistrar.addSpringProxyInterfaces(proxies);
        hints.proxies().registerJdkProxy(clazz).registerJdkProxy(proxies.toArray(ArrayUtils.EMPTY_CLASS_ARRAY));
        return this;
    }

    default public void registerChainedProxyHints(RuntimeHints hints, Class ... subclassesInPackage) {
        hints.proxies().registerJdkProxy(subclassesInPackage);
    }

    default public void registerProxyHints(RuntimeHints hints, Class ... subclassesInPackage) {
        Arrays.stream(subclassesInPackage).forEach(clazz -> hints.proxies().registerJdkProxy(new Class[]{clazz}));
    }

    default public void registerProxyHints(RuntimeHints hints, Collection<Class> subclassesInPackage) {
        subclassesInPackage.forEach(clazz -> hints.proxies().registerJdkProxy(new Class[]{clazz}));
    }

    default public void registerSerializationHints(RuntimeHints hints, Collection<Class> entries) {
        entries.forEach(el -> hints.serialization().registerType(el));
    }

    default public void registerSerializationHints(RuntimeHints hints, Object ... entries) {
        Arrays.stream(entries).forEach(el -> {
            if (el instanceof TypeReference) {
                TypeReference tr = (TypeReference)el;
                hints.serialization().registerType(tr);
            }
            if (el instanceof Class) {
                Class clazz = (Class)el;
                hints.serialization().registerType(clazz);
            }
        });
    }

    @CanIgnoreReturnValue
    default public CasRuntimeHintsRegistrar registerReflectionHintForDeclaredMethod(RuntimeHints hints, Class clazz, String name) {
        Method method = (Method)Unchecked.supplier(() -> clazz.getDeclaredMethod(name, new Class[0])).get();
        hints.reflection().registerMethod(method, ExecutableMode.INVOKE);
        return this;
    }

    @CanIgnoreReturnValue
    default public CasRuntimeHintsRegistrar registerReflectionHintsForTypes(RuntimeHints hints, Collection entries) {
        CasRuntimeHintsRegistrar.registerReflectionHints(hints, List.of(entries), new MemberCategory[0]);
        return this;
    }

    @CanIgnoreReturnValue
    default public CasRuntimeHintsRegistrar registerReflectionHints(RuntimeHints hints, Class ... entries) {
        this.registerReflectionHints(hints, List.of(entries));
        return this;
    }

    private static void registerReflectionHints(RuntimeHints hints, Collection entries, MemberCategory ... memberCategories) {
        entries.forEach(el -> {
            Object clazz;
            if (el instanceof String) {
                clazz = (String)el;
                hints.reflection().registerType(TypeReference.of((String)clazz), memberCategories);
            }
            if (el instanceof Class) {
                clazz = (Class)el;
                hints.reflection().registerType((Class)clazz, memberCategories);
            }
            if (el instanceof TypeReference) {
                TypeReference reference = (TypeReference)el;
                hints.reflection().registerType(reference, memberCategories);
            }
        });
    }

    @CanIgnoreReturnValue
    default public CasRuntimeHintsRegistrar registerReflectionHints(RuntimeHints hints, Collection entries) {
        MemberCategory[] memberCategories = new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS, MemberCategory.INTROSPECT_PUBLIC_CONSTRUCTORS, MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.INTROSPECT_PUBLIC_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.DECLARED_FIELDS, MemberCategory.PUBLIC_FIELDS};
        CasRuntimeHintsRegistrar.registerReflectionHints(hints, entries, memberCategories);
        return this;
    }

    @CanIgnoreReturnValue
    default public CasRuntimeHintsRegistrar registerReflectionHintsForMethodsAndFields(RuntimeHints hints, Collection entries) {
        MemberCategory[] memberCategories = new MemberCategory[]{MemberCategory.PUBLIC_FIELDS, MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS};
        CasRuntimeHintsRegistrar.registerReflectionHints(hints, entries, memberCategories);
        return this;
    }

    @CanIgnoreReturnValue
    default public CasRuntimeHintsRegistrar registerReflectionHintsForIntrospectedPublicElements(RuntimeHints hints, Collection entries) {
        MemberCategory[] memberCategories = new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_CONSTRUCTORS, MemberCategory.INTROSPECT_PUBLIC_METHODS};
        CasRuntimeHintsRegistrar.registerReflectionHints(hints, entries, memberCategories);
        return this;
    }

    @CanIgnoreReturnValue
    default public CasRuntimeHintsRegistrar registerReflectionHintsForDeclaredElements(RuntimeHints hints, Collection entries) {
        MemberCategory[] memberCategories = new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS};
        CasRuntimeHintsRegistrar.registerReflectionHints(hints, entries, memberCategories);
        return this;
    }

    @CanIgnoreReturnValue
    default public CasRuntimeHintsRegistrar registerReflectionHintsForConstructors(RuntimeHints hints, Collection entries) {
        MemberCategory[] memberCategories = new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS, MemberCategory.INTROSPECT_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS};
        CasRuntimeHintsRegistrar.registerReflectionHints(hints, entries, memberCategories);
        return this;
    }

    @CanIgnoreReturnValue
    default public CasRuntimeHintsRegistrar registerReflectionHintsForDeclaredAndPublicElements(RuntimeHints hints, Collection entries) {
        MemberCategory[] memberCategories = new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.DECLARED_FIELDS, MemberCategory.PUBLIC_FIELDS};
        CasRuntimeHintsRegistrar.registerReflectionHints(hints, entries, memberCategories);
        return this;
    }

    @CanIgnoreReturnValue
    default public CasRuntimeHintsRegistrar registerReflectionHintsForPublicElements(RuntimeHints hints, Collection entries) {
        MemberCategory[] memberCategories = new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.PUBLIC_FIELDS};
        CasRuntimeHintsRegistrar.registerReflectionHints(hints, entries, memberCategories);
        return this;
    }

    default public Collection<Class> findSubclassesOf(Class superClass) {
        return this.findSubclassesInPackage(superClass, "org.apereo.cas");
    }

    default public Collection<Class> findSubclassesInClassPackage(Class superClass) {
        return this.findSubclassesInPackage(superClass, superClass.getPackageName());
    }

    default public Collection<Class> findSubclassesInPackage(Class superClass, String ... packages) {
        Collection results = ReflectionUtils.findSubclassesInPackage(superClass, packages);
        List<Class> filteredResults = results.stream().filter(clazz -> {
            String host = clazz.getCanonicalName();
            if (clazz.isMemberClass() && clazz.getPackageName().startsWith("org.apereo.cas")) {
                Class<?> entry = clazz;
                while (entry.isMemberClass()) {
                    entry = clazz.getNestHost();
                }
                host = entry.getCanonicalName();
            }
            return StringUtils.isNotBlank((CharSequence)host) && !host.endsWith("Tests");
        }).collect(Collectors.toList());
        filteredResults.add(superClass);
        return filteredResults;
    }

    default public boolean isTypePresent(ClassLoader classLoader, Class typeName) {
        return this.isTypePresent(classLoader, typeName.getTypeName());
    }

    default public boolean isTypePresent(ClassLoader classLoader, String typeName) {
        return ClassUtils.isPresent((String)typeName, (ClassLoader)classLoader);
    }

    default public boolean isGroovyPresent(ClassLoader classLoader) {
        return this.isTypePresent(classLoader, "groovy.lang.GroovyObject");
    }

    public static boolean inNativeImage() {
        return CasRuntimeHintsRegistrar.inImageBuildTimeCode() || CasRuntimeHintsRegistrar.inImageRuntimeCode() || BooleanUtils.toBoolean((String)System.getProperty(SYSTEM_PROPERTY_SPRING_AOT_PROCESSING));
    }

    public static boolean notInNativeImage() {
        return !CasRuntimeHintsRegistrar.inNativeImage();
    }

    private static boolean inImageRuntimeCode() {
        return PROPERTY_IMAGE_CODE_VALUE_RUNTIME.equals(System.getProperty(PROPERTY_IMAGE_CODE_KEY));
    }

    private static boolean inImageBuildTimeCode() {
        return PROPERTY_IMAGE_CODE_VALUE_BUILDTIME.equals(System.getProperty(PROPERTY_IMAGE_CODE_KEY));
    }

    private static void addSpringProxyInterfaces(List<Class> proxies) {
        proxies.add(SpringProxy.class);
        proxies.add(Advised.class);
        proxies.add(DecoratingProxy.class);
    }
}

