/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.codec;

import java.io.IOException;
import java.sql.SQLDataException;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Calendar;
import java.util.EnumSet;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.client.util.MutableInt;
import org.mariadb.jdbc.plugin.Codec;
import org.mariadb.jdbc.plugin.codec.ZonedDateTimeCodec;

public class LocalDateTimeCodec
implements Codec<LocalDateTime> {
    public static final LocalDateTimeCodec INSTANCE = new LocalDateTimeCodec();
    public static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS");
    public static final DateTimeFormatter TIMESTAMP_FORMAT_NO_FRACTIONAL = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter MARIADB_LOCAL_DATE_TIME;
    private static final EnumSet<DataType> COMPATIBLE_TYPES;

    public static int[] parseTimestamp(String raw) throws DateTimeException {
        int nanoLen = -1;
        int[] timestampsPart = new int[]{0, 0, 0, 0, 0, 0, 0};
        int partIdx = 0;
        for (int idx = 0; idx < raw.length(); ++idx) {
            char b = raw.charAt(idx);
            if (b == '-' || b == ' ' || b == ':') {
                ++partIdx;
                continue;
            }
            if (b == '.') {
                ++partIdx;
                nanoLen = 0;
                continue;
            }
            if (nanoLen >= 0) {
                ++nanoLen;
            }
            timestampsPart[partIdx] = timestampsPart[partIdx] * 10 + b - 48;
        }
        if (partIdx < 2) {
            throw new DateTimeException("Wrong timestamp format");
        }
        if (timestampsPart[0] == 0 && timestampsPart[1] == 0 && timestampsPart[2] == 0) {
            if (timestampsPart[3] == 0 && timestampsPart[4] == 0 && timestampsPart[5] == 0 && timestampsPart[6] == 0) {
                return null;
            }
            timestampsPart[1] = 1;
            timestampsPart[2] = 1;
        }
        if (nanoLen >= 0) {
            for (int begin = 0; begin < 6 - nanoLen; ++begin) {
                timestampsPart[6] = timestampsPart[6] * 10;
            }
            timestampsPart[6] = timestampsPart[6] * 1000;
        }
        return timestampsPart;
    }

    @Override
    public String className() {
        return LocalDateTime.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(LocalDateTime.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof LocalDateTime;
    }

    @Override
    public LocalDateTime decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        ZonedDateTime zdt = ZonedDateTimeCodec.INSTANCE.decodeText(buf, length, column, cal, context);
        if (zdt == null) {
            return null;
        }
        return zdt.toLocalDateTime();
    }

    @Override
    public LocalDateTime decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        ZonedDateTime zdt = ZonedDateTimeCodec.INSTANCE.decodeBinary(buf, length, column, cal, context);
        if (zdt == null) {
            return null;
        }
        return zdt.toLocalDateTime();
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        LocalDateTime val = (LocalDateTime)value;
        encoder.writeByte(39);
        encoder.writeAscii(val.format(val.getNano() != 0 ? TIMESTAMP_FORMAT : TIMESTAMP_FORMAT_NO_FRACTIONAL));
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        LocalDateTime val = (LocalDateTime)value;
        int nano = val.getNano();
        if (nano > 0) {
            encoder.writeByte(11);
            encoder.writeShort((short)val.getYear());
            encoder.writeByte(val.getMonthValue());
            encoder.writeByte(val.getDayOfMonth());
            encoder.writeByte(val.getHour());
            encoder.writeByte(val.getMinute());
            encoder.writeByte(val.getSecond());
            encoder.writeInt(nano / 1000);
        } else {
            encoder.writeByte(7);
            encoder.writeShort((short)val.getYear());
            encoder.writeByte(val.getMonthValue());
            encoder.writeByte(val.getDayOfMonth());
            encoder.writeByte(val.getHour());
            encoder.writeByte(val.getMinute());
            encoder.writeByte(val.getSecond());
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.DATETIME.get();
    }

    static {
        COMPATIBLE_TYPES = EnumSet.of(DataType.DATETIME, new DataType[]{DataType.TIMESTAMP, DataType.VARSTRING, DataType.VARCHAR, DataType.STRING, DataType.TIME, DataType.YEAR, DataType.DATE, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});
        MARIADB_LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();
    }
}

