/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.validation;

import jakarta.validation.ConstraintValidatorContext;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.Attributable;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.common.validation.AbstractValidator;
import org.apache.syncope.core.persistence.common.validation.AttributableCheck;

public class AttributableValidator
extends AbstractValidator<AttributableCheck, Attributable<?>> {
    protected boolean isValid(PlainAttr<?> attr, ConstraintValidatorContext context) {
        boolean isValid;
        context.disableDefaultConstraintViolation();
        if (attr == null) {
            isValid = true;
        } else {
            if (attr.getSchema().isUniqueConstraint()) {
                isValid = attr.getValues().isEmpty() && attr.getUniqueValue() != null;
            } else {
                boolean bl = isValid = !attr.getValues().isEmpty() && attr.getUniqueValue() == null;
                if (!attr.getSchema().isMultivalue()) {
                    isValid &= attr.getValues().size() == 1;
                }
            }
            if (!isValid) {
                LOG.error("Invalid values for attribute schema={}, values={}", (Object)attr.getSchema().getKey(), (Object)attr.getValuesAsStrings());
                context.buildConstraintViolationWithTemplate(AttributableValidator.getTemplate(EntityViolationType.InvalidValueList, "Invalid values " + String.valueOf(attr.getValuesAsStrings()))).addPropertyNode(attr.getSchema().getKey()).addConstraintViolation();
            }
        }
        return isValid;
    }

    protected boolean isValid(PlainAttrValue value, ConstraintValidatorContext context) {
        boolean isValid;
        context.disableDefaultConstraintViolation();
        if (value == null) {
            isValid = true;
        } else {
            PlainSchema attrSchema;
            PlainAttrUniqueValue plainAttrUniqueValue;
            PlainSchema uniqueValueSchema;
            int nonNullVales = 0;
            if (value.getBooleanValue() != null) {
                ++nonNullVales;
            }
            if (value.getDateValue() != null) {
                ++nonNullVales;
            }
            if (value.getDoubleValue() != null) {
                ++nonNullVales;
            }
            if (value.getLongValue() != null) {
                ++nonNullVales;
            }
            if (value.getBinaryValue() != null) {
                ++nonNullVales;
            }
            if (value.getStringValue() != null) {
                ++nonNullVales;
            }
            boolean bl = isValid = nonNullVales == 1;
            if (!isValid) {
                LOG.error("More than one non-null value for {}", (Object)value);
                context.buildConstraintViolationWithTemplate(AbstractValidator.getTemplate(EntityViolationType.MoreThanOneNonNull, "More than one non-null value found")).addPropertyNode(value.getClass().getSimpleName().replaceAll("\\n", " ")).addConstraintViolation();
            } else if (value instanceof PlainAttrUniqueValue && !(isValid = (uniqueValueSchema = (plainAttrUniqueValue = (PlainAttrUniqueValue)value).getSchema()).equals((Object)(attrSchema = value.getAttr().getSchema())))) {
                LOG.error("Unique value schema for {} is {}, while owning attribute's schema is {}", new Object[]{value, uniqueValueSchema, attrSchema});
                context.buildConstraintViolationWithTemplate(AbstractValidator.getTemplate(EntityViolationType.InvalidPlainAttr, "Unique value schema is " + String.valueOf(uniqueValueSchema) + ", while owning attribute's schema is " + String.valueOf(attrSchema))).addPropertyNode("schema").addConstraintViolation();
            }
        }
        return isValid;
    }

    public boolean isValid(Attributable<?> entity, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        AtomicReference<Boolean> isValid = new AtomicReference<Boolean>(Boolean.TRUE);
        entity.getPlainAttrs().forEach(attr -> {
            isValid.getAndSet((Boolean)isValid.get() != false && this.isValid((PlainAttr<?>)attr, context));
            attr.getValues().forEach(value -> isValid.getAndSet((Boolean)isValid.get() != false && this.isValid((PlainAttrValue)value, context)));
        });
        return isValid.get();
    }
}

