/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.dao;

import jakarta.validation.ValidationException;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.runtime.SwitchBootstraps;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyMatchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.DynRealmCond;
import org.apache.syncope.core.persistence.api.dao.search.MemberCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.ResourceCond;
import org.apache.syncope.core.persistence.api.dao.search.RoleCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.GroupableRelatable;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractAnyMatchDAO
implements AnyMatchDAO {
    protected static final Logger LOG = LoggerFactory.getLogger(AnyMatchDAO.class);
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final RealmDAO realmDAO;
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final AnyUtilsFactory anyUtilsFactory;
    protected final PlainAttrValidationManager validator;
    protected final EntityFactory entityFactory;

    public AbstractAnyMatchDAO(UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, RealmDAO realmDAO, PlainSchemaDAO plainSchemaDAO, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator, EntityFactory entityFactory) {
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.realmDAO = realmDAO;
        this.plainSchemaDAO = plainSchemaDAO;
        this.anyUtilsFactory = anyUtilsFactory;
        this.validator = validator;
        this.entityFactory = entityFactory;
    }

    @Transactional(readOnly=true)
    public <T extends Any<?>> boolean matches(T any, SearchCond cond) {
        boolean not = cond.getType() == SearchCond.Type.NOT_LEAF;
        switch (cond.getType()) {
            case LEAF: 
            case NOT_LEAF: {
                Boolean match = cond.getLeaf(AnyTypeCond.class).filter(leaf -> AnyTypeKind.ANY_OBJECT == any.getType().getKind()).map(leaf -> this.matches((Any<?>)any, (AnyTypeCond)leaf, not)).orElse(null);
                if (match == null) {
                    match = cond.getLeaf(RelationshipTypeCond.class).filter(leaf -> any instanceof GroupableRelatable).map(leaf -> this.matches((GroupableRelatable<?, ?, ?, ?, ?>)((GroupableRelatable)any), (RelationshipTypeCond)leaf, not)).orElse(null);
                }
                if (match == null) {
                    match = cond.getLeaf(RelationshipCond.class).filter(leaf -> any instanceof GroupableRelatable).map(leaf -> this.matches((GroupableRelatable<?, ?, ?, ?, ?>)((GroupableRelatable)any), (RelationshipCond)leaf, not)).orElse(null);
                }
                if (match == null) {
                    match = cond.getLeaf(MembershipCond.class).filter(leaf -> any instanceof GroupableRelatable).map(leaf -> this.matches((GroupableRelatable<?, ?, ?, ?, ?>)((GroupableRelatable)any), (MembershipCond)leaf, not)).orElse(null);
                }
                if (match == null) {
                    match = cond.getLeaf(RoleCond.class).filter(leaf -> any instanceof User).map(leaf -> this.matches((User)any, (RoleCond)leaf, not)).orElse(null);
                }
                if (match == null) {
                    match = cond.getLeaf(DynRealmCond.class).map(leaf -> this.matches((Any<?>)any, (DynRealmCond)leaf, not)).orElse(null);
                }
                if (match == null) {
                    match = cond.getLeaf(MemberCond.class).filter(leaf -> any instanceof Group).map(leaf -> this.matches((Group)any, (MemberCond)leaf, not)).orElse(null);
                }
                if (match == null) {
                    match = cond.getLeaf(ResourceCond.class).map(leaf -> this.matches((Any<?>)any, (ResourceCond)leaf, not)).orElse(null);
                }
                if (match == null) {
                    match = cond.getLeaf(AnyCond.class).map(value -> this.matches((Any<?>)any, (AnyCond)value, not)).orElseGet(() -> cond.getLeaf(AttrCond.class).map(leaf -> this.matches((Any<?>)any, (AttrCond)leaf, not)).orElse(null));
                }
                if (match == null) {
                    match = cond.getLeaf(AttrCond.class).map(leaf -> this.matches((Any<?>)any, (AttrCond)leaf, not)).orElse(null);
                }
                return BooleanUtils.toBoolean((Boolean)match);
            }
            case AND: {
                return this.matches(any, cond.getLeft()) && this.matches(any, cond.getRight());
            }
            case OR: {
                return this.matches(any, cond.getLeft()) || this.matches(any, cond.getRight());
            }
        }
        return false;
    }

    protected boolean matches(Any<?> any, AnyTypeCond cond, boolean not) {
        boolean equals = any.getType().getKey().equals(cond.getAnyTypeKey());
        return not ? !equals : equals;
    }

    protected boolean matches(GroupableRelatable<?, ?, ?, ?, ?> any, RelationshipTypeCond cond, boolean not) {
        boolean found = any.getRelationships().stream().anyMatch(rel -> rel.getType().getKey().equals(cond.getRelationshipTypeKey()));
        return not ? !found : found;
    }

    protected boolean matches(GroupableRelatable<?, ?, ?, ?, ?> any, RelationshipCond cond, boolean not) {
        boolean found;
        Set<String> candidates = SyncopeConstants.UUID_PATTERN.matcher(cond.getAnyObject()).matches() ? Set.of(cond.getAnyObject()) : this.anyObjectDAO.findByName(cond.getAnyObject()).stream().map(Entity::getKey).collect(Collectors.toSet());
        boolean bl = found = any.getRelationships().stream().map(r -> r.getRightEnd().getKey()).filter(candidates::contains).count() > 0L;
        return not ? !found : found;
    }

    protected boolean matches(GroupableRelatable<?, ?, ?, ?, ?> any, MembershipCond cond, boolean not) {
        boolean found;
        String group;
        String string = group = SyncopeConstants.UUID_PATTERN.matcher(cond.getGroup()).matches() ? cond.getGroup() : (String)this.groupDAO.findKey(cond.getGroup()).orElseThrow(() -> new NotFoundException("Group " + cond.getGroup()));
        boolean bl = any.getMembership(group).isPresent() || (any instanceof User ? this.userDAO.findDynGroups(any.getKey()) : this.anyObjectDAO.findDynGroups(any.getKey())).stream().anyMatch(item -> item.getKey().equals(group)) ? true : (found = false);
        return not ? !found : found;
    }

    protected boolean matches(User user, RoleCond cond, boolean not) {
        boolean found = this.userDAO.findAllRoles(user).stream().anyMatch(role -> role.getKey().equals(cond.getRole()));
        return not ? !found : found;
    }

    protected boolean matches(Any<?> any, DynRealmCond cond, boolean not) {
        boolean found = this.anyUtilsFactory.getInstance(any).dao().findDynRealms(any.getKey()).stream().anyMatch(dynRealm -> dynRealm.equals(cond.getDynRealm()));
        return not ? !found : found;
    }

    protected boolean matches(Group group, MemberCond cond, boolean not) {
        boolean found = false;
        GroupableRelatable any = this.userDAO.findById(cond.getMember()).orElse(null);
        if (any == null) {
            any = this.anyObjectDAO.findById(cond.getMember()).orElse(null);
            if (any != null) {
                found = this.groupDAO.findAMemberships(group).stream().anyMatch(memb -> ((AnyObject)memb.getLeftEnd()).getKey().equals(cond.getMember())) || this.groupDAO.findADynMembers(group).contains(cond.getMember());
            }
        } else {
            boolean bl = found = this.groupDAO.findUMemberships(group).stream().anyMatch(memb -> ((User)memb.getLeftEnd()).getKey().equals(cond.getMember())) || this.groupDAO.findUDynMembers(group).contains(cond.getMember());
        }
        return not ? !found : found;
    }

    protected boolean matches(Any<?> any, ResourceCond cond, boolean not) {
        boolean found = this.anyUtilsFactory.getInstance(any).getAllResources(any).stream().anyMatch(resource -> resource.getKey().equals(cond.getResource()));
        return not ? !found : found;
    }

    protected boolean matches(List<? extends PlainAttrValue> anyAttrValues, PlainAttrValue attrValue, PlainSchema schema, AttrCond cond) {
        return anyAttrValues.stream().anyMatch(item -> {
            switch (cond.getType()) {
                case EQ: {
                    return attrValue.getValue().equals(item.getValue());
                }
                case IEQ: {
                    if (schema.getType().isStringClass()) {
                        return attrValue.getStringValue().equalsIgnoreCase(item.getStringValue());
                    }
                    LOG.error("IEQ is only compatible with string or enum schemas");
                    return false;
                }
                case LIKE: 
                case ILIKE: {
                    if (schema.getType().isStringClass()) {
                        StringBuilder output = new StringBuilder();
                        for (char c : cond.getExpression().toLowerCase().toCharArray()) {
                            if (c == '%') {
                                output.append(".*");
                                continue;
                            }
                            if (Character.isLetter(c)) {
                                output.append('[').append(c).append(Character.toUpperCase(c)).append(']');
                                continue;
                            }
                            output.append(c);
                        }
                        return (cond.getType() == AttrCond.Type.LIKE ? Pattern.compile(output.toString()) : Pattern.compile(output.toString(), 2)).matcher(item.getStringValue()).matches();
                    }
                    LOG.error("LIKE is only compatible with string or enum schemas");
                    return false;
                }
                case GT: {
                    return ((Comparable)item.getValue()).compareTo(attrValue.getValue()) > 0;
                }
                case GE: {
                    return ((Comparable)item.getValue()).compareTo(attrValue.getValue()) >= 0;
                }
                case LT: {
                    return ((Comparable)item.getValue()).compareTo(attrValue.getValue()) < 0;
                }
                case LE: {
                    return ((Comparable)item.getValue()).compareTo(attrValue.getValue()) <= 0;
                }
            }
            return false;
        });
    }

    protected boolean matches(Any<?> any, AttrCond cond, boolean not) {
        boolean found;
        PlainSchema schema = this.plainSchemaDAO.findById(cond.getSchema()).orElse(null);
        if (schema == null) {
            LOG.warn("Ignoring invalid schema '{}'", (Object)cond.getSchema());
            return false;
        }
        Optional attr = any.getPlainAttr(cond.getSchema());
        switch (cond.getType()) {
            case ISNULL: {
                found = attr.isEmpty();
                break;
            }
            case ISNOTNULL: {
                found = attr.isPresent();
                break;
            }
            default: {
                PlainAttrValue attrValue = this.anyUtilsFactory.getInstance(any).newPlainAttrValue();
                try {
                    if (cond.getType() != AttrCond.Type.LIKE && cond.getType() != AttrCond.Type.ILIKE && cond.getType() != AttrCond.Type.ISNULL && cond.getType() != AttrCond.Type.ISNOTNULL) {
                        this.validator.validate(schema, cond.getExpression(), attrValue);
                    }
                }
                catch (ValidationException e) {
                    LOG.error("Could not validate expression '{}'", (Object)cond.getExpression(), (Object)e);
                    return false;
                }
                found = attr.map(a -> this.matches(a.getValues(), attrValue, schema, cond)).orElse(false);
            }
        }
        return not ? !found : found;
    }

    protected abstract void relationshipFieldMatches(PropertyDescriptor var1, AnyCond var2, PlainSchema var3);

    protected boolean matches(Any<?> any, AnyCond cond, boolean not) {
        boolean found;
        Object anyAttrValue;
        PropertyDescriptor pd;
        if ("key".equals(cond.getSchema())) {
            cond.setSchema("id");
        }
        try {
            pd = BeanUtils.getPropertyDescriptor((Class)any.getClass(), (String)cond.getSchema());
            if (pd == null) {
                LOG.warn("Ignoring invalid schema '{}'", (Object)cond.getSchema());
                return false;
            }
            anyAttrValue = pd.getReadMethod().invoke(any, new Object[0]);
        }
        catch (Exception e) {
            LOG.error("While accessing {}.{}", new Object[]{any, cond.getSchema(), e});
            return false;
        }
        switch (cond.getType()) {
            case ISNULL: {
                found = anyAttrValue == null;
                break;
            }
            case ISNOTNULL: {
                found = anyAttrValue != null;
                break;
            }
            default: {
                PlainSchema schema = (PlainSchema)this.entityFactory.newEntity(PlainSchema.class);
                schema.setKey(pd.getName());
                for (AttrSchemaType attrSchemaType : AttrSchemaType.values()) {
                    if (!pd.getPropertyType().isAssignableFrom(attrSchemaType.getType())) continue;
                    schema.setType(attrSchemaType);
                }
                boolean foundBooleanMin = false;
                boolean foundBooleanMax = false;
                if (Integer.class.equals(pd.getPropertyType())) {
                    for (Annotation annotation : pd.getPropertyType().getAnnotations()) {
                        if (Min.class.equals(annotation.annotationType())) {
                            foundBooleanMin = ((Min)annotation).value() == 0L;
                            continue;
                        }
                        if (!Max.class.equals(annotation.annotationType())) continue;
                        foundBooleanMax = ((Max)annotation).value() == 1L;
                    }
                }
                if (foundBooleanMin && foundBooleanMax) {
                    schema.setType(AttrSchemaType.Boolean);
                }
                this.relationshipFieldMatches(pd, cond, schema);
                AnyUtils anyUtils = this.anyUtilsFactory.getInstance(any);
                PlainAttrValue attrValue = anyUtils.newPlainAttrValue();
                if (cond.getType() != AttrCond.Type.LIKE && cond.getType() != AttrCond.Type.ILIKE && cond.getType() != AttrCond.Type.ISNULL && cond.getType() != AttrCond.Type.ISNOTNULL) {
                    try {
                        this.validator.validate(schema, cond.getExpression(), attrValue);
                    }
                    catch (ValidationException e) {
                        LOG.error("Could not validate expression '{}'", (Object)cond.getExpression(), (Object)e);
                        return false;
                    }
                }
                ArrayList<PlainAttrValue> anyAttrValues = new ArrayList<PlainAttrValue>();
                anyAttrValues.add(anyUtils.newPlainAttrValue());
                Object object = anyAttrValue;
                Objects.requireNonNull(object);
                Object object2 = object;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Long.class, Double.class, Boolean.class, OffsetDateTime.class, byte[].class}, (Object)object2, n)) {
                    case 0: {
                        String aString = (String)object2;
                        ((PlainAttrValue)anyAttrValues.get(0)).setStringValue(aString);
                        break;
                    }
                    case 1: {
                        Long aLong = (Long)object2;
                        ((PlainAttrValue)anyAttrValues.get(0)).setLongValue(aLong);
                        break;
                    }
                    case 2: {
                        Double aDouble = (Double)object2;
                        ((PlainAttrValue)anyAttrValues.get(0)).setDoubleValue(aDouble);
                        break;
                    }
                    case 3: {
                        Boolean aBoolean = (Boolean)object2;
                        ((PlainAttrValue)anyAttrValues.get(0)).setBooleanValue(aBoolean);
                        break;
                    }
                    case 4: {
                        OffsetDateTime offsetDateTime = (OffsetDateTime)object2;
                        ((PlainAttrValue)anyAttrValues.get(0)).setDateValue(offsetDateTime);
                        break;
                    }
                    case 5: {
                        byte[] bytea = (byte[])object2;
                        ((PlainAttrValue)anyAttrValues.get(0)).setBinaryValue(bytea);
                        break;
                    }
                }
                found = this.matches(anyAttrValues, attrValue, schema, (AttrCond)cond);
            }
        }
        return not ? !found : found;
    }
}

