/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common;

import jakarta.validation.Validator;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrValueDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.am.ClientAppUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.policy.PolicyUtilsFactory;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.persistence.common.attrvalue.DefaultPlainAttrValidationManager;
import org.apache.syncope.core.persistence.common.content.KeymasterConfParamLoader;
import org.apache.syncope.core.persistence.common.entity.DefaultAnyUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@Configuration(proxyBeanMethods=false)
public class CommonPersistenceContext {
    @ConditionalOnMissingBean
    @Bean
    public SearchCondVisitor searchCondVisitor() {
        return new SearchCondVisitor();
    }

    @Bean
    public Validator localValidatorFactoryBean() {
        return new LocalValidatorFactoryBean();
    }

    @ConditionalOnMissingBean
    @Bean
    public PlainAttrValidationManager plainAttrValidationManager() {
        return new DefaultPlainAttrValidationManager();
    }

    @ConditionalOnMissingBean
    @Bean
    public PolicyUtilsFactory policyUtilsFactory() {
        return new PolicyUtilsFactory();
    }

    @ConditionalOnMissingBean
    @Bean
    public ClientAppUtilsFactory clientAppUtilsFactory() {
        return new ClientAppUtilsFactory();
    }

    @Bean(name={"userAnyUtils"})
    public AnyUtils userAnyUtils(@Lazy UserDAO userDAO, @Lazy GroupDAO groupDAO, @Lazy AnyObjectDAO anyObjectDAO, @Lazy PlainSchemaDAO plainSchemaDAO, @Lazy PlainAttrValueDAO plainAttrValueDAO, @Lazy EntityFactory entityFactory) {
        return new DefaultAnyUtils(userDAO, groupDAO, anyObjectDAO, plainSchemaDAO, plainAttrValueDAO, entityFactory, AnyTypeKind.USER, false);
    }

    @Bean(name={"linkedAccountAnyUtils"})
    public AnyUtils linkedAccountAnyUtils(@Lazy UserDAO userDAO, @Lazy GroupDAO groupDAO, @Lazy AnyObjectDAO anyObjectDAO, @Lazy PlainSchemaDAO plainSchemaDAO, @Lazy PlainAttrValueDAO plainAttrValueDAO, @Lazy EntityFactory entityFactory) {
        return new DefaultAnyUtils(userDAO, groupDAO, anyObjectDAO, plainSchemaDAO, plainAttrValueDAO, entityFactory, AnyTypeKind.USER, true);
    }

    @Bean(name={"groupAnyUtils"})
    public AnyUtils groupAnyUtils(@Lazy UserDAO userDAO, @Lazy GroupDAO groupDAO, @Lazy AnyObjectDAO anyObjectDAO, @Lazy PlainSchemaDAO plainSchemaDAO, @Lazy PlainAttrValueDAO plainAttrValueDAO, @Lazy EntityFactory entityFactory) {
        return new DefaultAnyUtils(userDAO, groupDAO, anyObjectDAO, plainSchemaDAO, plainAttrValueDAO, entityFactory, AnyTypeKind.GROUP, false);
    }

    @Bean(name={"anyObjectAnyUtils"})
    public AnyUtils anyObjectAnyUtils(@Lazy UserDAO userDAO, @Lazy GroupDAO groupDAO, @Lazy AnyObjectDAO anyObjectDAO, @Lazy PlainSchemaDAO plainSchemaDAO, @Lazy PlainAttrValueDAO plainAttrValueDAO, @Lazy EntityFactory entityFactory) {
        return new DefaultAnyUtils(userDAO, groupDAO, anyObjectDAO, plainSchemaDAO, plainAttrValueDAO, entityFactory, AnyTypeKind.ANY_OBJECT, false);
    }

    @ConditionalOnMissingBean
    @Bean
    public AnyUtilsFactory anyUtilsFactory(@Qualifier(value="userAnyUtils") AnyUtils userAnyUtils, @Qualifier(value="linkedAccountAnyUtils") AnyUtils linkedAccountAnyUtils, @Qualifier(value="groupAnyUtils") AnyUtils groupAnyUtils, @Qualifier(value="anyObjectAnyUtils") AnyUtils anyObjectAnyUtils) {
        return new AnyUtilsFactory(userAnyUtils, linkedAccountAnyUtils, groupAnyUtils, anyObjectAnyUtils);
    }

    @ConditionalOnMissingBean
    @Bean
    public KeymasterConfParamLoader keymasterConfParamLoader(ConfParamOps confParamOps) {
        return new KeymasterConfParamLoader(confParamOps);
    }
}

