/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.rest;

import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class ResponseHolder
implements Serializable {
    private static final long serialVersionUID = 2627155013246805827L;
    private transient InputStream inputStream;
    private String contentType;
    private String location;
    private String filename;

    public ResponseHolder(Response response) {
        Object entity = response.getEntity();
        if (response.getStatusInfo().getStatusCode() == Response.Status.OK.getStatusCode() && entity instanceof InputStream) {
            String[] splitted;
            this.inputStream = (InputStream)entity;
            this.contentType = response.getHeaderString("Content-Type");
            this.location = response.getLocation() == null ? null : response.getLocation().toASCIIString();
            String contentDisposition = response.getHeaderString("Content-Disposition");
            if (StringUtils.isNotBlank((CharSequence)contentDisposition) && (splitted = contentDisposition.split("=")) != null && splitted.length > 1) {
                this.filename = splitted[1].trim();
            }
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFilename() {
        return this.filename;
    }
}

