/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.markup.html.form;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxGrid;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.wicketstuff.egrid.column.AbstractEditablePropertyColumn;
import org.wicketstuff.egrid.column.RequiredTextFieldColumn;
import org.wicketstuff.egrid.provider.EditableListDataProvider;
import org.wicketstuff.egrid.provider.IEditableDataProvider;

public class AjaxGridFieldPanel<K, V>
extends Panel {
    private static final long serialVersionUID = 7589570522964677729L;
    protected final AjaxGrid<K, V, String> grid;
    protected final IModel<Map<K, V>> model;

    public AjaxGridFieldPanel(String id, String name, final IModel<Map<K, V>> model) {
        super(id, model);
        this.add(new Component[]{new Label("field-label", (IModel)new ResourceModel(name, name))});
        this.grid = new AjaxGrid<K, V, String>("grid", this.getColumns(), (IEditableDataProvider)new EditableListDataProvider(((Map)model.getObject()).entrySet().stream().map(e -> MutablePair.of(e.getKey(), e.getValue())).collect(Collectors.toList()), ""), 10L){
            private static final long serialVersionUID = -1315456128897492459L;

            @Override
            protected boolean displayHeader() {
                return false;
            }

            @Override
            protected void onAdd(AjaxRequestTarget target, Pair<K, V> newRow) {
                ((Map)model.getObject()).put(newRow.getLeft(), newRow.getRight());
            }

            @Override
            protected void onDelete(AjaxRequestTarget target, IModel<Pair<K, V>> rowModel) {
                ((Map)model.getObject()).remove(((Pair)rowModel.getObject()).getLeft());
            }

            @Override
            protected void onSave(AjaxRequestTarget target, IModel<Pair<K, V>> rowModel) {
                ((Map)model.getObject()).put(((Pair)rowModel.getObject()).getLeft(), ((Pair)rowModel.getObject()).getRight());
            }
        };
        this.add(new Component[]{this.grid});
        this.model = model;
    }

    public AjaxGridFieldPanel<K, V> hideLabel() {
        Optional.ofNullable(this.get("field-label")).ifPresent(label -> label.setVisible(false));
        return this;
    }

    private List<AbstractEditablePropertyColumn<Pair<K, V>, String>> getColumns() {
        ArrayList<AbstractEditablePropertyColumn<Pair<K, V>, String>> columns = new ArrayList<AbstractEditablePropertyColumn<Pair<K, V>, String>>();
        columns.add((AbstractEditablePropertyColumn<Pair<K, V>, String>)new RequiredTextFieldColumn((IModel)Model.of(), "left"));
        columns.add((AbstractEditablePropertyColumn<Pair<K, V>, String>)new RequiredTextFieldColumn((IModel)Model.of(), "right"));
        return columns;
    }

    public AjaxGrid<K, V, String> getGrid() {
        return this.grid;
    }

    public AjaxGridFieldPanel<K, V> setModelObject(Map<K, V> object) {
        this.model.setObject(object);
        return this;
    }
}

