/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import com.google.common.collect.Multimap;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.net.ssl.TrustManager;
import javax.security.auth.login.AccountNotFoundException;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationAccountStateHandler;
import org.apereo.cas.authentication.AuthenticationPasswordPolicyHandlingStrategy;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.LdapAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.support.DefaultLdapAccountStateHandler;
import org.apereo.cas.authentication.support.OptionalWarningLdapAccountStateHandler;
import org.apereo.cas.authentication.support.RejectResultCodeLdapPasswordPolicyHandlingStrategy;
import org.apereo.cas.authentication.support.password.DefaultPasswordPolicyHandlingStrategy;
import org.apereo.cas.authentication.support.password.GroovyPasswordPolicyHandlingStrategy;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.authentication.support.password.PasswordPolicyContext;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordPolicyProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapAuthenticationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.ldap.CaseChangeSearchEntryHandlersProperties;
import org.apereo.cas.configuration.model.support.ldap.DnAttributeSearchEntryHandlersProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapAuthenticationProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapPasswordPolicyProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapSearchEntryHandlersProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapValidatorProperties;
import org.apereo.cas.configuration.model.support.ldap.MergeAttributesSearchEntryHandlersProperties;
import org.apereo.cas.configuration.model.support.ldap.PrimaryGroupIdSearchEntryHandlersProperties;
import org.apereo.cas.configuration.model.support.ldap.RecursiveSearchEntryHandlersProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.persondir.ActiveDirectoryLdapEntryHandler;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.jooq.lambda.Unchecked;
import org.ldaptive.ActivePassiveConnectionStrategy;
import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.BindRequest;
import org.ldaptive.CompareConnectionValidator;
import org.ldaptive.CompareRequest;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.ConnectionInitializer;
import org.ldaptive.ConnectionStrategy;
import org.ldaptive.ConnectionValidator;
import org.ldaptive.Credential;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.DerefAliases;
import org.ldaptive.DnsSrvConnectionStrategy;
import org.ldaptive.FilterTemplate;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.PooledConnectionFactory;
import org.ldaptive.RandomConnectionStrategy;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.RoundRobinConnectionStrategy;
import org.ldaptive.SearchConnectionValidator;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.SearchScope;
import org.ldaptive.SimpleBindRequest;
import org.ldaptive.ad.extended.FastBindConnectionInitializer;
import org.ldaptive.ad.handler.ObjectGuidHandler;
import org.ldaptive.ad.handler.ObjectSidHandler;
import org.ldaptive.ad.handler.PrimaryGroupIdHandler;
import org.ldaptive.ad.handler.RangeEntryHandler;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.auth.AuthenticationHandler;
import org.ldaptive.auth.AuthenticationHandlerResponse;
import org.ldaptive.auth.AuthenticationRequestHandler;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.CompareAuthenticationHandler;
import org.ldaptive.auth.DnResolver;
import org.ldaptive.auth.EntryResolver;
import org.ldaptive.auth.FormatDnResolver;
import org.ldaptive.auth.SearchDnResolver;
import org.ldaptive.auth.SearchEntryResolver;
import org.ldaptive.auth.SimpleBindAuthenticationHandler;
import org.ldaptive.auth.User;
import org.ldaptive.auth.ext.ActiveDirectoryAuthenticationResponseHandler;
import org.ldaptive.auth.ext.EDirectoryAuthenticationResponseHandler;
import org.ldaptive.auth.ext.FreeIPAAuthenticationResponseHandler;
import org.ldaptive.auth.ext.PasswordExpirationAuthenticationResponseHandler;
import org.ldaptive.auth.ext.PasswordPolicyAuthenticationRequestHandler;
import org.ldaptive.auth.ext.PasswordPolicyAuthenticationResponseHandler;
import org.ldaptive.handler.CaseChangeEntryHandler;
import org.ldaptive.handler.DnAttributeEntryHandler;
import org.ldaptive.handler.LdapEntryHandler;
import org.ldaptive.handler.MergeAttributeEntryHandler;
import org.ldaptive.handler.MergeResultHandler;
import org.ldaptive.handler.RecursiveResultHandler;
import org.ldaptive.handler.SearchResultHandler;
import org.ldaptive.pool.BindConnectionPassivator;
import org.ldaptive.pool.ConnectionPassivator;
import org.ldaptive.pool.IdlePruneStrategy;
import org.ldaptive.pool.PruneStrategy;
import org.ldaptive.referral.FollowSearchReferralHandler;
import org.ldaptive.referral.FollowSearchResultReferenceHandler;
import org.ldaptive.sasl.Mechanism;
import org.ldaptive.sasl.QualityOfProtection;
import org.ldaptive.sasl.SaslConfig;
import org.ldaptive.sasl.SecurityStrength;
import org.ldaptive.ssl.AllowAnyHostnameVerifier;
import org.ldaptive.ssl.AllowAnyTrustManager;
import org.ldaptive.ssl.CertificateHostnameVerifier;
import org.ldaptive.ssl.CredentialConfig;
import org.ldaptive.ssl.DefaultHostnameVerifier;
import org.ldaptive.ssl.DefaultTrustManager;
import org.ldaptive.ssl.KeyStoreCredentialConfig;
import org.ldaptive.ssl.SslConfig;
import org.ldaptive.ssl.X509CredentialConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public final class LdapUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapUtils.class);
    public static final String LDAP_SEARCH_FILTER_DEFAULT_PARAM_NAME = "user";
    public static final String OBJECT_CLASS_ATTRIBUTE = "objectClass";
    private static final String BASE_DN_DELIMITER = "|";
    private static final String LDAP_PREFIX = "ldap";

    public static Boolean getBoolean(LdapEntry ctx, String attribute, Boolean nullValue) {
        String v = LdapUtils.getString(ctx, attribute, nullValue.toString());
        return v.equalsIgnoreCase(Boolean.TRUE.toString());
    }

    public static Long getLong(LdapEntry entry, String attribute, Long nullValue) {
        String v = LdapUtils.getString(entry, attribute, String.valueOf(nullValue));
        return Long.valueOf(v);
    }

    public static String getString(LdapEntry entry, String attribute) {
        return LdapUtils.getString(entry, attribute, null);
    }

    public static String getString(LdapEntry entry, String attribute, String nullValue) {
        String v;
        LdapAttribute attr = entry.getAttribute(attribute);
        if (attr == null) {
            return nullValue;
        }
        String string = v = attr.isBinary() ? new String(attr.getBinaryValue(), StandardCharsets.UTF_8) : attr.getStringValue();
        if (StringUtils.isNotBlank((CharSequence)v)) {
            return v;
        }
        return nullValue;
    }

    public static boolean containsResultEntry(SearchResponse response) {
        return response != null && response.getEntry() != null;
    }

    public static boolean isLdapConnectionUrl(String r) {
        return r.toLowerCase(Locale.ENGLISH).startsWith(LDAP_PREFIX);
    }

    public static boolean isLdapConnectionUrl(URI r) {
        return r.getScheme().equalsIgnoreCase(LDAP_PREFIX);
    }

    public static boolean isLdapConnectionUrl(URL r) {
        return r.getProtocol().equalsIgnoreCase(LDAP_PREFIX);
    }

    public static SearchRequest newLdaptiveSearchRequest(String baseDn, FilterTemplate filter, String[] binaryAttributes, String[] returnAttributes) {
        SearchRequest sr = new SearchRequest(baseDn, filter, new String[0]);
        sr.setBinaryAttributes(binaryAttributes);
        sr.setReturnAttributes(returnAttributes);
        sr.setSearchScope(SearchScope.SUBTREE);
        return sr;
    }

    public static SearchRequest newLdaptiveSearchRequest(String baseDn, String filterQuery, List<String> params, String[] returnAttributes) {
        SearchRequest request = new SearchRequest();
        request.setBaseDn(baseDn);
        request.setFilter(LdapUtils.newLdaptiveSearchFilter(filterQuery, params));
        request.setReturnAttributes(returnAttributes);
        request.setSearchScope(SearchScope.SUBTREE);
        return request;
    }

    public static SearchRequest newLdaptiveSearchRequest(String baseDn, FilterTemplate filter) {
        return LdapUtils.newLdaptiveSearchRequest(baseDn, filter, ReturnAttributes.ALL_USER.value(), ReturnAttributes.ALL_USER.value());
    }

    public static FilterTemplate newLdaptiveSearchFilter(String filterQuery) {
        return LdapUtils.newLdaptiveSearchFilter(filterQuery, new ArrayList<String>(0));
    }

    public static FilterTemplate newLdaptiveSearchFilter(String filterQuery, List<String> params) {
        return LdapUtils.newLdaptiveSearchFilter(filterQuery, LDAP_SEARCH_FILTER_DEFAULT_PARAM_NAME, params);
    }

    public static FilterTemplate newLdaptiveSearchFilter(String filterQuery, String paramName, List<String> params) {
        return LdapUtils.newLdaptiveSearchFilter(filterQuery, List.of(paramName), params);
    }

    public static FilterTemplate newLdaptiveSearchFilter(String filterQuery, List<String> paramName, List<String> values) {
        FilterTemplate filter = new FilterTemplate();
        if (ResourceUtils.doesResourceExist((String)filterQuery)) {
            ApplicationContextProvider.getScriptResourceCacheManager().ifPresentOrElse(cacheMgr -> FunctionUtils.doUnchecked(__ -> {
                String cacheKey = cacheMgr.computeKey(new String[]{filterQuery});
                ExecutableCompiledScript script = null;
                if (cacheMgr.containsKey(cacheKey)) {
                    script = cacheMgr.get(cacheKey);
                    LOGGER.trace("Located cached groovy script [{}] for key [{}]", (Object)script, (Object)cacheKey);
                } else {
                    AbstractResource resource = (AbstractResource)Unchecked.supplier(() -> ResourceUtils.getRawResourceFrom((String)filterQuery)).get();
                    LOGGER.trace("Groovy script [{}] for key [{}] is not cached", (Object)resource, (Object)cacheKey);
                    ExecutableCompiledScriptFactory scriptFactory = ExecutableCompiledScriptFactory.getExecutableCompiledScriptFactory();
                    script = scriptFactory.fromResource((Resource)resource);
                    cacheMgr.put(cacheKey, script);
                    LOGGER.trace("Cached groovy script [{}] for key [{}]", (Object)script, (Object)cacheKey);
                }
                if (script != null) {
                    LinkedHashMap parameters = IntStream.range(0, values.size()).boxed().collect(Collectors.toMap(paramName::get, values::get, (a, b) -> b, LinkedHashMap::new));
                    Map args = CollectionUtils.wrap((String)"filter", (Object)filter, (String)"parameters", (Object)parameters, (String)"applicationContext", (Object)ApplicationContextProvider.getApplicationContext(), (String)"logger", (Object)LOGGER);
                    script.setBinding(args);
                    script.execute(args.values().toArray(), FilterTemplate.class);
                }
            }, (Object[])new Object[0]), () -> {
                throw new RuntimeException("Script cache manager unavailable to handle LDAP filter");
            });
        } else {
            filter.setFilter(filterQuery);
            if (values != null) {
                IntStream.range(0, values.size()).forEach(i -> {
                    String value = (String)values.get(i);
                    if (filter.getFilter().contains("{" + i + "}")) {
                        filter.setParameter(i, (Object)value);
                    }
                    String name = (String)paramName.get(i);
                    if (filter.getFilter().contains("{" + name + "}")) {
                        filter.setParameter(name, (Object)value);
                    }
                });
            }
        }
        LOGGER.debug("Constructed LDAP search filter [{}]", (Object)filter.format());
        return filter;
    }

    public static SearchOperation newLdaptiveSearchOperation(String baseDn, String filterQuery, List<String> params) {
        return LdapUtils.newLdaptiveSearchOperation(baseDn, filterQuery, params, List.of(ReturnAttributes.ALL.value()));
    }

    public static SearchOperation newLdaptiveSearchOperation(String baseDn, String filterQuery, List<String> params, List<String> returnAttributes) {
        SearchOperation operation = new SearchOperation();
        SearchRequest request = LdapUtils.newLdaptiveSearchRequest(baseDn, filterQuery, params, returnAttributes.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        operation.setRequest(request);
        operation.setTemplate(LdapUtils.newLdaptiveSearchFilter(filterQuery, params));
        return operation;
    }

    public static SearchOperation newLdaptiveSearchOperation(String baseDn, String filterQuery) {
        return LdapUtils.newLdaptiveSearchOperation(baseDn, filterQuery, new ArrayList<String>(0));
    }

    public static Authenticator newLdaptiveAuthenticator(AbstractLdapAuthenticationProperties props) {
        switch (props.getType()) {
            case AD: {
                LOGGER.debug("Creating active directory authenticator for [{}]", (Object)props.getLdapUrl());
                return LdapUtils.getActiveDirectoryAuthenticator(props);
            }
            case DIRECT: {
                LOGGER.debug("Creating direct-bind authenticator for [{}]", (Object)props.getLdapUrl());
                return LdapUtils.getDirectBindAuthenticator(props);
            }
            case AUTHENTICATED: {
                LOGGER.debug("Creating authenticated authenticator for [{}]", (Object)props.getLdapUrl());
                return LdapUtils.getAuthenticatedOrAnonSearchAuthenticator(props);
            }
        }
        LOGGER.debug("Creating anonymous authenticator for [{}]", (Object)props.getLdapUrl());
        return LdapUtils.getAuthenticatedOrAnonSearchAuthenticator(props);
    }

    public static PooledConnectionFactory newLdaptivePooledConnectionFactory(AbstractLdapProperties props) {
        AbstractLdapProperties.LdapConnectionPoolPassivator pass;
        ConnectionConfig connectionConfig = LdapUtils.newLdaptiveConnectionConfig(props);
        LOGGER.debug("Creating LDAP connection pool configuration for [{}]", (Object)props.getLdapUrl());
        PooledConnectionFactory pooledCf = new PooledConnectionFactory(connectionConfig);
        pooledCf.setMinPoolSize(props.getMinPoolSize());
        pooledCf.setMaxPoolSize(props.getMaxPoolSize());
        pooledCf.setValidateOnCheckOut(props.isValidateOnCheckout());
        pooledCf.setValidatePeriodically(props.isValidatePeriodically());
        pooledCf.setBlockWaitTime(Beans.newDuration((String)props.getBlockWaitTime()));
        IdlePruneStrategy strategy = new IdlePruneStrategy();
        strategy.setIdleTime(Beans.newDuration((String)props.getIdleTime()));
        strategy.setPrunePeriod(Beans.newDuration((String)props.getPrunePeriod()));
        pooledCf.setPruneStrategy((PruneStrategy)strategy);
        LdapValidatorProperties validator = props.getValidator();
        switch (validator.getType().trim().toLowerCase(Locale.ENGLISH)) {
            case "compare": {
                CompareRequest compareRequest = new CompareRequest(validator.getDn(), validator.getAttributeName(), validator.getAttributeValue());
                CompareConnectionValidator compareValidator = new CompareConnectionValidator(compareRequest);
                compareValidator.setValidatePeriod(Beans.newDuration((String)props.getValidatePeriod()));
                compareValidator.setValidateTimeout(Beans.newDuration((String)props.getValidateTimeout()));
                pooledCf.setValidator((ConnectionValidator)compareValidator);
                break;
            }
            case "none": {
                LOGGER.debug("No validator is configured for the LDAP connection pool of [{}]", (Object)props.getLdapUrl());
                break;
            }
            case "search": {
                SearchRequest searchRequest = new SearchRequest();
                searchRequest.setBaseDn(validator.getBaseDn());
                searchRequest.setFilter(validator.getSearchFilter());
                searchRequest.setReturnAttributes(ReturnAttributes.NONE.value());
                searchRequest.setSearchScope(SearchScope.valueOf((String)validator.getScope()));
                searchRequest.setSizeLimit(1);
                SearchConnectionValidator searchValidator = new SearchConnectionValidator(searchRequest);
                searchValidator.setValidatePeriod(Beans.newDuration((String)props.getValidatePeriod()));
                searchValidator.setValidateTimeout(Beans.newDuration((String)props.getValidateTimeout()));
                pooledCf.setValidator((ConnectionValidator)searchValidator);
            }
        }
        pooledCf.setFailFastInitialize(props.isFailFast());
        if (StringUtils.isNotBlank((CharSequence)props.getPoolPassivator()) && (pass = AbstractLdapProperties.LdapConnectionPoolPassivator.valueOf((String)props.getPoolPassivator().toUpperCase(Locale.ENGLISH))) == AbstractLdapProperties.LdapConnectionPoolPassivator.BIND) {
            if (StringUtils.isNotBlank((CharSequence)props.getBindDn()) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{props.getBindCredential()})) {
                SimpleBindRequest bindRequest = new SimpleBindRequest(props.getBindDn(), props.getBindCredential());
                pooledCf.setPassivator((ConnectionPassivator)new BindConnectionPassivator((BindRequest)bindRequest));
                LOGGER.debug("Created [{}] passivator for [{}]", (Object)props.getPoolPassivator(), (Object)props.getLdapUrl());
            } else {
                List values = Arrays.stream(AbstractLdapProperties.LdapConnectionPoolPassivator.values()).filter(v -> v != AbstractLdapProperties.LdapConnectionPoolPassivator.BIND).collect(Collectors.toList());
                LOGGER.warn("[{}] pool passivator could not be created for [{}] given bind credentials are not specified. If you are dealing with LDAP in such a way that does not require bind credentials, you may need to set the pool passivator setting to one of [{}]", new Object[]{props.getPoolPassivator(), props.getLdapUrl(), values});
            }
        }
        LOGGER.debug("Initializing ldap connection pool for [{}] and bindDn [{}]", (Object)props.getLdapUrl(), (Object)props.getBindDn());
        pooledCf.initialize();
        return pooledCf;
    }

    public static ConnectionConfig newLdaptiveConnectionConfig(AbstractLdapProperties properties) {
        if (StringUtils.isBlank((CharSequence)properties.getLdapUrl())) {
            throw new IllegalArgumentException("LDAP url cannot be empty/blank");
        }
        LOGGER.debug("Creating LDAP connection configuration for [{}]", (Object)properties.getLdapUrl());
        ConnectionConfig connectionConfig = new ConnectionConfig();
        String urls = properties.getLdapUrl().contains(" ") ? properties.getLdapUrl() : String.join((CharSequence)" ", properties.getLdapUrl().split(","));
        LOGGER.debug("Transformed LDAP urls from [{}] to [{}]", (Object)properties.getLdapUrl(), (Object)urls);
        connectionConfig.setLdapUrl(urls);
        connectionConfig.setUseStartTLS(properties.isUseStartTls());
        connectionConfig.setConnectTimeout(Beans.newDuration((String)properties.getConnectTimeout()));
        connectionConfig.setResponseTimeout(Beans.newDuration((String)properties.getResponseTimeout()));
        if (StringUtils.isNotBlank((CharSequence)properties.getConnectionStrategy())) {
            AbstractLdapProperties.LdapConnectionStrategy strategy = AbstractLdapProperties.LdapConnectionStrategy.valueOf((String)properties.getConnectionStrategy());
            switch (strategy) {
                case RANDOM: {
                    connectionConfig.setConnectionStrategy((ConnectionStrategy)new RandomConnectionStrategy());
                    break;
                }
                case DNS_SRV: {
                    connectionConfig.setConnectionStrategy((ConnectionStrategy)new DnsSrvConnectionStrategy());
                    break;
                }
                case ROUND_ROBIN: {
                    connectionConfig.setConnectionStrategy((ConnectionStrategy)new RoundRobinConnectionStrategy());
                    break;
                }
                case ACTIVE_PASSIVE: {
                    connectionConfig.setConnectionStrategy((ConnectionStrategy)new ActivePassiveConnectionStrategy());
                }
            }
        }
        if (properties.getTrustCertificates() != null) {
            LOGGER.debug("Creating LDAP SSL configuration via trust certificates [{}]", (Object)properties.getTrustCertificates());
            cfg = new X509CredentialConfig();
            cfg.setTrustCertificates(properties.getTrustCertificates());
            connectionConfig.setSslConfig(new SslConfig((CredentialConfig)cfg));
        } else if (properties.getTrustStore() != null || properties.getKeystore() != null) {
            cfg = new KeyStoreCredentialConfig();
            FunctionUtils.doIfNotNull((Object)properties.getTrustStore(), store -> {
                String activeTrustStore = SpringExpressionLanguageValueResolver.getInstance().resolve(store);
                LOGGER.trace("Creating LDAP SSL configuration with truststore [{}]", (Object)activeTrustStore);
                cfg.setTrustStore(activeTrustStore);
                cfg.setTrustStoreType(properties.getTrustStoreType());
                String password = SpringExpressionLanguageValueResolver.getInstance().resolve(properties.getTrustStorePassword());
                cfg.setTrustStorePassword(password);
            });
            FunctionUtils.doIfNotNull((Object)properties.getKeystore(), store -> {
                String activeStore = SpringExpressionLanguageValueResolver.getInstance().resolve(store);
                LOGGER.trace("Creating LDAP SSL configuration via keystore [{}]", (Object)activeStore);
                cfg.setKeyStore(activeStore);
                cfg.setKeyStoreType(properties.getKeystoreType());
                String password = SpringExpressionLanguageValueResolver.getInstance().resolve(properties.getKeystorePassword());
                cfg.setKeyStorePassword(password);
            });
            connectionConfig.setSslConfig(new SslConfig((CredentialConfig)cfg));
        } else {
            LOGGER.debug("Creating LDAP SSL configuration via the native JVM truststore");
            connectionConfig.setSslConfig(new SslConfig());
        }
        SslConfig sslConfig = connectionConfig.getSslConfig();
        if (sslConfig != null) {
            switch (properties.getHostnameVerifier()) {
                case ANY: {
                    sslConfig.setHostnameVerifier((CertificateHostnameVerifier)new AllowAnyHostnameVerifier());
                    break;
                }
                case DEFAULT: {
                    sslConfig.setHostnameVerifier((CertificateHostnameVerifier)new DefaultHostnameVerifier());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getTrustManager())) {
                String manager = properties.getTrustManager().trim().toUpperCase(Locale.ENGLISH);
                switch (AbstractLdapProperties.LdapTrustManagerOptions.valueOf((String)manager)) {
                    case ANY: {
                        sslConfig.setTrustManagers(new TrustManager[]{new AllowAnyTrustManager()});
                        break;
                    }
                    case DEFAULT: {
                        sslConfig.setTrustManagers(new TrustManager[]{new DefaultTrustManager()});
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)properties.getSaslMechanism())) {
            LOGGER.debug("Creating LDAP SASL mechanism via [{}]", (Object)properties.getSaslMechanism());
            BindConnectionInitializer initializer = new BindConnectionInitializer();
            SaslConfig saslConfig = LdapUtils.getSaslConfigFrom(properties);
            FunctionUtils.doIfNotBlank((CharSequence)properties.getSaslAuthorizationId(), __ -> saslConfig.setAuthorizationId(properties.getSaslAuthorizationId()));
            saslConfig.setMutualAuthentication(properties.getSaslMutualAuth());
            if (StringUtils.isNotBlank((CharSequence)properties.getSaslQualityOfProtection())) {
                saslConfig.setQualityOfProtection(new QualityOfProtection[]{QualityOfProtection.valueOf((String)properties.getSaslQualityOfProtection())});
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getSaslSecurityStrength())) {
                saslConfig.setSecurityStrength(new SecurityStrength[]{SecurityStrength.valueOf((String)properties.getSaslSecurityStrength())});
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getBindDn())) {
                initializer.setBindDn(properties.getBindDn());
                if (StringUtils.isNotBlank((CharSequence)properties.getBindCredential())) {
                    initializer.setBindCredential(new Credential(properties.getBindCredential()));
                }
            }
            initializer.setBindSaslConfig(saslConfig);
            connectionConfig.setConnectionInitializers(new ConnectionInitializer[]{initializer});
        } else if (StringUtils.equals((CharSequence)properties.getBindCredential(), (CharSequence)"*") && StringUtils.equals((CharSequence)properties.getBindDn(), (CharSequence)"*")) {
            LOGGER.debug("Creating LDAP fast-bind connection initializer");
            connectionConfig.setConnectionInitializers(new ConnectionInitializer[]{new FastBindConnectionInitializer()});
        } else if (StringUtils.isNotBlank((CharSequence)properties.getBindDn()) && StringUtils.isNotBlank((CharSequence)properties.getBindCredential())) {
            LOGGER.debug("Creating LDAP bind connection initializer via [{}]", (Object)properties.getBindDn());
            connectionConfig.setConnectionInitializers(new ConnectionInitializer[]{new BindConnectionInitializer(properties.getBindDn(), new Credential(properties.getBindCredential()))});
        }
        return connectionConfig;
    }

    public static ConnectionFactory newLdaptiveConnectionFactory(AbstractLdapProperties properties) {
        return properties.isDisablePooling() ? LdapUtils.newLdaptiveDefaultConnectionFactory(properties) : LdapUtils.newLdaptivePooledConnectionFactory(properties);
    }

    public static EntryResolver newLdaptiveSearchEntryResolver(AbstractLdapAuthenticationProperties properties, ConnectionFactory factory) {
        List resolvers = Arrays.stream(StringUtils.split((String)properties.getBaseDn(), (String)BASE_DN_DELIMITER)).map(baseDn -> {
            SearchEntryResolver entryResolver = new SearchEntryResolver();
            entryResolver.setBaseDn(baseDn.trim());
            entryResolver.setUserFilter(properties.getSearchFilter());
            entryResolver.setSubtreeSearch(properties.isSubtreeSearch());
            entryResolver.setConnectionFactory(factory);
            entryResolver.setAllowMultipleEntries(properties.isAllowMultipleEntries());
            entryResolver.setBinaryAttributes(properties.getBinaryAttributes().toArray(ArrayUtils.EMPTY_STRING_ARRAY));
            if (StringUtils.isNotBlank((CharSequence)properties.getDerefAliases())) {
                entryResolver.setDerefAliases(DerefAliases.valueOf((String)properties.getDerefAliases()));
            }
            List<LdapEntryHandler> entryHandlers = LdapUtils.newLdaptiveEntryHandlers(properties.getSearchEntryHandlers());
            List<SearchResultHandler> searchResultHandlers = LdapUtils.newLdaptiveSearchResultHandlers(properties.getSearchEntryHandlers());
            if (!entryHandlers.isEmpty()) {
                LOGGER.debug("Search entry handlers defined for the entry resolver of [{}] are [{}]", (Object)properties.getLdapUrl(), entryHandlers);
                entryResolver.setEntryHandlers((LdapEntryHandler[])entryHandlers.toArray(LdapEntryHandler[]::new));
            }
            if (!searchResultHandlers.isEmpty()) {
                LOGGER.debug("Search entry handlers defined for the entry resolver of [{}] are [{}]", (Object)properties.getLdapUrl(), searchResultHandlers);
                entryResolver.setSearchResultHandlers((SearchResultHandler[])searchResultHandlers.toArray(SearchResultHandler[]::new));
            }
            if (properties.isFollowReferrals()) {
                entryResolver.setSearchResultHandlers(new SearchResultHandler[]{new FollowSearchReferralHandler()});
            }
            return entryResolver;
        }).collect(Collectors.toList());
        return new ChainingLdapEntryResolver(resolvers);
    }

    public static List<LdapEntryHandler> newLdaptiveEntryHandlers(List<LdapSearchEntryHandlersProperties> properties) {
        ArrayList<LdapEntryHandler> entryHandlers = new ArrayList<LdapEntryHandler>();
        properties.forEach(prop -> {
            switch (prop.getType()) {
                case ACTIVE_DIRECTORY: {
                    ActiveDirectoryLdapEntryHandler handler = new ActiveDirectoryLdapEntryHandler();
                    entryHandlers.add(handler);
                    break;
                }
                case CASE_CHANGE: {
                    CaseChangeEntryHandler entryHandler = new CaseChangeEntryHandler();
                    CaseChangeSearchEntryHandlersProperties caseChange = prop.getCaseChange();
                    entryHandler.setAttributeNameCaseChange(CaseChangeEntryHandler.CaseChange.valueOf((String)caseChange.getAttributeNameCaseChange()));
                    entryHandler.setAttributeNames(caseChange.getAttributeNames().toArray(ArrayUtils.EMPTY_STRING_ARRAY));
                    entryHandler.setAttributeValueCaseChange(CaseChangeEntryHandler.CaseChange.valueOf((String)caseChange.getAttributeValueCaseChange()));
                    entryHandler.setDnCaseChange(CaseChangeEntryHandler.CaseChange.valueOf((String)caseChange.getDnCaseChange()));
                    entryHandlers.add((LdapEntryHandler)entryHandler);
                    break;
                }
                case DN_ATTRIBUTE_ENTRY: {
                    DnAttributeEntryHandler entryHandler = new DnAttributeEntryHandler();
                    DnAttributeSearchEntryHandlersProperties dnAttribute = prop.getDnAttribute();
                    entryHandler.setAddIfExists(dnAttribute.isAddIfExists());
                    entryHandler.setDnAttributeName(dnAttribute.getDnAttributeName());
                    entryHandlers.add((LdapEntryHandler)entryHandler);
                    break;
                }
                case MERGE: {
                    MergeAttributeEntryHandler entryHandler = new MergeAttributeEntryHandler();
                    MergeAttributesSearchEntryHandlersProperties mergeAttribute = prop.getMergeAttribute();
                    entryHandler.setAttributeNames(mergeAttribute.getAttributeNames().toArray(ArrayUtils.EMPTY_STRING_ARRAY));
                    entryHandler.setMergeAttributeName(mergeAttribute.getMergeAttributeName());
                    entryHandlers.add((LdapEntryHandler)entryHandler);
                    break;
                }
                case OBJECT_GUID: {
                    entryHandlers.add((LdapEntryHandler)new ObjectGuidHandler());
                    break;
                }
                case OBJECT_SID: {
                    entryHandlers.add((LdapEntryHandler)new ObjectSidHandler());
                }
            }
        });
        return entryHandlers;
    }

    public static List<SearchResultHandler> newLdaptiveSearchResultHandlers(List<LdapSearchEntryHandlersProperties> properties) {
        ArrayList<SearchResultHandler> searchResultHandlers = new ArrayList<SearchResultHandler>();
        properties.forEach(prop -> {
            switch (prop.getType()) {
                case FOLLOW_SEARCH_REFERRAL: {
                    searchResultHandlers.add((SearchResultHandler)new FollowSearchReferralHandler(prop.getSearchReferral().getLimit()));
                    break;
                }
                case FOLLOW_SEARCH_RESULT_REFERENCE: {
                    searchResultHandlers.add((SearchResultHandler)new FollowSearchResultReferenceHandler(prop.getSearchResult().getLimit()));
                    break;
                }
                case PRIMARY_GROUP: {
                    PrimaryGroupIdHandler handler = new PrimaryGroupIdHandler();
                    PrimaryGroupIdSearchEntryHandlersProperties primaryGroupId = prop.getPrimaryGroupId();
                    handler.setBaseDn(primaryGroupId.getBaseDn());
                    handler.setGroupFilter(primaryGroupId.getGroupFilter());
                    searchResultHandlers.add((SearchResultHandler)handler);
                    break;
                }
                case RANGE_ENTRY: {
                    searchResultHandlers.add((SearchResultHandler)new RangeEntryHandler());
                    break;
                }
                case RECURSIVE_ENTRY: {
                    RecursiveSearchEntryHandlersProperties recursive = prop.getRecursive();
                    searchResultHandlers.add((SearchResultHandler)new RecursiveResultHandler(recursive.getSearchAttribute(), recursive.getMergeAttributes().toArray(ArrayUtils.EMPTY_STRING_ARRAY)));
                    break;
                }
                default: {
                    searchResultHandlers.add((SearchResultHandler)new MergeResultHandler());
                }
            }
        });
        return searchResultHandlers;
    }

    public static Authenticator getAuthenticatedOrAnonSearchAuthenticator(AbstractLdapAuthenticationProperties properties) {
        Authenticator auth;
        if (StringUtils.isBlank((CharSequence)properties.getBaseDn())) {
            throw new IllegalArgumentException("Base dn cannot be empty/blank for authenticated/anonymous authentication");
        }
        if (StringUtils.isBlank((CharSequence)properties.getSearchFilter())) {
            throw new IllegalArgumentException("User filter cannot be empty/blank for authenticated/anonymous authentication");
        }
        ConnectionFactory connectionFactoryForSearch = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)properties);
        DnResolver resolver = LdapUtils.buildAggregateDnResolver(properties, connectionFactoryForSearch);
        Authenticator authenticator = auth = StringUtils.isBlank((CharSequence)properties.getPrincipalAttributePassword()) ? new Authenticator(resolver, LdapUtils.getBindAuthenticationHandler(LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)properties))) : new Authenticator(resolver, LdapUtils.getCompareAuthenticationHandler(properties, LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)properties)));
        if (properties.isEnhanceWithEntryResolver()) {
            auth.setEntryResolver(LdapUtils.newLdaptiveSearchEntryResolver(properties, LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)properties)));
        }
        return auth;
    }

    private static Authenticator getDirectBindAuthenticator(AbstractLdapAuthenticationProperties properties) {
        if (StringUtils.isBlank((CharSequence)properties.getDnFormat())) {
            throw new IllegalArgumentException("Dn format cannot be empty/blank for direct bind authentication");
        }
        return LdapUtils.getAuthenticatorViaDnFormat(properties, null);
    }

    private static Authenticator getActiveDirectoryAuthenticator(AbstractLdapAuthenticationProperties properties) {
        if (StringUtils.isBlank((CharSequence)properties.getDnFormat())) {
            throw new IllegalArgumentException("Dn format cannot be empty/blank for active directory authentication");
        }
        return LdapUtils.getAuthenticatorViaDnFormat(properties, LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)properties));
    }

    private static Authenticator getAuthenticatorViaDnFormat(AbstractLdapAuthenticationProperties properties, ConnectionFactory factory) {
        FormatDnResolver resolver = new FormatDnResolver(properties.getDnFormat());
        Authenticator authenticator = new Authenticator((DnResolver)resolver, LdapUtils.getBindAuthenticationHandler(LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)properties)));
        if (properties.isEnhanceWithEntryResolver()) {
            authenticator.setEntryResolver(LdapUtils.newLdaptiveSearchEntryResolver(properties, factory));
        }
        return authenticator;
    }

    private static AuthenticationHandler getBindAuthenticationHandler(ConnectionFactory factory) {
        return new SimpleBindAuthenticationHandler(factory);
    }

    private static AuthenticationHandler getCompareAuthenticationHandler(AbstractLdapAuthenticationProperties properties, ConnectionFactory factory) {
        CompareAuthenticationHandler handler = new CompareAuthenticationHandler(factory);
        handler.setPasswordAttribute(properties.getPrincipalAttributePassword());
        return handler;
    }

    private static SaslConfig getSaslConfigFrom(AbstractLdapProperties properties) {
        if (Mechanism.valueOf((String)properties.getSaslMechanism()) == Mechanism.DIGEST_MD5) {
            SaslConfig sc = new SaslConfig();
            sc.setMechanism(Mechanism.DIGEST_MD5);
            sc.setRealm(properties.getSaslRealm());
            return sc;
        }
        if (Mechanism.valueOf((String)properties.getSaslMechanism()) == Mechanism.CRAM_MD5) {
            SaslConfig sc = new SaslConfig();
            sc.setMechanism(Mechanism.CRAM_MD5);
            return sc;
        }
        if (Mechanism.valueOf((String)properties.getSaslMechanism()) == Mechanism.EXTERNAL) {
            SaslConfig sc = new SaslConfig();
            sc.setMechanism(Mechanism.EXTERNAL);
            return sc;
        }
        SaslConfig sc = new SaslConfig();
        sc.setMechanism(Mechanism.GSSAPI);
        sc.setRealm(properties.getSaslRealm());
        return sc;
    }

    public static ConnectionFactory newLdaptiveDefaultConnectionFactory(AbstractLdapProperties properties) {
        LOGGER.debug("Creating LDAP connection factory for [{}]", (Object)properties.getLdapUrl());
        ConnectionConfig connectionConfig = LdapUtils.newLdaptiveConnectionConfig(properties);
        return new DefaultConnectionFactory(connectionConfig);
    }

    public static DnResolver buildAggregateDnResolver(AbstractLdapAuthenticationProperties properties, ConnectionFactory connectionFactory) {
        List resolvers = Arrays.stream(StringUtils.split((String)properties.getBaseDn(), (String)BASE_DN_DELIMITER)).map(baseDn -> {
            SearchDnResolver resolver = new SearchDnResolver();
            resolver.setBaseDn(baseDn);
            resolver.setSubtreeSearch(properties.isSubtreeSearch());
            resolver.setAllowMultipleDns(properties.isAllowMultipleDns());
            resolver.setConnectionFactory(connectionFactory);
            resolver.setUserFilter(properties.getSearchFilter());
            resolver.setResolveFromAttribute(properties.getResolveFromAttribute());
            if (properties.isFollowReferrals()) {
                resolver.setSearchResultHandlers(new SearchResultHandler[]{new FollowSearchReferralHandler()});
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getDerefAliases())) {
                resolver.setDerefAliases(DerefAliases.valueOf((String)properties.getDerefAliases()));
            }
            return resolver;
        }).collect(Collectors.toList());
        return new ChainingLdapDnResolver(resolvers);
    }

    public static AuthenticationPasswordPolicyHandlingStrategy<AuthenticationResponse, PasswordPolicyContext> createLdapPasswordPolicyHandlingStrategy(LdapAuthenticationProperties properties, ApplicationContext applicationContext) {
        if (properties.getPasswordPolicy().getStrategy() == PasswordPolicyProperties.PasswordPolicyHandlingOptions.REJECT_RESULT_CODE) {
            LOGGER.debug("Created LDAP password policy handling strategy based on blocked authentication result codes");
            return new RejectResultCodeLdapPasswordPolicyHandlingStrategy();
        }
        Resource location = properties.getPasswordPolicy().getGroovy().getLocation();
        if (properties.getPasswordPolicy().getStrategy() == PasswordPolicyProperties.PasswordPolicyHandlingOptions.GROOVY && location != null && CasRuntimeHintsRegistrar.notInNativeImage()) {
            LOGGER.debug("Created LDAP password policy handling strategy based on Groovy script [{}]", (Object)location);
            return new GroovyPasswordPolicyHandlingStrategy(location, applicationContext);
        }
        LOGGER.debug("Created default LDAP password policy handling strategy");
        return new DefaultPasswordPolicyHandlingStrategy();
    }

    public static PasswordPolicyContext createLdapPasswordPolicyConfiguration(LdapPasswordPolicyProperties passwordPolicy, Authenticator authenticator, Multimap<String, Object> attributes) {
        PasswordPolicyContext cfg = new PasswordPolicyContext((PasswordPolicyProperties)passwordPolicy);
        HashSet<PasswordPolicyAuthenticationRequestHandler> requestHandlers = new HashSet<PasswordPolicyAuthenticationRequestHandler>();
        HashSet<Object> responseHandlers = new HashSet<Object>();
        String customPolicyClass = passwordPolicy.getCustomPolicyClass();
        if (StringUtils.isNotBlank((CharSequence)customPolicyClass)) {
            try {
                LOGGER.debug("Configuration indicates use of a custom password policy handler [{}]", (Object)customPolicyClass);
                Class<?> clazz = Class.forName(customPolicyClass);
                responseHandlers.add((AuthenticationResponseHandler)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                LoggingUtils.warn((Logger)LOGGER, (String)"Unable to construct an instance of the password policy handler", (Throwable)e);
            }
        }
        LOGGER.debug("Password policy authentication response handler is set to accommodate directory type: [{}]", (Object)passwordPolicy.getType());
        switch (passwordPolicy.getType()) {
            case AD: {
                Period warningPeriod = Period.ofDays(cfg.getPasswordWarningNumberOfDays());
                ActiveDirectoryAuthenticationResponseHandler handler = (ActiveDirectoryAuthenticationResponseHandler)FunctionUtils.doIf((passwordPolicy.getPasswordExpirationNumberOfDays() > 0 ? 1 : 0) != 0, () -> {
                    Period expirationPeriod = Period.ofDays(passwordPolicy.getPasswordExpirationNumberOfDays());
                    LOGGER.debug("Creating active directory authentication response handler with expiration period [{}] and warning period [{}]", (Object)expirationPeriod, (Object)warningPeriod);
                    return new ActiveDirectoryAuthenticationResponseHandler(expirationPeriod, warningPeriod);
                }, () -> {
                    LOGGER.debug("Creating active directory authentication response handler with warning period [{}]", (Object)warningPeriod);
                    return new ActiveDirectoryAuthenticationResponseHandler(warningPeriod);
                }).get();
                responseHandlers.add(handler);
                Arrays.stream(ActiveDirectoryAuthenticationResponseHandler.ATTRIBUTES).forEach(attr -> {
                    LOGGER.debug("Configuring authentication to retrieve password policy attribute [{}]", attr);
                    attributes.put(attr, attr);
                });
                break;
            }
            case FreeIPA: {
                Arrays.stream(FreeIPAAuthenticationResponseHandler.ATTRIBUTES).forEach(attr -> {
                    LOGGER.debug("Configuring authentication to retrieve password policy attribute [{}]", attr);
                    attributes.put(attr, attr);
                });
                responseHandlers.add(new FreeIPAAuthenticationResponseHandler(Period.ofDays(cfg.getPasswordWarningNumberOfDays()), cfg.getLoginFailures()));
                break;
            }
            case EDirectory: {
                Arrays.stream(EDirectoryAuthenticationResponseHandler.ATTRIBUTES).forEach(attr -> {
                    LOGGER.debug("Configuring authentication to retrieve password policy attribute [{}]", attr);
                    attributes.put(attr, attr);
                });
                responseHandlers.add(new EDirectoryAuthenticationResponseHandler(Period.ofDays(cfg.getPasswordWarningNumberOfDays())));
                break;
            }
            default: {
                requestHandlers.add(new PasswordPolicyAuthenticationRequestHandler());
                responseHandlers.add(new PasswordPolicyAuthenticationResponseHandler());
                responseHandlers.add(new PasswordExpirationAuthenticationResponseHandler());
            }
        }
        if (!requestHandlers.isEmpty()) {
            authenticator.setRequestHandlers((AuthenticationRequestHandler[])requestHandlers.toArray(AuthenticationRequestHandler[]::new));
        }
        authenticator.setResponseHandlers((AuthenticationResponseHandler[])responseHandlers.toArray(AuthenticationResponseHandler[]::new));
        LOGGER.debug("LDAP authentication response handlers configured are: [{}]", responseHandlers);
        if (!passwordPolicy.isAccountStateHandlingEnabled()) {
            cfg.setAccountStateHandler((response, configuration) -> new ArrayList(0));
            LOGGER.trace("Handling LDAP account states is disabled via CAS configuration");
        } else if (StringUtils.isNotBlank((CharSequence)passwordPolicy.getWarningAttributeName()) && StringUtils.isNotBlank((CharSequence)passwordPolicy.getWarningAttributeValue())) {
            accountHandler = new OptionalWarningLdapAccountStateHandler();
            ((OptionalWarningLdapAccountStateHandler)accountHandler).setDisplayWarningOnMatch(passwordPolicy.isDisplayWarningOnMatch());
            ((OptionalWarningLdapAccountStateHandler)accountHandler).setWarnAttributeName(passwordPolicy.getWarningAttributeName());
            ((OptionalWarningLdapAccountStateHandler)accountHandler).setWarningAttributeValue(passwordPolicy.getWarningAttributeValue());
            accountHandler.setAttributesToErrorMap(passwordPolicy.getPolicyAttributes());
            cfg.setAccountStateHandler((AuthenticationAccountStateHandler)accountHandler);
            LOGGER.debug("Configuring an warning account state handler for LDAP authentication for warning attribute [{}] and value [{}]", (Object)passwordPolicy.getWarningAttributeName(), (Object)passwordPolicy.getWarningAttributeValue());
        } else {
            accountHandler = new DefaultLdapAccountStateHandler();
            accountHandler.setAttributesToErrorMap(passwordPolicy.getPolicyAttributes());
            cfg.setAccountStateHandler((AuthenticationAccountStateHandler)accountHandler);
            LOGGER.debug("Configuring the default account state handler for LDAP authentication");
        }
        return cfg;
    }

    public static LdapAuthenticationHandler createLdapAuthenticationHandler(LdapAuthenticationProperties props, ApplicationContext applicationContext, ServicesManager servicesManager, PrincipalFactory principalFactory) {
        Multimap multiMapAttributes = CoreAuthenticationUtils.transformPrincipalAttributesListIntoMultiMap((List)props.getPrincipalAttributeList());
        LOGGER.debug("Created and mapped principal attributes [{}] for [{}]...", (Object)multiMapAttributes, (Object)props.getLdapUrl());
        LOGGER.debug("Creating LDAP authenticator for [{}] and baseDn [{}]", (Object)props.getLdapUrl(), (Object)props.getBaseDn());
        Authenticator authenticator = LdapUtils.newLdaptiveAuthenticator((AbstractLdapAuthenticationProperties)props);
        LOGGER.debug("Ldap authenticator configured with return attributes [{}] for [{}] and baseDn [{}]", new Object[]{multiMapAttributes.keySet(), props.getLdapUrl(), props.getBaseDn()});
        LOGGER.debug("Creating LDAP password policy handling strategy for [{}]", (Object)props.getLdapUrl());
        AuthenticationPasswordPolicyHandlingStrategy<AuthenticationResponse, PasswordPolicyContext> strategy = LdapUtils.createLdapPasswordPolicyHandlingStrategy(props, applicationContext);
        LOGGER.debug("Creating LDAP authentication handler for [{}]", (Object)props.getLdapUrl());
        LdapAuthenticationHandler handler = new LdapAuthenticationHandler(props.getName(), servicesManager, principalFactory, props.getOrder(), authenticator, strategy);
        handler.setCollectDnAttribute(props.isCollectDnAttribute());
        if (!props.getAdditionalAttributes().isEmpty()) {
            Multimap additional = CoreAuthenticationUtils.transformPrincipalAttributesListIntoMultiMap((List)props.getAdditionalAttributes());
            multiMapAttributes.putAll(additional);
        }
        FunctionUtils.doIfNotBlank((CharSequence)props.getPrincipalDnAttributeName(), __ -> handler.setPrincipalDnAttributeName(props.getPrincipalDnAttributeName()));
        handler.setAllowMultiplePrincipalAttributeValues(props.isAllowMultiplePrincipalAttributeValues());
        handler.setAllowMissingPrincipalAttributeValue(props.isAllowMissingPrincipalAttributeValue());
        handler.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)props.getPasswordEncoder(), (ApplicationContext)applicationContext));
        handler.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)props.getPrincipalTransformation()));
        if (StringUtils.isNotBlank((CharSequence)props.getCredentialCriteria())) {
            LOGGER.trace("Ldap authentication for [{}] is filtering credentials by [{}]", (Object)props.getLdapUrl(), (Object)props.getCredentialCriteria());
            handler.setCredentialSelectionPredicate(CoreAuthenticationUtils.newCredentialSelectionPredicate((String)props.getCredentialCriteria()));
        }
        if (StringUtils.isBlank((CharSequence)props.getPrincipalAttributeId())) {
            LOGGER.trace("No principal id attribute is found for LDAP authentication via [{}]", (Object)props.getLdapUrl());
        } else {
            handler.setPrincipalIdAttribute(props.getPrincipalAttributeId());
            LOGGER.trace("Using principal id attribute [{}] for LDAP authentication via [{}]", (Object)props.getPrincipalAttributeId(), (Object)props.getLdapUrl());
        }
        LdapPasswordPolicyProperties passwordPolicy = props.getPasswordPolicy();
        if (passwordPolicy.isEnabled()) {
            LOGGER.trace("Password policy is enabled for [{}]. Constructing password policy configuration", (Object)props.getLdapUrl());
            PasswordPolicyContext cfg = LdapUtils.createLdapPasswordPolicyConfiguration(passwordPolicy, authenticator, (Multimap<String, Object>)multiMapAttributes);
            handler.setPasswordPolicyConfiguration(cfg);
        }
        Map attributes = CollectionUtils.wrap((Multimap)multiMapAttributes);
        handler.setPrincipalAttributeMap(attributes);
        LOGGER.debug("Initializing LDAP authentication handler for [{}]", (Object)props.getLdapUrl());
        handler.initialize();
        return handler;
    }

    @Generated
    private LdapUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private record ChainingLdapEntryResolver(List<? extends EntryResolver> resolvers) implements EntryResolver
    {
        public LdapEntry resolve(AuthenticationCriteria criteria, AuthenticationHandlerResponse response) {
            return this.resolvers.stream().map(resolver -> (LdapEntry)FunctionUtils.doAndHandle(() -> resolver.resolve(criteria, response), throwable -> {
                LoggingUtils.warn((Logger)LOGGER, (Throwable)throwable);
                return null;
            }).get()).filter(Objects::nonNull).findFirst().orElse(null);
        }
    }

    private record ChainingLdapDnResolver(List<? extends DnResolver> resolvers) implements DnResolver
    {
        public String resolve(User user) {
            return this.resolvers.stream().map(resolver -> (String)FunctionUtils.doAndHandle(() -> resolver.resolve(user), throwable -> {
                LoggingUtils.warn((Logger)LOGGER, (Throwable)throwable);
                return null;
            }).get()).filter(Objects::nonNull).findFirst().orElseThrow(() -> new RuntimeException(new AccountNotFoundException("Unable to resolve user dn for " + user.getIdentifier())));
        }
    }
}

