/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.configurer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.NamedObject;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationDeviceProviderAction;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationTrustedDeviceProviderAction;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class MultifactorAuthenticationAccountProfileWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public MultifactorAuthenticationAccountProfileWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        this.setOrder(Integer.MAX_VALUE);
    }

    protected void doInitialize() {
        Flow accountFlow = this.getFlow("account");
        if (accountFlow != null) {
            ViewState accountView = (ViewState)this.getState(accountFlow, "myAccountProfile", ViewState.class);
            Set currentActions = Arrays.stream(accountView.getRenderActionList().toArray()).filter(MultifactorAuthenticationDeviceProviderAction.class::isInstance).map(MultifactorAuthenticationDeviceProviderAction.class::cast).map(NamedObject::getName).collect(Collectors.toSet());
            ArrayList providerActions = this.applicationContext.getBeansOfType(MultifactorAuthenticationDeviceProviderAction.class).values().stream().filter(BeanSupplier::isNotProxy).filter(action -> !currentActions.contains(action.getName())).collect(Collectors.toCollection(ArrayList::new));
            AnnotationAwareOrderComparator.sort((List)providerActions);
            accountView.getRenderActionList().addAll(providerActions.toArray(new Action[0]));
            Set currentTrustActions = Arrays.stream(accountView.getRenderActionList().toArray()).filter(MultifactorAuthenticationTrustedDeviceProviderAction.class::isInstance).map(MultifactorAuthenticationTrustedDeviceProviderAction.class::cast).map(NamedObject::getName).collect(Collectors.toSet());
            ArrayList trustedActions = this.applicationContext.getBeansOfType(MultifactorAuthenticationTrustedDeviceProviderAction.class).values().stream().filter(BeanSupplier::isNotProxy).filter(action -> !currentTrustActions.contains(action.getName())).collect(Collectors.toCollection(ArrayList::new));
            AnnotationAwareOrderComparator.sort((List)trustedActions);
            accountView.getRenderActionList().addAll(trustedActions.toArray(new Action[0]));
        }
    }
}

