/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.configurer;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class CompositeProviderSelectionMultifactorWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public CompositeProviderSelectionMultifactorWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        this.setOrder(Integer.MAX_VALUE);
    }

    protected void doInitialize() {
        Stream.of(this.getLoginFlow(), this.getFlow("pswdreset")).filter(Objects::nonNull).forEach(this::configureFlow);
    }

    private void configureFlow(Flow flow) {
        ActionState compositeCheckAction = this.createActionState(flow, "compositeMfaProviderSelectionCheck", new String[]{"compositeMfaProviderSelectionAction"});
        this.createTransitionForState((TransitionableState)compositeCheckAction, "proceed", "mfa-composite");
        this.createTransitionForState((TransitionableState)compositeCheckAction, "select", "compositeMfaProviderSelectedAction");
        TransitionableState realSubmit = this.getState(flow, "realSubmit");
        this.createTransitionForState(realSubmit, "mfa-composite", compositeCheckAction.getId());
        Stream.of(this.getState(flow, "sendPasswordResetInstructions"), this.getState(flow, "initPasswordReset"), this.getState(flow, "wsFederationStart"), this.getState(flow, "delegatedAuthentication")).filter(Objects::nonNull).forEach(state -> this.createTransitionForState((TransitionableState)state, "mfa-composite", "mfa-composite"));
        TransitionableState initialAuthn = this.getState(flow, "initialAuthenticationRequestValidationCheck");
        this.createTransitionForState(initialAuthn, "mfa-composite", "mfa-composite");
        ViewState viewState = this.createViewState(flow, "mfa-composite", "mfa/casCompositeMfaProviderSelectionView");
        viewState.getEntryActionList().add((Action)this.createEvaluateAction("prepareMultifactorProviderSelectionAction"));
        this.createTransitionForState((TransitionableState)viewState, "submit", "compositeMfaProviderSelectedAction");
        ActionState selectedState = this.createActionState(flow, "compositeMfaProviderSelectedAction", (Action)this.createEvaluateAction("multifactorProviderSelectedAction"));
        Collection providers = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext).values();
        providers.forEach(provider -> this.createTransitionForState((TransitionableState)selectedState, provider.getId(), provider.getId()));
    }
}

