/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.refreshtoken;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oauth.OAuthRefreshTokenProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.RegisteredServiceDefinition;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthRefreshTokenExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshTokenExpirationPolicy;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshTokenStandaloneExpirationPolicy;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public record OAuth20RefreshTokenExpirationPolicyBuilder(CasConfigurationProperties casProperties) implements ExpirationPolicyBuilder<OAuth20RefreshToken>
{
    private static final long serialVersionUID = -3597980180617072826L;

    public ExpirationPolicy buildTicketExpirationPolicy() {
        return this.toTicketExpirationPolicy();
    }

    public ExpirationPolicy toTicketExpirationPolicy() {
        OAuthRefreshTokenProperties rtProps = this.casProperties.getAuthn().getOauth().getRefreshToken();
        long timeout = Beans.newDuration((String)rtProps.getTimeToKillInSeconds()).getSeconds();
        return this.buildExpirationPolicyFor(timeout);
    }

    public ExpirationPolicy buildTicketExpirationPolicyFor(RegisteredServiceDefinition registeredService) {
        RegisteredServiceOAuthRefreshTokenExpirationPolicy policy;
        String timeToKill;
        OAuthRegisteredService service;
        if (registeredService instanceof OAuthRegisteredService && (service = (OAuthRegisteredService)registeredService).getRefreshTokenExpirationPolicy() != null && StringUtils.isNotBlank((CharSequence)(timeToKill = (policy = service.getRefreshTokenExpirationPolicy()).getTimeToKill()))) {
            long timeToKillInSeconds = Beans.newDuration((String)timeToKill).getSeconds();
            return this.buildExpirationPolicyFor(timeToKillInSeconds);
        }
        return this.toTicketExpirationPolicy();
    }

    private OAuth20RefreshTokenExpirationPolicy buildExpirationPolicyFor(long timeout) {
        if (this.casProperties.getTicket().isTrackDescendantTickets()) {
            return new OAuth20RefreshTokenExpirationPolicy(timeout);
        }
        return new OAuth20RefreshTokenStandaloneExpirationPolicy(timeout);
    }
}

