/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.device;

import java.time.Instant;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCode;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCodeFactory;
import org.apereo.cas.ticket.expiration.FixedInstantExpirationPolicy;
import org.apereo.cas.ticket.registry.TicketCompactor;
import org.apereo.cas.util.DateTimeUtils;
import org.springframework.beans.factory.ObjectProvider;

public class OAuth20DeviceUserCodeCompactor
implements TicketCompactor<OAuth20DeviceUserCode> {
    private final ObjectProvider<TicketFactory> ticketFactory;
    private final ServiceFactory serviceFactory;
    private long maximumTicketLength = 256L;

    public String compact(StringBuilder builder, Ticket ticket) throws Exception {
        OAuth20DeviceUserCode code = (OAuth20DeviceUserCode)ticket;
        builder.append(String.format("%s%s", ",", code.getService().getShortenedId()));
        String approved = BooleanUtils.toString((boolean)code.isUserCodeApproved(), (String)"1", (String)"0");
        builder.append(String.format("%s%s", ",", approved));
        builder.append(String.format("%s%s", ",", ticket.getId()));
        return builder.toString();
    }

    public Class<OAuth20DeviceUserCode> getTicketType() {
        return OAuth20DeviceUserCode.class;
    }

    public Ticket expand(String ticketId) throws Throwable {
        TicketCompactor.CompactTicket structure = this.parse(ticketId);
        OAuth20DeviceUserCodeFactory codeFactory = (OAuth20DeviceUserCodeFactory)((TicketFactory)this.ticketFactory.getObject()).get(this.getTicketType());
        Service service = this.serviceFactory.createService((String)structure.ticketElements().get(TicketCompactor.CompactTicketIndexes.SERVICE.getIndex()));
        boolean isApproved = BooleanUtils.toBoolean((String)((String)structure.ticketElements().get(3)));
        String id = (String)structure.ticketElements().get(4);
        OAuth20DeviceUserCode userCode = codeFactory.createDeviceUserCode(id, service);
        userCode.setUserCodeApproved(isApproved);
        userCode.setExpirationPolicy((ExpirationPolicy)new FixedInstantExpirationPolicy(structure.expirationTime()));
        userCode.setCreationTime(DateTimeUtils.zonedDateTimeOf((Instant)structure.creationTime()));
        return userCode;
    }

    @Generated
    public OAuth20DeviceUserCodeCompactor(ObjectProvider<TicketFactory> ticketFactory, ServiceFactory serviceFactory) {
        this.ticketFactory = ticketFactory;
        this.serviceFactory = serviceFactory;
    }

    @Generated
    public long getMaximumTicketLength() {
        return this.maximumTicketLength;
    }
}

