/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.device;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthDeviceTokenExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenExpirationPolicy;

public final class OAuth20DeviceTokenUtils {
    public static ExpirationPolicy determineExpirationPolicyForService(ServicesManager servicesManager, ExpirationPolicyBuilder expirationPolicy, Service service) {
        RegisteredServiceOAuthDeviceTokenExpirationPolicy policy;
        String ttl;
        RegisteredService registeredService = servicesManager.findServiceBy(service);
        if (!(registeredService instanceof OAuthRegisteredService)) {
            return expirationPolicy.buildTicketExpirationPolicy();
        }
        OAuthRegisteredService oauthService = (OAuthRegisteredService)registeredService;
        if (oauthService.getDeviceTokenExpirationPolicy() != null && StringUtils.isNotBlank((CharSequence)(ttl = (policy = oauthService.getDeviceTokenExpirationPolicy()).getTimeToKill()))) {
            return new OAuth20DeviceTokenExpirationPolicy(Beans.newDuration((String)ttl).getSeconds());
        }
        return expirationPolicy.buildTicketExpirationPolicy();
    }

    @Generated
    private OAuth20DeviceTokenUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

