/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.accesstoken;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import org.apereo.cas.ticket.IdleExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicketAwareTicket;
import org.apereo.cas.ticket.expiration.AbstractCasExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class OAuth20AccessTokenExpirationPolicy
extends AbstractCasExpirationPolicy
implements IdleExpirationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AccessTokenExpirationPolicy.class);
    private static final long serialVersionUID = -8383186650682727360L;
    private long maxTimeToLiveInSeconds;
    private long timeToKillInSeconds;

    @JsonCreator
    public OAuth20AccessTokenExpirationPolicy(@JsonProperty(value="timeToLive") long maxTimeToLive, @JsonProperty(value="timeToIdle") long timeToKill) {
        this.maxTimeToLiveInSeconds = maxTimeToLive;
        this.timeToKillInSeconds = timeToKill;
    }

    public boolean isExpired(TicketGrantingTicketAwareTicket ticketState) {
        boolean expired = this.isAccessTokenExpired((Ticket)ticketState);
        return expired || super.isExpired(ticketState);
    }

    public Long getTimeToLive() {
        return this.maxTimeToLiveInSeconds;
    }

    public Long getTimeToIdle() {
        return this.timeToKillInSeconds;
    }

    @JsonIgnore
    public ZonedDateTime toMaximumExpirationTime(Ticket ticketState) {
        ZonedDateTime creationTime = ticketState.getCreationTime();
        return creationTime.plus(this.maxTimeToLiveInSeconds, ChronoUnit.SECONDS);
    }

    @JsonIgnore
    public ZonedDateTime getIdleExpirationTime(Ticket ticketState) {
        ZonedDateTime lastTimeUsed = ticketState.getLastTimeUsed();
        return lastTimeUsed.plus(this.timeToKillInSeconds, ChronoUnit.SECONDS);
    }

    @JsonIgnore
    protected boolean isAccessTokenExpired(Ticket ticketState) {
        ZonedDateTime expirationTime;
        ZonedDateTime currentSystemTime = ZonedDateTime.now(ZoneOffset.UTC);
        if (currentSystemTime.isAfter(expirationTime = this.toMaximumExpirationTime(ticketState))) {
            LOGGER.debug("Access token is expired because the current time [{}] is after [{}]", (Object)currentSystemTime, (Object)expirationTime);
            return true;
        }
        ZonedDateTime expirationTimeToKill = this.getIdleExpirationTime(ticketState);
        if (currentSystemTime.isAfter(expirationTimeToKill)) {
            LOGGER.debug("Access token is expired because the current time [{}] is after [{}]", (Object)currentSystemTime, (Object)expirationTimeToKill);
            return true;
        }
        return false;
    }

    @Generated
    public OAuth20AccessTokenExpirationPolicy() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth20AccessTokenExpirationPolicy)) {
            return false;
        }
        OAuth20AccessTokenExpirationPolicy other = (OAuth20AccessTokenExpirationPolicy)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.maxTimeToLiveInSeconds != other.maxTimeToLiveInSeconds) {
            return false;
        }
        return this.timeToKillInSeconds == other.timeToKillInSeconds;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OAuth20AccessTokenExpirationPolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $maxTimeToLiveInSeconds = this.maxTimeToLiveInSeconds;
        result = result * 59 + (int)($maxTimeToLiveInSeconds >>> 32 ^ $maxTimeToLiveInSeconds);
        long $timeToKillInSeconds = this.timeToKillInSeconds;
        result = result * 59 + (int)($timeToKillInSeconds >>> 32 ^ $timeToKillInSeconds);
        return result;
    }

    @Generated
    public String toString() {
        return "OAuth20AccessTokenExpirationPolicy(super=" + super.toString() + ", maxTimeToLiveInSeconds=" + this.maxTimeToLiveInSeconds + ", timeToKillInSeconds=" + this.timeToKillInSeconds + ")";
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
    public static class OAuthAccessTokenSovereignExpirationPolicy
    extends OAuth20AccessTokenExpirationPolicy {
        private static final long serialVersionUID = -7768661082888351104L;

        @JsonCreator
        public OAuthAccessTokenSovereignExpirationPolicy(@JsonProperty(value="timeToLive") long maxTimeToLive, @JsonProperty(value="timeToIdle") long timeToKill) {
            super(maxTimeToLive, timeToKill);
        }

        @Override
        public boolean isExpired(TicketGrantingTicketAwareTicket ticketState) {
            return this.isAccessTokenExpired((Ticket)ticketState);
        }

        @Generated
        public OAuthAccessTokenSovereignExpirationPolicy() {
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OAuthAccessTokenSovereignExpirationPolicy)) {
                return false;
            }
            OAuthAccessTokenSovereignExpirationPolicy other = (OAuthAccessTokenSovereignExpirationPolicy)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OAuthAccessTokenSovereignExpirationPolicy;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "OAuth20AccessTokenExpirationPolicy.OAuthAccessTokenSovereignExpirationPolicy(super=" + super.toString() + ")";
        }
    }
}

