/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.OAuth20AuthorizationRequest;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.support.oauth.web.response.callback.BaseOAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.crypto.EncodableCipher;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.UriComponentsBuilder;

public class OAuth20TokenAuthorizationResponseBuilder<T extends OAuth20ConfigurationContext>
extends BaseOAuth20AuthorizationResponseBuilder<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20TokenAuthorizationResponseBuilder.class);

    public OAuth20TokenAuthorizationResponseBuilder(T configurationContext, OAuth20AuthorizationModelAndViewBuilder authorizationModelAndViewBuilder) {
        super(configurationContext, authorizationModelAndViewBuilder);
    }

    @Audit(action="OAUTH2_AUTHORIZATION_RESPONSE", actionResolverName="OAUTH2_AUTHORIZATION_RESPONSE_ACTION_RESOLVER", resourceResolverName="OAUTH2_AUTHORIZATION_RESPONSE_RESOURCE_RESOLVER")
    public ModelAndView build(AccessTokenRequestContext tokenRequestContext) throws Throwable {
        LOGGER.debug("Authorize request verification successful for client [{}] with redirect uri [{}]", (Object)tokenRequestContext.getClientId(), (Object)tokenRequestContext.getRedirectUri());
        OAuth20TokenGeneratedResult result = this.configurationContext.getAccessTokenGenerator().generate(tokenRequestContext);
        Ticket accessToken = (Ticket)result.getAccessToken().orElseThrow();
        Ticket refreshToken = result.getRefreshToken().orElse(null);
        LOGGER.debug("Generated OAuth access token: [{}]", (Object)accessToken);
        return this.buildCallbackUrlResponseType(tokenRequestContext, accessToken, refreshToken, new ArrayList<NameValuePair>());
    }

    public boolean supports(OAuth20AuthorizationRequest context) {
        return StringUtils.equalsIgnoreCase((CharSequence)context.getResponseType(), (CharSequence)OAuth20ResponseTypes.TOKEN.getType());
    }

    protected ModelAndView buildCallbackUrlResponseType(AccessTokenRequestContext tokenRequestContext, Ticket givenAccessToken, Ticket givenRefreshToken, List<NameValuePair> parameters) throws Throwable {
        Map attributes = tokenRequestContext.getAuthentication().getAttributes();
        OAuth20AccessToken accessToken = this.resolveAccessToken(givenAccessToken);
        URIBuilder builder = new URIBuilder(tokenRequestContext.getRedirectUri());
        if (this.includeAccessTokenInResponse(tokenRequestContext) && accessToken.getExpiresIn() > 0L) {
            EncodableCipher<String, String> cipher = OAuth20JwtAccessTokenEncoder.toEncodableCipher(this.configurationContext, (RegisteredService)tokenRequestContext.getRegisteredService(), accessToken, tokenRequestContext.getService(), false);
            String encodedAccessToken = (String)cipher.encode((Object)accessToken.getId());
            builder.addParameter("access_token", encodedAccessToken);
            builder.addParameter("token_type", "Bearer");
            builder.addParameter("expires_in", String.valueOf(accessToken.getExpiresIn()));
        }
        if (givenRefreshToken != null) {
            OAuth20RefreshToken refreshToken = this.resolveRefreshToken(givenRefreshToken);
            builder.addParameter("refresh_token", refreshToken.getId());
        }
        CollectionUtils.firstElement(attributes.get("state")).ifPresent(state -> builder.addParameter("state", state.toString()));
        CollectionUtils.firstElement(attributes.get("nonce")).ifPresent(nonce -> builder.addParameter("nonce", nonce.toString()));
        builder.addParameters(parameters);
        String parameterList = builder.getQueryParams().stream().map(parameter -> String.format("%s=%s", parameter.getName(), URLEncoder.encode(parameter.getValue(), StandardCharsets.UTF_8))).collect(Collectors.joining("&"));
        String url = UriComponentsBuilder.fromUriString((String)tokenRequestContext.getRedirectUri()).fragment(parameterList).build().toUriString();
        LOGGER.debug("Redirecting to URL [{}]", (Object)url);
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.configurationContext.getServicesManager(), accessToken.getClientId());
        return this.build(registeredService, tokenRequestContext.getResponseMode(), url, new LinkedHashMap<String, String>());
    }

    protected boolean includeAccessTokenInResponse(AccessTokenRequestContext tokenRequestContext) {
        return true;
    }
}

