/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.response;

import com.nimbusds.jose.Header;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.auth.X509CertificateConfirmation;
import com.nimbusds.oauth2.sdk.dpop.JWKThumbprintConfirmation;
import java.text.ParseException;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20TokenExchangeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseResult;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.crypto.DecodableCipher;
import org.apereo.cas.util.crypto.EncodableCipher;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20JwtAccessTokenEncoder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20JwtAccessTokenEncoder.class);

    public static DecodableCipher<String, String> toDecodableCipher(JwtBuilder accessTokenJwtBuilder, RegisteredService registeredService) {
        return new OAuth20JwtAccessTokenDecodableCipher(registeredService, accessTokenJwtBuilder);
    }

    public static DecodableCipher<String, String> toDecodableCipher(JwtBuilder accessTokenJwtBuilder) {
        return OAuth20JwtAccessTokenEncoder.toDecodableCipher(accessTokenJwtBuilder, null);
    }

    public static EncodableCipher<String, String> toEncodableCipher(OAuth20ConfigurationContext configurationContext, OAuth20AccessTokenResponseResult tokenResult, OAuth20AccessToken accessToken, String issuer) {
        OAuth20JwtAccessTokenEncodableCipher cipher = new OAuth20JwtAccessTokenEncodableCipher(configurationContext, tokenResult.getRegisteredService(), accessToken, tokenResult.getService(), issuer, tokenResult.getRequestedTokenType() == OAuth20TokenExchangeTypes.JWT);
        if (tokenResult.getGrantType() == OAuth20GrantTypes.TOKEN_EXCHANGE && tokenResult.getRequestedTokenType() == OAuth20TokenExchangeTypes.JWT) {
            String audience = Optional.ofNullable(tokenResult.getTokenExchangeAudience()).or(() -> Optional.ofNullable(tokenResult.getTokenExchangeResource()).map(Service::getId)).orElse("");
            cipher.setTokenAudience(audience);
        }
        return cipher;
    }

    public static EncodableCipher<String, String> toEncodableCipher(OAuth20ConfigurationContext configurationContext, RegisteredService registeredService, OAuth20AccessToken accessToken, String issuer) {
        return new OAuth20JwtAccessTokenEncodableCipher(configurationContext, registeredService, accessToken, accessToken.getService(), issuer, false);
    }

    public static EncodableCipher<String, String> toEncodableCipher(OAuth20ConfigurationContext configurationContext, OAuthRegisteredService registeredService, OAuth20AccessToken accessToken) {
        return OAuth20JwtAccessTokenEncoder.toEncodableCipher(configurationContext, (RegisteredService)registeredService, accessToken, configurationContext.getCasProperties().getServer().getPrefix());
    }

    public static EncodableCipher<String, String> toEncodableCipher(OAuth20ConfigurationContext configurationContext, RegisteredService registeredService, OAuth20AccessToken accessToken, Service service, boolean forceEncodeAsJwt) {
        return new OAuth20JwtAccessTokenEncodableCipher(configurationContext, registeredService, accessToken, service, configurationContext.getCasProperties().getServer().getPrefix(), forceEncodeAsJwt);
    }

    public static EncodableCipher<String, String> toEncodableCipher(OAuth20ConfigurationContext configurationContext, OAuth20AccessTokenResponseResult tokenResult, OAuth20AccessToken accessToken) {
        OAuth20JwtAccessTokenEncodableCipher cipher = new OAuth20JwtAccessTokenEncodableCipher(configurationContext, tokenResult.getRegisteredService(), accessToken, tokenResult.getService(), configurationContext.getCasProperties().getServer().getPrefix(), tokenResult.getRequestedTokenType() == OAuth20TokenExchangeTypes.JWT);
        if (tokenResult.getGrantType() == OAuth20GrantTypes.TOKEN_EXCHANGE && tokenResult.getRequestedTokenType() == OAuth20TokenExchangeTypes.JWT) {
            String audience = Optional.ofNullable(tokenResult.getTokenExchangeAudience()).or(() -> Optional.ofNullable(tokenResult.getTokenExchangeResource()).map(Service::getId)).orElse("");
            cipher.setTokenAudience(audience);
        }
        return cipher;
    }

    static class OAuth20JwtAccessTokenDecodableCipher
    implements DecodableCipher<String, String> {
        @Generated
        private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20JwtAccessTokenDecodableCipher.class);
        private final RegisteredService registeredService;
        private final JwtBuilder accessTokenJwtBuilder;

        protected RegisteredService resolveRegisteredService(Header header) {
            Object serviceId;
            OAuthRegisteredService oAuthRegisteredService = (OAuthRegisteredService)this.registeredService;
            if (oAuthRegisteredService == null && (serviceId = header.getCustomParam(RegisteredServiceCipherExecutor.CUSTOM_HEADER_REGISTERED_SERVICE_ID)) != null) {
                long serviceIdentifier = Long.parseLong(serviceId.toString());
                oAuthRegisteredService = (OAuthRegisteredService)this.accessTokenJwtBuilder.getServicesManager().findServiceBy(serviceIdentifier, OAuthRegisteredService.class);
            }
            return oAuthRegisteredService;
        }

        public String decode(String tokenId, Object[] parameters) {
            if (StringUtils.isBlank((CharSequence)tokenId)) {
                LOGGER.debug("No access token is provided to decode");
                return tokenId;
            }
            try {
                Header header = JWTParser.parse((String)tokenId).getHeader();
                JWTClaimsSet claims = this.accessTokenJwtBuilder.unpack(Optional.ofNullable(this.resolveRegisteredService(header)), tokenId);
                return claims.getJWTID();
            }
            catch (ParseException e) {
                LOGGER.trace("Token is not valid JWT, returning it as-is: [{}]", (Object)tokenId);
                return tokenId;
            }
        }

        @Generated
        public OAuth20JwtAccessTokenDecodableCipher(RegisteredService registeredService, JwtBuilder accessTokenJwtBuilder) {
            this.registeredService = registeredService;
            this.accessTokenJwtBuilder = accessTokenJwtBuilder;
        }
    }

    static class OAuth20JwtAccessTokenEncodableCipher
    implements EncodableCipher<String, String> {
        @Generated
        private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20JwtAccessTokenEncodableCipher.class);
        private final OAuth20ConfigurationContext configurationContext;
        private final RegisteredService registeredService;
        private final OAuth20AccessToken accessToken;
        private final Service service;
        private final String issuer;
        private final boolean forceEncodeAsJwt;
        private String tokenAudience;

        public String encode(String value, Object[] parameters) {
            OAuthRegisteredService oAuthRegisteredService;
            RegisteredService registeredService = this.registeredService;
            if (registeredService instanceof OAuthRegisteredService && this.shouldEncodeAsJwt(oAuthRegisteredService = (OAuthRegisteredService)registeredService, (Ticket)this.accessToken)) {
                return (String)FunctionUtils.doUnchecked(() -> {
                    JwtBuilder.JwtRequest request = this.getJwtRequestBuilder(oAuthRegisteredService, this.accessToken);
                    return this.configurationContext.getAccessTokenJwtBuilder().build(request);
                });
            }
            return this.accessToken.getId();
        }

        protected JwtBuilder.JwtRequest getJwtRequestBuilder(OAuthRegisteredService registeredService, OAuth20AccessToken accessToken) throws Throwable {
            Authentication authentication = accessToken.getAuthentication();
            JwtBuilder.JwtRequest.JwtRequestBuilder builder = JwtBuilder.JwtRequest.builder();
            Map<String, List<Object>> attributes = this.collectAttributes(accessToken, registeredService);
            return builder.serviceAudience(this.determineServiceAudience(registeredService, (AuthenticationAwareTicket)accessToken)).issueDate(DateTimeUtils.dateOf((ChronoZonedDateTime)authentication.getAuthenticationDate())).jwtId(accessToken.getId()).subject(authentication.getPrincipal().getId()).validUntilDate(this.determineValidUntilDate((AuthenticationAwareTicket)accessToken)).attributes(attributes).registeredService(Optional.of(registeredService)).issuer((String)StringUtils.defaultIfBlank((CharSequence)this.issuer, (CharSequence)this.configurationContext.getCasProperties().getServer().getPrefix())).service(Optional.ofNullable(this.service)).resolveSubject(accessToken.isStateless()).build();
        }

        protected Map<String, List<Object>> collectAttributes(OAuth20AccessToken accessToken, OAuthRegisteredService registeredService) throws Throwable {
            Principal activePrincipal = this.buildPrincipalForAttributeFilter(accessToken, (RegisteredService)registeredService);
            Principal principal = this.configurationContext.getProfileScopeToAttributesFilter().filter(accessToken.getService(), activePrincipal, (RegisteredService)registeredService, accessToken);
            HashMap<String, List<Object>> attributesToRelease = new HashMap<String, List<Object>>(principal.getAttributes());
            Map originalAttributes = activePrincipal.getAttributes();
            if (originalAttributes.containsKey("DPoPConfirmation")) {
                CollectionUtils.firstElement(originalAttributes.get("DPoPConfirmation")).ifPresent(conf -> {
                    JWKThumbprintConfirmation confirmation = new JWKThumbprintConfirmation(new Base64URL(conf.toString()));
                    Map.Entry claim = confirmation.toJWTClaim();
                    attributesToRelease.put((String)claim.getKey(), List.of(claim.getValue()));
                });
                attributesToRelease.put("DPoP", (List)originalAttributes.get("DPoP"));
                attributesToRelease.put("DPoPConfirmation", (List)originalAttributes.get("DPoPConfirmation"));
            }
            if (originalAttributes.containsKey("x509_digest")) {
                CollectionUtils.firstElement(originalAttributes.get("x509_digest")).ifPresent(conf -> {
                    X509CertificateConfirmation confirmation = new X509CertificateConfirmation(new Base64URL(conf.toString()));
                    Map.Entry claim = confirmation.toJWTClaim();
                    attributesToRelease.put((String)claim.getKey(), List.of(claim.getValue()));
                });
                attributesToRelease.put("x509_digest", (List)originalAttributes.get("x509_digest"));
            }
            attributesToRelease.remove("password");
            return attributesToRelease;
        }

        protected Date determineValidUntilDate(AuthenticationAwareTicket accessToken) {
            ZonedDateTime authenticationDate = accessToken.getAuthentication().getAuthenticationDate();
            return DateTimeUtils.dateOf((ChronoZonedDateTime)authenticationDate.plusSeconds(accessToken.getExpirationPolicy().getTimeToLive()));
        }

        protected Set<String> determineServiceAudience(OAuthRegisteredService registeredService, AuthenticationAwareTicket accessToken) {
            if (StringUtils.isNotBlank((CharSequence)this.tokenAudience)) {
                return Set.of(this.tokenAudience);
            }
            if (registeredService.getAudience().isEmpty()) {
                return Set.of(((OAuth20Token)accessToken).getClientId());
            }
            return registeredService.getAudience();
        }

        protected boolean shouldEncodeAsJwt(OAuthRegisteredService oAuthRegisteredService, Ticket accessToken) {
            AuthenticationAwareTicket aat;
            boolean serviceRequiresJwt = oAuthRegisteredService != null && oAuthRegisteredService.isJwtAccessToken();
            boolean dpopRequest = accessToken instanceof AuthenticationAwareTicket && (aat = (AuthenticationAwareTicket)accessToken).getAuthentication().containsAttribute("DPoP");
            return this.configurationContext.getCasProperties().getAuthn().getOauth().getAccessToken().isCreateAsJwt() || this.forceEncodeAsJwt || serviceRequiresJwt || dpopRequest;
        }

        private Principal buildPrincipalForAttributeFilter(OAuth20AccessToken accessToken, RegisteredService registeredService) throws Throwable {
            Authentication authentication = accessToken.getAuthentication();
            HashMap attributes = new HashMap(authentication.getPrincipal().getAttributes());
            Map authnAttributes = this.configurationContext.getAuthenticationAttributeReleasePolicy().getAuthenticationAttributesForRelease(authentication, registeredService);
            attributes.putAll(authnAttributes);
            return this.configurationContext.getPrincipalFactory().createPrincipal(authentication.getPrincipal().getId(), attributes);
        }

        @Generated
        public OAuth20JwtAccessTokenEncodableCipher(OAuth20ConfigurationContext configurationContext, RegisteredService registeredService, OAuth20AccessToken accessToken, Service service, String issuer, boolean forceEncodeAsJwt) {
            this.configurationContext = configurationContext;
            this.registeredService = registeredService;
            this.accessToken = accessToken;
            this.service = service;
            this.issuer = issuer;
            this.forceEncodeAsJwt = forceEncodeAsJwt;
        }

        @Generated
        public OAuth20JwtAccessTokenEncodableCipher setTokenAudience(String tokenAudience) {
            this.tokenAudience = tokenAudience;
            return this;
        }

        @Generated
        public OAuth20ConfigurationContext getConfigurationContext() {
            return this.configurationContext;
        }

        @Generated
        public RegisteredService getRegisteredService() {
            return this.registeredService;
        }

        @Generated
        public OAuth20AccessToken getAccessToken() {
            return this.accessToken;
        }

        @Generated
        public Service getService() {
            return this.service;
        }

        @Generated
        public String getIssuer() {
            return this.issuer;
        }

        @Generated
        public boolean isForceEncodeAsJwt() {
            return this.forceEncodeAsJwt;
        }

        @Generated
        public String getTokenAudience() {
            return this.tokenAudience;
        }
    }
}

