/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.response;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.crypto.EncodableCipher;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.inspektr.audit.annotation.Audit;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class OAuth20DefaultAccessTokenResponseGenerator<T extends OAuth20ConfigurationContext>
implements OAuth20AccessTokenResponseGenerator {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    protected final ObjectProvider<T> configurationContext;

    private static boolean shouldGenerateDeviceFlowResponse(OAuth20AccessTokenResponseResult result) {
        OAuth20TokenGeneratedResult generatedToken = result.getGeneratedToken();
        return OAuth20ResponseTypes.DEVICE_CODE == result.getResponseType() && generatedToken.getDeviceCode().isPresent() && generatedToken.getUserCode().isPresent() && generatedToken.getAccessToken().isEmpty();
    }

    @Audit(action="OAUTH2_ACCESS_TOKEN_RESPONSE", actionResolverName="OAUTH2_ACCESS_TOKEN_RESPONSE_ACTION_RESOLVER", resourceResolverName="OAUTH2_ACCESS_TOKEN_RESPONSE_RESOURCE_RESOLVER")
    public ModelAndView generate(OAuth20AccessTokenResponseResult result) {
        if (OAuth20DefaultAccessTokenResponseGenerator.shouldGenerateDeviceFlowResponse(result)) {
            return this.generateResponseForDeviceToken(result);
        }
        return this.generateResponseForAccessToken(result);
    }

    protected ModelAndView generateResponseForDeviceToken(OAuth20AccessTokenResponseResult result) {
        Map model = this.getDeviceTokenResponseModel(result);
        return new ModelAndView((View)new MappingJackson2JsonView(MAPPER), model);
    }

    protected Map getDeviceTokenResponseModel(OAuth20AccessTokenResponseResult result) {
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        String uri = result.getCasProperties().getServer().getPrefix().concat("/oauth2.0").concat("/").concat("device");
        model.put("verification_uri", uri);
        model.put("expires_in", result.getDeviceTokenTimeout());
        OAuth20TokenGeneratedResult generatedToken = result.getGeneratedToken();
        generatedToken.getUserCode().ifPresent(userCode -> model.put("user_code", userCode));
        generatedToken.getDeviceCode().ifPresent(deviceCode -> model.put("device_code", deviceCode));
        model.put("interval", result.getDeviceRefreshInterval());
        return model;
    }

    protected ModelAndView generateResponseForAccessToken(OAuth20AccessTokenResponseResult result) {
        Map<String, Object> model = this.getAccessTokenResponseModel(result);
        ModelAndView modelAndView = new ModelAndView((View)new MappingJackson2JsonView(MAPPER), model);
        modelAndView.setStatus((HttpStatusCode)HttpStatus.OK);
        return modelAndView;
    }

    protected Map<String, Object> getAccessTokenResponseModel(OAuth20AccessTokenResponseResult result) {
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        OAuth20TokenGeneratedResult generatedToken = result.getGeneratedToken();
        generatedToken.getAccessToken().ifPresent(token -> {
            OAuth20AccessToken accessToken = this.resolveToken((Ticket)token, (Class)OAuth20AccessToken.class);
            if (accessToken.getExpiresIn() > 0L) {
                String encodedAccessTokenId = this.encodeAccessToken(accessToken, result);
                if (StringUtils.equals((CharSequence)encodedAccessTokenId, (CharSequence)accessToken.getId()) && token.isStateless()) {
                    model.put("access_token", token.getId());
                } else {
                    model.put("access_token", encodedAccessTokenId);
                }
                if (!accessToken.getScopes().isEmpty()) {
                    model.put("scope", String.join((CharSequence)" ", accessToken.getScopes()));
                }
                model.put("expires_in", accessToken.getExpiresIn());
                Authentication authentication = accessToken.getAuthentication();
                model.put("token_type", authentication.containsAttribute("DPoPConfirmation") ? "DPoP" : "Bearer");
                if (result.getUserProfile() != null) {
                    result.getUserProfile().addAttribute(Principal.class.getName(), (Object)authentication.getPrincipal());
                }
                if (result.getGrantType() == OAuth20GrantTypes.TOKEN_EXCHANGE) {
                    model.put("issued_token_type", result.getRequestedTokenType().getType());
                }
            }
        });
        generatedToken.getRefreshToken().ifPresent(rt -> model.put("refresh_token", rt.getId()));
        return model;
    }

    protected <TokenType extends OAuth20Token> TokenType resolveToken(Ticket token, Class<TokenType> clazz) {
        return (TokenType)(token == null ? null : (token.isStateless() ? (OAuth20Token)((OAuth20ConfigurationContext)this.configurationContext.getObject()).getTicketRegistry().getTicket(token.getId(), clazz) : (OAuth20Token)token));
    }

    protected String encodeAccessToken(OAuth20AccessToken accessToken, OAuth20AccessTokenResponseResult result) {
        EncodableCipher<String, String> cipher = OAuth20JwtAccessTokenEncoder.toEncodableCipher((OAuth20ConfigurationContext)this.configurationContext.getObject(), result, accessToken);
        return (String)cipher.encode((Object)accessToken.getId(), new Object[]{accessToken, result});
    }

    @Generated
    public OAuth20DefaultAccessTokenResponseGenerator(ObjectProvider<T> configurationContext) {
        this.configurationContext = configurationContext;
    }
}

