/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.mgmt;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="oauthTokens", enableByDefault=false)
public class OAuth20TokenManagementEndpoint
extends BaseCasActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20TokenManagementEndpoint.class);
    private final ObjectProvider<TicketRegistry> ticketRegistry;
    private final ObjectProvider<JwtBuilder> accessTokenJwtBuilder;

    public OAuth20TokenManagementEndpoint(CasConfigurationProperties casProperties, ObjectProvider<TicketRegistry> ticketRegistry, ObjectProvider<JwtBuilder> accessTokenJwtBuilder) {
        super(casProperties);
        this.ticketRegistry = ticketRegistry;
        this.accessTokenJwtBuilder = accessTokenJwtBuilder;
    }

    @ReadOperation
    @Operation(summary="Get access and/or refresh tokens")
    public Collection<Ticket> getTokens() {
        return ((TicketRegistry)this.ticketRegistry.getObject()).getTickets(ticket -> (ticket instanceof OAuth20AccessToken || ticket instanceof OAuth20RefreshToken) && !ticket.isExpired()).sorted(Comparator.comparing(Ticket::getId)).collect(Collectors.toList());
    }

    @ReadOperation
    @Operation(summary="Get single token by id", parameters={@Parameter(name="token", required=true, description="The token id")})
    public Ticket getToken(@Selector String token) {
        try {
            String ticketId = this.extractAccessTokenFrom(token);
            return ((TicketRegistry)this.ticketRegistry.getObject()).getTicket(ticketId, Ticket.class);
        }
        catch (Exception e) {
            LOGGER.debug("Ticket [{}] is has expired or cannot be found", (Object)token);
            return null;
        }
    }

    @DeleteOperation
    @Operation(summary="Delete token by id", parameters={@Parameter(name="token", required=true, description="The token id")})
    public void deleteToken(@Selector String token) throws Exception {
        Ticket ticket = this.getToken(token);
        if (ticket != null) {
            ((TicketRegistry)this.ticketRegistry.getObject()).deleteTicket(ticket.getId());
        }
    }

    protected String extractAccessTokenFrom(String token) {
        return (String)OAuth20JwtAccessTokenEncoder.toDecodableCipher((JwtBuilder)this.accessTokenJwtBuilder.getObject()).decode((Object)token);
    }
}

