/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public class OAuth20UserProfileEndpointController<T extends OAuth20ConfigurationContext>
extends BaseOAuth20Controller<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20UserProfileEndpointController.class);

    public OAuth20UserProfileEndpointController(T configurationContext) {
        super(configurationContext);
    }

    protected static ResponseEntity buildUnauthorizedResponseEntity(String code) {
        Map<String, Object> map = OAuth20Utils.getErrorResponseBody(code, HttpStatus.UNAUTHORIZED.getReasonPhrase());
        return new ResponseEntity(map, (HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }

    @PostMapping(path={"/oauth2.0/profile"}, produces={"application/json"})
    public ResponseEntity<String> handlePostRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.handleGetRequest(request, response);
    }

    @GetMapping(path={"/oauth2.0/profile"}, produces={"application/json"})
    public ResponseEntity<String> handleGetRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("application/json");
        Pair accessTokenResult = (Pair)FunctionUtils.doAndHandle(() -> this.getAccessTokenFromRequest(request));
        if (accessTokenResult == null) {
            LOGGER.error("Unable to get the access token from the request");
            return OAuth20UserProfileEndpointController.buildUnauthorizedResponseEntity("invalid_request");
        }
        String decodedAccessTokenId = (String)accessTokenResult.getValue();
        if (StringUtils.isBlank((CharSequence)decodedAccessTokenId)) {
            LOGGER.error("Missing required parameter [{}] from the request", (Object)"access_token");
            return OAuth20UserProfileEndpointController.buildUnauthorizedResponseEntity("missing_accessToken");
        }
        OAuth20AccessToken accessTokenTicket = (OAuth20AccessToken)FunctionUtils.doAndHandle(() -> {
            OAuth20AccessToken decodedToken = (OAuth20AccessToken)((OAuth20ConfigurationContext)this.getConfigurationContext()).getTicketRegistry().getTicket(decodedAccessTokenId, OAuth20AccessToken.class);
            return decodedToken == null || decodedToken.isExpired() ? null : decodedToken;
        });
        if (accessTokenTicket == null || accessTokenTicket.isExpired()) {
            LOGGER.error("Access token [{}] cannot be found in the ticket registry or has expired.", (Object)decodedAccessTokenId);
            return OAuth20UserProfileEndpointController.buildUnauthorizedResponseEntity("expired_accessToken");
        }
        LoggingUtils.protocolMessage((String)"OAuth/OpenID Connect User Profile Request", Map.of("Access Token", decodedAccessTokenId, "Client ID", accessTokenTicket.getClientId()));
        try {
            this.validateAccessToken((String)accessTokenResult.getKey(), accessTokenTicket, request, response);
            this.updateAccessTokenUsage(accessTokenTicket);
            JEEContext context = new JEEContext(request, response);
            Map map = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getUserProfileDataCreator().createFrom(accessTokenTicket, (WebContext)context);
            return ((OAuth20ConfigurationContext)this.getConfigurationContext()).getUserProfileViewRenderer().render(map, accessTokenTicket, response);
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return OAuth20UserProfileEndpointController.buildUnauthorizedResponseEntity("invalid_request");
        }
    }

    protected void validateAccessToken(String accessTokenId, OAuth20AccessToken accessToken, HttpServletRequest request, HttpServletResponse response) {
    }

    protected void updateAccessTokenUsage(OAuth20AccessToken accessTokenTicket) throws Exception {
        if (!accessTokenTicket.isStateless()) {
            accessTokenTicket.update();
            TicketRegistry ticketRegistry = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getTicketRegistry();
            if (accessTokenTicket.isExpired()) {
                ticketRegistry.deleteTicket(accessTokenTicket.getId());
            } else {
                ticketRegistry.updateTicket((Ticket)accessTokenTicket);
            }
        }
    }

    protected Pair<String, String> getAccessTokenFromRequest(HttpServletRequest request) {
        String authHeader;
        String accessToken = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("access_token"), (CharSequence)request.getParameter("token"));
        if (StringUtils.isBlank((CharSequence)accessToken) && StringUtils.isNotBlank((CharSequence)(authHeader = request.getHeader("Authorization"))) && authHeader.toLowerCase(Locale.ENGLISH).startsWith("Bearer".toLowerCase(Locale.ENGLISH) + " ")) {
            accessToken = authHeader.substring("Bearer".length() + 1);
        }
        LOGGER.debug("[{}]: [{}]", (Object)"access_token", (Object)accessToken);
        return Pair.of((Object)accessToken, (Object)this.extractAccessTokenFrom(accessToken));
    }
}

