/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.authenticator.OAuth20CasAuthenticationBuilder;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.OAuth20UserProfileDataCreator;
import org.apereo.cas.support.oauth.validator.OAuth20ClientSecretValidator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20InvalidAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.introspection.OAuth20IntrospectionResponseGenerator;
import org.apereo.cas.support.oauth.web.views.ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20CallbackAuthorizeViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20UserProfileViewRenderer;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.OAuth20TokenSigningAndEncryptionService;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.device.OAuth20DeviceToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.gen.RandomStringGenerator;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.CookieUtils;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.jee.context.JEEContext;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.scheduling.TaskScheduler;

public class OAuth20ConfigurationContext {
    private final ConfigurableApplicationContext applicationContext;
    private final ServicesManager servicesManager;
    private final TicketFactory ticketFactory;
    private final TicketRegistry ticketRegistry;
    private final PrincipalFactory principalFactory;
    private final ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory;
    private final OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter;
    private final CasConfigurationProperties casProperties;
    private final CasCookieBuilder ticketGrantingTicketCookieGenerator;
    private final OAuth20TokenGenerator accessTokenGenerator;
    private final JwtBuilder accessTokenJwtBuilder;
    private final OAuth20AccessTokenResponseGenerator accessTokenResponseGenerator;
    private final ObjectProvider<List<OAuth20TokenRequestValidator>> accessTokenGrantRequestValidators;
    private final ExpirationPolicyBuilder<OAuth20DeviceToken> deviceTokenExpirationPolicy;
    private final ConsentApprovalViewResolver consentApprovalViewResolver;
    private final OAuth20CasAuthenticationBuilder authenticationBuilder;
    private final ObjectProvider<List<OAuth20AuthorizationResponseBuilder>> oauthAuthorizationResponseBuilders;
    private final OAuth20InvalidAuthorizationResponseBuilder oauthInvalidAuthorizationResponseBuilder;
    private final ObjectProvider<List<OAuth20AuthorizationRequestValidator>> oauthRequestValidators;
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;
    private final Config oauthConfig;
    private final OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver;
    private final CentralAuthenticationService centralAuthenticationService;
    private final OAuth20UserProfileViewRenderer userProfileViewRenderer;
    private final OAuth20UserProfileDataCreator userProfileDataCreator;
    private final StringSerializer clientRegistrationRequestSerializer;
    private final RandomStringGenerator clientIdGenerator;
    private final RandomStringGenerator clientSecretGenerator;
    private final SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder;
    private final SessionStore sessionStore;
    private final CipherExecutor<Serializable, String> registeredServiceCipherExecutor;
    private final OAuth20TokenSigningAndEncryptionService idTokenSigningAndEncryptionService;
    private final CasCookieBuilder oauthDistributedSessionCookieGenerator;
    private final OAuth20RequestParameterResolver requestParameterResolver;
    private final OAuth20ClientSecretValidator clientSecretValidator;
    private final AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy;
    private final ArgumentExtractor argumentExtractor;
    private final AttributeDefinitionStore attributeDefinitionStore;
    private final List<OAuth20IntrospectionResponseGenerator> introspectionResponseGenerator;
    private final PrincipalResolver principalResolver;
    private final TaskScheduler taskScheduler;
    private final CommunicationsManager communicationsManager;
    private final CipherExecutor<byte[], byte[]> webflowCipherExecutor;
    private final HttpClient httpClient;

    public TicketGrantingTicket fetchTicketGrantingTicketFrom(JEEContext context) {
        TicketGrantingTicket ticketGrantingTicket = CookieUtils.getTicketGrantingTicketFromRequest((CasCookieBuilder)this.getTicketGrantingTicketCookieGenerator(), (TicketRegistry)this.getTicketRegistry(), (HttpServletRequest)context.getNativeRequest());
        if (!this.ticketGrantingTicketCookieGenerator.containsCookie(context.getNativeRequest())) {
            return Optional.ofNullable(ticketGrantingTicket).orElseGet(() -> {
                ProfileManager manager = new ProfileManager((WebContext)context, this.getSessionStore());
                return manager.getProfile().map(profile -> profile.getAttribute(TicketGrantingTicket.class.getName())).map(ticketId -> (TicketGrantingTicket)this.ticketRegistry.getTicket(ticketId.toString(), TicketGrantingTicket.class)).orElse(null);
            });
        }
        return ticketGrantingTicket;
    }

    @Generated
    protected OAuth20ConfigurationContext(OAuth20ConfigurationContextBuilder<?, ?> b) {
        this.applicationContext = b.applicationContext;
        this.servicesManager = b.servicesManager;
        this.ticketFactory = b.ticketFactory;
        this.ticketRegistry = b.ticketRegistry;
        this.principalFactory = b.principalFactory;
        this.webApplicationServiceServiceFactory = b.webApplicationServiceServiceFactory;
        this.profileScopeToAttributesFilter = b.profileScopeToAttributesFilter;
        this.casProperties = b.casProperties;
        this.ticketGrantingTicketCookieGenerator = b.ticketGrantingTicketCookieGenerator;
        this.accessTokenGenerator = b.accessTokenGenerator;
        this.accessTokenJwtBuilder = b.accessTokenJwtBuilder;
        this.accessTokenResponseGenerator = b.accessTokenResponseGenerator;
        this.accessTokenGrantRequestValidators = b.accessTokenGrantRequestValidators;
        this.deviceTokenExpirationPolicy = b.deviceTokenExpirationPolicy;
        this.consentApprovalViewResolver = b.consentApprovalViewResolver;
        this.authenticationBuilder = b.authenticationBuilder;
        this.oauthAuthorizationResponseBuilders = b.oauthAuthorizationResponseBuilders;
        this.oauthInvalidAuthorizationResponseBuilder = b.oauthInvalidAuthorizationResponseBuilder;
        this.oauthRequestValidators = b.oauthRequestValidators;
        this.registeredServiceAccessStrategyEnforcer = b.registeredServiceAccessStrategyEnforcer;
        this.oauthConfig = b.oauthConfig;
        this.callbackAuthorizeViewResolver = b.callbackAuthorizeViewResolver;
        this.centralAuthenticationService = b.centralAuthenticationService;
        this.userProfileViewRenderer = b.userProfileViewRenderer;
        this.userProfileDataCreator = b.userProfileDataCreator;
        this.clientRegistrationRequestSerializer = b.clientRegistrationRequestSerializer;
        this.clientIdGenerator = b.clientIdGenerator;
        this.clientSecretGenerator = b.clientSecretGenerator;
        this.singleLogoutServiceLogoutUrlBuilder = b.singleLogoutServiceLogoutUrlBuilder;
        this.sessionStore = b.sessionStore;
        this.registeredServiceCipherExecutor = b.registeredServiceCipherExecutor;
        this.idTokenSigningAndEncryptionService = b.idTokenSigningAndEncryptionService;
        this.oauthDistributedSessionCookieGenerator = b.oauthDistributedSessionCookieGenerator;
        this.requestParameterResolver = b.requestParameterResolver;
        this.clientSecretValidator = b.clientSecretValidator;
        this.authenticationAttributeReleasePolicy = b.authenticationAttributeReleasePolicy;
        this.argumentExtractor = b.argumentExtractor;
        this.attributeDefinitionStore = b.attributeDefinitionStore;
        this.introspectionResponseGenerator = b.introspectionResponseGenerator;
        this.principalResolver = b.principalResolver;
        this.taskScheduler = b.taskScheduler;
        this.communicationsManager = b.communicationsManager;
        this.webflowCipherExecutor = b.webflowCipherExecutor;
        this.httpClient = b.httpClient;
    }

    @Generated
    public static OAuth20ConfigurationContextBuilder<?, ?> builder() {
        return new OAuth20ConfigurationContextBuilderImpl();
    }

    @Generated
    public String toString() {
        return "OAuth20ConfigurationContext(applicationContext=" + String.valueOf(this.applicationContext) + ", servicesManager=" + String.valueOf(this.servicesManager) + ", ticketFactory=" + String.valueOf(this.ticketFactory) + ", ticketRegistry=" + String.valueOf(this.ticketRegistry) + ", principalFactory=" + String.valueOf(this.principalFactory) + ", webApplicationServiceServiceFactory=" + String.valueOf(this.webApplicationServiceServiceFactory) + ", profileScopeToAttributesFilter=" + String.valueOf(this.profileScopeToAttributesFilter) + ", casProperties=" + String.valueOf(this.casProperties) + ", ticketGrantingTicketCookieGenerator=" + String.valueOf(this.ticketGrantingTicketCookieGenerator) + ", accessTokenGenerator=" + String.valueOf(this.accessTokenGenerator) + ", accessTokenJwtBuilder=" + String.valueOf(this.accessTokenJwtBuilder) + ", accessTokenResponseGenerator=" + String.valueOf(this.accessTokenResponseGenerator) + ", accessTokenGrantRequestValidators=" + String.valueOf(this.accessTokenGrantRequestValidators) + ", deviceTokenExpirationPolicy=" + String.valueOf(this.deviceTokenExpirationPolicy) + ", consentApprovalViewResolver=" + String.valueOf(this.consentApprovalViewResolver) + ", authenticationBuilder=" + String.valueOf(this.authenticationBuilder) + ", oauthAuthorizationResponseBuilders=" + String.valueOf(this.oauthAuthorizationResponseBuilders) + ", oauthInvalidAuthorizationResponseBuilder=" + String.valueOf(this.oauthInvalidAuthorizationResponseBuilder) + ", oauthRequestValidators=" + String.valueOf(this.oauthRequestValidators) + ", registeredServiceAccessStrategyEnforcer=" + String.valueOf(this.registeredServiceAccessStrategyEnforcer) + ", oauthConfig=" + String.valueOf(this.oauthConfig) + ", callbackAuthorizeViewResolver=" + String.valueOf(this.callbackAuthorizeViewResolver) + ", centralAuthenticationService=" + String.valueOf(this.centralAuthenticationService) + ", userProfileViewRenderer=" + String.valueOf(this.userProfileViewRenderer) + ", userProfileDataCreator=" + String.valueOf(this.userProfileDataCreator) + ", clientRegistrationRequestSerializer=" + String.valueOf(this.clientRegistrationRequestSerializer) + ", clientIdGenerator=" + String.valueOf(this.clientIdGenerator) + ", clientSecretGenerator=" + String.valueOf(this.clientSecretGenerator) + ", singleLogoutServiceLogoutUrlBuilder=" + String.valueOf(this.singleLogoutServiceLogoutUrlBuilder) + ", sessionStore=" + String.valueOf(this.sessionStore) + ", registeredServiceCipherExecutor=" + String.valueOf(this.registeredServiceCipherExecutor) + ", idTokenSigningAndEncryptionService=" + String.valueOf(this.idTokenSigningAndEncryptionService) + ", oauthDistributedSessionCookieGenerator=" + String.valueOf(this.oauthDistributedSessionCookieGenerator) + ", requestParameterResolver=" + String.valueOf(this.requestParameterResolver) + ", clientSecretValidator=" + String.valueOf(this.clientSecretValidator) + ", authenticationAttributeReleasePolicy=" + String.valueOf(this.authenticationAttributeReleasePolicy) + ", argumentExtractor=" + String.valueOf(this.argumentExtractor) + ", attributeDefinitionStore=" + String.valueOf(this.attributeDefinitionStore) + ", introspectionResponseGenerator=" + String.valueOf(this.introspectionResponseGenerator) + ", principalResolver=" + String.valueOf(this.principalResolver) + ", taskScheduler=" + String.valueOf(this.taskScheduler) + ", communicationsManager=" + String.valueOf(this.communicationsManager) + ", webflowCipherExecutor=" + String.valueOf(this.webflowCipherExecutor) + ", httpClient=" + String.valueOf(this.httpClient) + ")";
    }

    @Generated
    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public TicketFactory getTicketFactory() {
        return this.ticketFactory;
    }

    @Generated
    public TicketRegistry getTicketRegistry() {
        return this.ticketRegistry;
    }

    @Generated
    public PrincipalFactory getPrincipalFactory() {
        return this.principalFactory;
    }

    @Generated
    public ServiceFactory<WebApplicationService> getWebApplicationServiceServiceFactory() {
        return this.webApplicationServiceServiceFactory;
    }

    @Generated
    public OAuth20ProfileScopeToAttributesFilter getProfileScopeToAttributesFilter() {
        return this.profileScopeToAttributesFilter;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public CasCookieBuilder getTicketGrantingTicketCookieGenerator() {
        return this.ticketGrantingTicketCookieGenerator;
    }

    @Generated
    public OAuth20TokenGenerator getAccessTokenGenerator() {
        return this.accessTokenGenerator;
    }

    @Generated
    public JwtBuilder getAccessTokenJwtBuilder() {
        return this.accessTokenJwtBuilder;
    }

    @Generated
    public OAuth20AccessTokenResponseGenerator getAccessTokenResponseGenerator() {
        return this.accessTokenResponseGenerator;
    }

    @Generated
    public ObjectProvider<List<OAuth20TokenRequestValidator>> getAccessTokenGrantRequestValidators() {
        return this.accessTokenGrantRequestValidators;
    }

    @Generated
    public ExpirationPolicyBuilder<OAuth20DeviceToken> getDeviceTokenExpirationPolicy() {
        return this.deviceTokenExpirationPolicy;
    }

    @Generated
    public ConsentApprovalViewResolver getConsentApprovalViewResolver() {
        return this.consentApprovalViewResolver;
    }

    @Generated
    public OAuth20CasAuthenticationBuilder getAuthenticationBuilder() {
        return this.authenticationBuilder;
    }

    @Generated
    public ObjectProvider<List<OAuth20AuthorizationResponseBuilder>> getOauthAuthorizationResponseBuilders() {
        return this.oauthAuthorizationResponseBuilders;
    }

    @Generated
    public OAuth20InvalidAuthorizationResponseBuilder getOauthInvalidAuthorizationResponseBuilder() {
        return this.oauthInvalidAuthorizationResponseBuilder;
    }

    @Generated
    public ObjectProvider<List<OAuth20AuthorizationRequestValidator>> getOauthRequestValidators() {
        return this.oauthRequestValidators;
    }

    @Generated
    public AuditableExecution getRegisteredServiceAccessStrategyEnforcer() {
        return this.registeredServiceAccessStrategyEnforcer;
    }

    @Generated
    public Config getOauthConfig() {
        return this.oauthConfig;
    }

    @Generated
    public OAuth20CallbackAuthorizeViewResolver getCallbackAuthorizeViewResolver() {
        return this.callbackAuthorizeViewResolver;
    }

    @Generated
    public CentralAuthenticationService getCentralAuthenticationService() {
        return this.centralAuthenticationService;
    }

    @Generated
    public OAuth20UserProfileViewRenderer getUserProfileViewRenderer() {
        return this.userProfileViewRenderer;
    }

    @Generated
    public OAuth20UserProfileDataCreator getUserProfileDataCreator() {
        return this.userProfileDataCreator;
    }

    @Generated
    public StringSerializer getClientRegistrationRequestSerializer() {
        return this.clientRegistrationRequestSerializer;
    }

    @Generated
    public RandomStringGenerator getClientIdGenerator() {
        return this.clientIdGenerator;
    }

    @Generated
    public RandomStringGenerator getClientSecretGenerator() {
        return this.clientSecretGenerator;
    }

    @Generated
    public SingleLogoutServiceLogoutUrlBuilder getSingleLogoutServiceLogoutUrlBuilder() {
        return this.singleLogoutServiceLogoutUrlBuilder;
    }

    @Generated
    public SessionStore getSessionStore() {
        return this.sessionStore;
    }

    @Generated
    public CipherExecutor<Serializable, String> getRegisteredServiceCipherExecutor() {
        return this.registeredServiceCipherExecutor;
    }

    @Generated
    public OAuth20TokenSigningAndEncryptionService getIdTokenSigningAndEncryptionService() {
        return this.idTokenSigningAndEncryptionService;
    }

    @Generated
    public CasCookieBuilder getOauthDistributedSessionCookieGenerator() {
        return this.oauthDistributedSessionCookieGenerator;
    }

    @Generated
    public OAuth20RequestParameterResolver getRequestParameterResolver() {
        return this.requestParameterResolver;
    }

    @Generated
    public OAuth20ClientSecretValidator getClientSecretValidator() {
        return this.clientSecretValidator;
    }

    @Generated
    public AuthenticationAttributeReleasePolicy getAuthenticationAttributeReleasePolicy() {
        return this.authenticationAttributeReleasePolicy;
    }

    @Generated
    public ArgumentExtractor getArgumentExtractor() {
        return this.argumentExtractor;
    }

    @Generated
    public AttributeDefinitionStore getAttributeDefinitionStore() {
        return this.attributeDefinitionStore;
    }

    @Generated
    public List<OAuth20IntrospectionResponseGenerator> getIntrospectionResponseGenerator() {
        return this.introspectionResponseGenerator;
    }

    @Generated
    public PrincipalResolver getPrincipalResolver() {
        return this.principalResolver;
    }

    @Generated
    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    @Generated
    public CommunicationsManager getCommunicationsManager() {
        return this.communicationsManager;
    }

    @Generated
    public CipherExecutor<byte[], byte[]> getWebflowCipherExecutor() {
        return this.webflowCipherExecutor;
    }

    @Generated
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Generated
    public static abstract class OAuth20ConfigurationContextBuilder<C extends OAuth20ConfigurationContext, B extends OAuth20ConfigurationContextBuilder<C, B>> {
        @Generated
        private ConfigurableApplicationContext applicationContext;
        @Generated
        private ServicesManager servicesManager;
        @Generated
        private TicketFactory ticketFactory;
        @Generated
        private TicketRegistry ticketRegistry;
        @Generated
        private PrincipalFactory principalFactory;
        @Generated
        private ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory;
        @Generated
        private OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter;
        @Generated
        private CasConfigurationProperties casProperties;
        @Generated
        private CasCookieBuilder ticketGrantingTicketCookieGenerator;
        @Generated
        private OAuth20TokenGenerator accessTokenGenerator;
        @Generated
        private JwtBuilder accessTokenJwtBuilder;
        @Generated
        private OAuth20AccessTokenResponseGenerator accessTokenResponseGenerator;
        @Generated
        private ObjectProvider<List<OAuth20TokenRequestValidator>> accessTokenGrantRequestValidators;
        @Generated
        private ExpirationPolicyBuilder<OAuth20DeviceToken> deviceTokenExpirationPolicy;
        @Generated
        private ConsentApprovalViewResolver consentApprovalViewResolver;
        @Generated
        private OAuth20CasAuthenticationBuilder authenticationBuilder;
        @Generated
        private ObjectProvider<List<OAuth20AuthorizationResponseBuilder>> oauthAuthorizationResponseBuilders;
        @Generated
        private OAuth20InvalidAuthorizationResponseBuilder oauthInvalidAuthorizationResponseBuilder;
        @Generated
        private ObjectProvider<List<OAuth20AuthorizationRequestValidator>> oauthRequestValidators;
        @Generated
        private AuditableExecution registeredServiceAccessStrategyEnforcer;
        @Generated
        private Config oauthConfig;
        @Generated
        private OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver;
        @Generated
        private CentralAuthenticationService centralAuthenticationService;
        @Generated
        private OAuth20UserProfileViewRenderer userProfileViewRenderer;
        @Generated
        private OAuth20UserProfileDataCreator userProfileDataCreator;
        @Generated
        private StringSerializer clientRegistrationRequestSerializer;
        @Generated
        private RandomStringGenerator clientIdGenerator;
        @Generated
        private RandomStringGenerator clientSecretGenerator;
        @Generated
        private SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder;
        @Generated
        private SessionStore sessionStore;
        @Generated
        private CipherExecutor<Serializable, String> registeredServiceCipherExecutor;
        @Generated
        private OAuth20TokenSigningAndEncryptionService idTokenSigningAndEncryptionService;
        @Generated
        private CasCookieBuilder oauthDistributedSessionCookieGenerator;
        @Generated
        private OAuth20RequestParameterResolver requestParameterResolver;
        @Generated
        private OAuth20ClientSecretValidator clientSecretValidator;
        @Generated
        private AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy;
        @Generated
        private ArgumentExtractor argumentExtractor;
        @Generated
        private AttributeDefinitionStore attributeDefinitionStore;
        @Generated
        private List<OAuth20IntrospectionResponseGenerator> introspectionResponseGenerator;
        @Generated
        private PrincipalResolver principalResolver;
        @Generated
        private TaskScheduler taskScheduler;
        @Generated
        private CommunicationsManager communicationsManager;
        @Generated
        private CipherExecutor<byte[], byte[]> webflowCipherExecutor;
        @Generated
        private HttpClient httpClient;

        @Generated
        public B applicationContext(ConfigurableApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
            return this.self();
        }

        @Generated
        public B servicesManager(ServicesManager servicesManager) {
            this.servicesManager = servicesManager;
            return this.self();
        }

        @Generated
        public B ticketFactory(TicketFactory ticketFactory) {
            this.ticketFactory = ticketFactory;
            return this.self();
        }

        @Generated
        public B ticketRegistry(TicketRegistry ticketRegistry) {
            this.ticketRegistry = ticketRegistry;
            return this.self();
        }

        @Generated
        public B principalFactory(PrincipalFactory principalFactory) {
            this.principalFactory = principalFactory;
            return this.self();
        }

        @Generated
        public B webApplicationServiceServiceFactory(ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory) {
            this.webApplicationServiceServiceFactory = webApplicationServiceServiceFactory;
            return this.self();
        }

        @Generated
        public B profileScopeToAttributesFilter(OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter) {
            this.profileScopeToAttributesFilter = profileScopeToAttributesFilter;
            return this.self();
        }

        @Generated
        public B casProperties(CasConfigurationProperties casProperties) {
            this.casProperties = casProperties;
            return this.self();
        }

        @Generated
        public B ticketGrantingTicketCookieGenerator(CasCookieBuilder ticketGrantingTicketCookieGenerator) {
            this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
            return this.self();
        }

        @Generated
        public B accessTokenGenerator(OAuth20TokenGenerator accessTokenGenerator) {
            this.accessTokenGenerator = accessTokenGenerator;
            return this.self();
        }

        @Generated
        public B accessTokenJwtBuilder(JwtBuilder accessTokenJwtBuilder) {
            this.accessTokenJwtBuilder = accessTokenJwtBuilder;
            return this.self();
        }

        @Generated
        public B accessTokenResponseGenerator(OAuth20AccessTokenResponseGenerator accessTokenResponseGenerator) {
            this.accessTokenResponseGenerator = accessTokenResponseGenerator;
            return this.self();
        }

        @Generated
        public B accessTokenGrantRequestValidators(ObjectProvider<List<OAuth20TokenRequestValidator>> accessTokenGrantRequestValidators) {
            this.accessTokenGrantRequestValidators = accessTokenGrantRequestValidators;
            return this.self();
        }

        @Generated
        public B deviceTokenExpirationPolicy(ExpirationPolicyBuilder<OAuth20DeviceToken> deviceTokenExpirationPolicy) {
            this.deviceTokenExpirationPolicy = deviceTokenExpirationPolicy;
            return this.self();
        }

        @Generated
        public B consentApprovalViewResolver(ConsentApprovalViewResolver consentApprovalViewResolver) {
            this.consentApprovalViewResolver = consentApprovalViewResolver;
            return this.self();
        }

        @Generated
        public B authenticationBuilder(OAuth20CasAuthenticationBuilder authenticationBuilder) {
            this.authenticationBuilder = authenticationBuilder;
            return this.self();
        }

        @Generated
        public B oauthAuthorizationResponseBuilders(ObjectProvider<List<OAuth20AuthorizationResponseBuilder>> oauthAuthorizationResponseBuilders) {
            this.oauthAuthorizationResponseBuilders = oauthAuthorizationResponseBuilders;
            return this.self();
        }

        @Generated
        public B oauthInvalidAuthorizationResponseBuilder(OAuth20InvalidAuthorizationResponseBuilder oauthInvalidAuthorizationResponseBuilder) {
            this.oauthInvalidAuthorizationResponseBuilder = oauthInvalidAuthorizationResponseBuilder;
            return this.self();
        }

        @Generated
        public B oauthRequestValidators(ObjectProvider<List<OAuth20AuthorizationRequestValidator>> oauthRequestValidators) {
            this.oauthRequestValidators = oauthRequestValidators;
            return this.self();
        }

        @Generated
        public B registeredServiceAccessStrategyEnforcer(AuditableExecution registeredServiceAccessStrategyEnforcer) {
            this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
            return this.self();
        }

        @Generated
        public B oauthConfig(Config oauthConfig) {
            this.oauthConfig = oauthConfig;
            return this.self();
        }

        @Generated
        public B callbackAuthorizeViewResolver(OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver) {
            this.callbackAuthorizeViewResolver = callbackAuthorizeViewResolver;
            return this.self();
        }

        @Generated
        public B centralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
            this.centralAuthenticationService = centralAuthenticationService;
            return this.self();
        }

        @Generated
        public B userProfileViewRenderer(OAuth20UserProfileViewRenderer userProfileViewRenderer) {
            this.userProfileViewRenderer = userProfileViewRenderer;
            return this.self();
        }

        @Generated
        public B userProfileDataCreator(OAuth20UserProfileDataCreator userProfileDataCreator) {
            this.userProfileDataCreator = userProfileDataCreator;
            return this.self();
        }

        @Generated
        public B clientRegistrationRequestSerializer(StringSerializer clientRegistrationRequestSerializer) {
            this.clientRegistrationRequestSerializer = clientRegistrationRequestSerializer;
            return this.self();
        }

        @Generated
        public B clientIdGenerator(RandomStringGenerator clientIdGenerator) {
            this.clientIdGenerator = clientIdGenerator;
            return this.self();
        }

        @Generated
        public B clientSecretGenerator(RandomStringGenerator clientSecretGenerator) {
            this.clientSecretGenerator = clientSecretGenerator;
            return this.self();
        }

        @Generated
        public B singleLogoutServiceLogoutUrlBuilder(SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder) {
            this.singleLogoutServiceLogoutUrlBuilder = singleLogoutServiceLogoutUrlBuilder;
            return this.self();
        }

        @Generated
        public B sessionStore(SessionStore sessionStore) {
            this.sessionStore = sessionStore;
            return this.self();
        }

        @Generated
        public B registeredServiceCipherExecutor(CipherExecutor<Serializable, String> registeredServiceCipherExecutor) {
            this.registeredServiceCipherExecutor = registeredServiceCipherExecutor;
            return this.self();
        }

        @Generated
        public B idTokenSigningAndEncryptionService(OAuth20TokenSigningAndEncryptionService idTokenSigningAndEncryptionService) {
            this.idTokenSigningAndEncryptionService = idTokenSigningAndEncryptionService;
            return this.self();
        }

        @Generated
        public B oauthDistributedSessionCookieGenerator(CasCookieBuilder oauthDistributedSessionCookieGenerator) {
            this.oauthDistributedSessionCookieGenerator = oauthDistributedSessionCookieGenerator;
            return this.self();
        }

        @Generated
        public B requestParameterResolver(OAuth20RequestParameterResolver requestParameterResolver) {
            this.requestParameterResolver = requestParameterResolver;
            return this.self();
        }

        @Generated
        public B clientSecretValidator(OAuth20ClientSecretValidator clientSecretValidator) {
            this.clientSecretValidator = clientSecretValidator;
            return this.self();
        }

        @Generated
        public B authenticationAttributeReleasePolicy(AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy) {
            this.authenticationAttributeReleasePolicy = authenticationAttributeReleasePolicy;
            return this.self();
        }

        @Generated
        public B argumentExtractor(ArgumentExtractor argumentExtractor) {
            this.argumentExtractor = argumentExtractor;
            return this.self();
        }

        @Generated
        public B attributeDefinitionStore(AttributeDefinitionStore attributeDefinitionStore) {
            this.attributeDefinitionStore = attributeDefinitionStore;
            return this.self();
        }

        @Generated
        public B introspectionResponseGenerator(List<OAuth20IntrospectionResponseGenerator> introspectionResponseGenerator) {
            this.introspectionResponseGenerator = introspectionResponseGenerator;
            return this.self();
        }

        @Generated
        public B principalResolver(PrincipalResolver principalResolver) {
            this.principalResolver = principalResolver;
            return this.self();
        }

        @Generated
        public B taskScheduler(TaskScheduler taskScheduler) {
            this.taskScheduler = taskScheduler;
            return this.self();
        }

        @Generated
        public B communicationsManager(CommunicationsManager communicationsManager) {
            this.communicationsManager = communicationsManager;
            return this.self();
        }

        @Generated
        public B webflowCipherExecutor(CipherExecutor<byte[], byte[]> webflowCipherExecutor) {
            this.webflowCipherExecutor = webflowCipherExecutor;
            return this.self();
        }

        @Generated
        public B httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "OAuth20ConfigurationContext.OAuth20ConfigurationContextBuilder(applicationContext=" + String.valueOf(this.applicationContext) + ", servicesManager=" + String.valueOf(this.servicesManager) + ", ticketFactory=" + String.valueOf(this.ticketFactory) + ", ticketRegistry=" + String.valueOf(this.ticketRegistry) + ", principalFactory=" + String.valueOf(this.principalFactory) + ", webApplicationServiceServiceFactory=" + String.valueOf(this.webApplicationServiceServiceFactory) + ", profileScopeToAttributesFilter=" + String.valueOf(this.profileScopeToAttributesFilter) + ", casProperties=" + String.valueOf(this.casProperties) + ", ticketGrantingTicketCookieGenerator=" + String.valueOf(this.ticketGrantingTicketCookieGenerator) + ", accessTokenGenerator=" + String.valueOf(this.accessTokenGenerator) + ", accessTokenJwtBuilder=" + String.valueOf(this.accessTokenJwtBuilder) + ", accessTokenResponseGenerator=" + String.valueOf(this.accessTokenResponseGenerator) + ", accessTokenGrantRequestValidators=" + String.valueOf(this.accessTokenGrantRequestValidators) + ", deviceTokenExpirationPolicy=" + String.valueOf(this.deviceTokenExpirationPolicy) + ", consentApprovalViewResolver=" + String.valueOf(this.consentApprovalViewResolver) + ", authenticationBuilder=" + String.valueOf(this.authenticationBuilder) + ", oauthAuthorizationResponseBuilders=" + String.valueOf(this.oauthAuthorizationResponseBuilders) + ", oauthInvalidAuthorizationResponseBuilder=" + String.valueOf(this.oauthInvalidAuthorizationResponseBuilder) + ", oauthRequestValidators=" + String.valueOf(this.oauthRequestValidators) + ", registeredServiceAccessStrategyEnforcer=" + String.valueOf(this.registeredServiceAccessStrategyEnforcer) + ", oauthConfig=" + String.valueOf(this.oauthConfig) + ", callbackAuthorizeViewResolver=" + String.valueOf(this.callbackAuthorizeViewResolver) + ", centralAuthenticationService=" + String.valueOf(this.centralAuthenticationService) + ", userProfileViewRenderer=" + String.valueOf(this.userProfileViewRenderer) + ", userProfileDataCreator=" + String.valueOf(this.userProfileDataCreator) + ", clientRegistrationRequestSerializer=" + String.valueOf(this.clientRegistrationRequestSerializer) + ", clientIdGenerator=" + String.valueOf(this.clientIdGenerator) + ", clientSecretGenerator=" + String.valueOf(this.clientSecretGenerator) + ", singleLogoutServiceLogoutUrlBuilder=" + String.valueOf(this.singleLogoutServiceLogoutUrlBuilder) + ", sessionStore=" + String.valueOf(this.sessionStore) + ", registeredServiceCipherExecutor=" + String.valueOf(this.registeredServiceCipherExecutor) + ", idTokenSigningAndEncryptionService=" + String.valueOf(this.idTokenSigningAndEncryptionService) + ", oauthDistributedSessionCookieGenerator=" + String.valueOf(this.oauthDistributedSessionCookieGenerator) + ", requestParameterResolver=" + String.valueOf(this.requestParameterResolver) + ", clientSecretValidator=" + String.valueOf(this.clientSecretValidator) + ", authenticationAttributeReleasePolicy=" + String.valueOf(this.authenticationAttributeReleasePolicy) + ", argumentExtractor=" + String.valueOf(this.argumentExtractor) + ", attributeDefinitionStore=" + String.valueOf(this.attributeDefinitionStore) + ", introspectionResponseGenerator=" + String.valueOf(this.introspectionResponseGenerator) + ", principalResolver=" + String.valueOf(this.principalResolver) + ", taskScheduler=" + String.valueOf(this.taskScheduler) + ", communicationsManager=" + String.valueOf(this.communicationsManager) + ", webflowCipherExecutor=" + String.valueOf(this.webflowCipherExecutor) + ", httpClient=" + String.valueOf(this.httpClient) + ")";
        }
    }

    @Generated
    private static final class OAuth20ConfigurationContextBuilderImpl
    extends OAuth20ConfigurationContextBuilder<OAuth20ConfigurationContext, OAuth20ConfigurationContextBuilderImpl> {
        @Generated
        private OAuth20ConfigurationContextBuilderImpl() {
        }

        @Override
        @Generated
        protected OAuth20ConfigurationContextBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OAuth20ConfigurationContext build() {
            return new OAuth20ConfigurationContext(this);
        }
    }
}

