/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.services;

import com.googlecode.cqengine.attribute.Attribute;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.DefaultServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.query.BasicRegisteredServiceQueryIndex;
import org.apereo.cas.services.query.RegisteredServiceQueryAttribute;
import org.apereo.cas.services.query.RegisteredServiceQueryIndex;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20ServicesManagerRegisteredServiceLocator
extends DefaultServicesManagerRegisteredServiceLocator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20ServicesManagerRegisteredServiceLocator.class);
    protected final CasConfigurationProperties casProperties;

    public OAuth20ServicesManagerRegisteredServiceLocator(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
        this.setOrder(Integer.MIN_VALUE);
        this.setRegisteredServiceFilter((registeredService, service) -> this.supports((RegisteredService)registeredService, (Service)service) && this.doesClientIdBelongToRegisteredService((OAuthRegisteredService)registeredService, (Service)service));
    }

    protected boolean doesClientIdBelongToRegisteredService(OAuthRegisteredService registeredService, Service service) {
        LOGGER.trace("Attempting to locate service [{}] via [{}]", (Object)service, (Object)registeredService);
        Object clientIdAttribute = service.getAttributes().get("client_id");
        String clientId = CollectionUtils.firstElement(clientIdAttribute).map(Object::toString).orElse("");
        return StringUtils.isNotBlank((CharSequence)clientId) && StringUtils.equals((CharSequence)registeredService.getClientId(), (CharSequence)clientId);
    }

    public boolean supports(RegisteredService registeredService, Service service) {
        return registeredService instanceof OAuthRegisteredService && this.supportsInternal(registeredService, service);
    }

    public List<RegisteredServiceQueryIndex> getRegisteredServiceIndexes() {
        List indexes = super.getRegisteredServiceIndexes();
        Class<? extends RegisteredService> registeredServiceIndexedType = this.getRegisteredServiceIndexedType();
        indexes.add(BasicRegisteredServiceQueryIndex.hashIndex((Attribute)new RegisteredServiceQueryAttribute(registeredServiceIndexedType, String.class, "clientId")));
        return indexes;
    }

    protected Class<? extends RegisteredService> getRegisteredServiceIndexedType() {
        return OAuthRegisteredService.class;
    }

    protected boolean supportsInternal(RegisteredService registeredService, Service givenService) {
        Map attributes = givenService.getAttributes();
        if (attributes.containsKey("client_id")) {
            WebApplicationService service = (WebApplicationService)givenService;
            String source = CollectionUtils.firstElement(attributes.get(service.getSource())).map(String.class::cast).orElse("");
            String callbackService = OAuth20Utils.casOAuthCallbackUrl(this.casProperties.getServer().getPrefix());
            return StringUtils.isBlank((CharSequence)source) || StringUtils.startsWith((CharSequence)source, (CharSequence)callbackService) || OAuth20Utils.checkCallbackValid(registeredService, source);
        }
        return false;
    }
}

