/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.profile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.profile.OAuth20UserProfileDataCreator;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.inspektr.audit.annotation.Audit;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class DefaultOAuth20UserProfileDataCreator<T extends OAuth20ConfigurationContext>
implements OAuth20UserProfileDataCreator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOAuth20UserProfileDataCreator.class);
    private final ObjectProvider<T> configurationContext;

    @Audit(action="OAUTH2_USER_PROFILE", actionResolverName="OAUTH2_USER_PROFILE_ACTION_RESOLVER", resourceResolverName="OAUTH2_USER_PROFILE_RESOURCE_RESOLVER")
    public Map<String, Object> createFrom(OAuth20AccessToken accessToken, WebContext context) throws Throwable {
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(((OAuth20ConfigurationContext)this.configurationContext.getObject()).getServicesManager(), accessToken.getClientId());
        Principal principal = this.getAccessTokenAuthenticationPrincipal(accessToken, context, (RegisteredService)registeredService);
        HashMap<String, Object> modelAttributes = new HashMap<String, Object>();
        modelAttributes.put("id", principal.getId());
        modelAttributes.put("client_id", accessToken.getClientId());
        modelAttributes.put("attributes", this.collectAttributes(principal, (RegisteredService)registeredService));
        this.finalizeProfileResponse(accessToken, modelAttributes, principal, (RegisteredService)registeredService);
        LOGGER.debug("Final user profile attributes are [{}]", modelAttributes);
        return modelAttributes;
    }

    protected Map<String, List<Object>> collectAttributes(Principal principal, RegisteredService registeredService) {
        HashMap<String, List<Object>> attributes = new HashMap<String, List<Object>>(principal.getAttributes());
        attributes.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(CentralAuthenticationService.NAMESPACE));
        return attributes;
    }

    protected Principal getAccessTokenAuthenticationPrincipal(OAuth20AccessToken accessToken, WebContext context, RegisteredService registeredService) throws Throwable {
        Authentication authentication = accessToken.getAuthentication();
        HashMap attributes = new HashMap(authentication.getPrincipal().getAttributes());
        Map authnAttributes = ((OAuth20ConfigurationContext)this.getConfigurationContext().getObject()).getAuthenticationAttributeReleasePolicy().getAuthenticationAttributesForRelease(authentication, registeredService);
        attributes.putAll(authnAttributes);
        if (accessToken.isStateless()) {
            Principal resolvedPrincipal = ((OAuth20ConfigurationContext)this.configurationContext.getObject()).getPrincipalResolver().resolve((Credential)new BasicIdentifiableCredential(authentication.getPrincipal().getId()));
            attributes.putAll(resolvedPrincipal.getAttributes());
        }
        Principal operatingPrincipal = ((OAuth20ConfigurationContext)this.getConfigurationContext().getObject()).getPrincipalFactory().createPrincipal(authentication.getPrincipal().getId(), attributes);
        LOGGER.debug("Preparing user profile response based on CAS principal [{}]", (Object)operatingPrincipal);
        Principal principal = ((OAuth20ConfigurationContext)this.configurationContext.getObject()).getProfileScopeToAttributesFilter().filter(accessToken.getService(), operatingPrincipal, registeredService, accessToken);
        LOGGER.debug("Created CAS principal [{}] based on requested/authorized scopes", (Object)principal);
        return principal;
    }

    protected void finalizeProfileResponse(OAuth20AccessToken accessTokenTicket, Map<String, Object> modelAttributes, Principal principal, RegisteredService registeredService) {
        if (registeredService instanceof OAuthRegisteredService) {
            Service service = accessTokenTicket.getService();
            modelAttributes.put("service", service.getId());
        }
    }

    @Generated
    public DefaultOAuth20UserProfileDataCreator(ObjectProvider<T> configurationContext) {
        this.configurationContext = configurationContext;
    }

    @Generated
    public ObjectProvider<T> getConfigurationContext() {
        return this.configurationContext;
    }
}

