/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005A3A!\u0004\b\u0001'!)a\u0004\u0001C\u0001?!9\u0011\u0005\u0001b\u0001\n\u0003\u0011\u0003BB\u0017\u0001A\u0003%1\u0005C\u0003/\u0001\u0011\u0005q\u0006C\u0003A\u0001\u0011\u0005q\u0006C\u0003C\u0001\u0011\u0005q\u0006C\u0003E\u0001\u0011\u0005q\u0006C\u0003G\u0001\u0011\u0005q\u0006C\u0003I\u0001\u0011\u0005q\u0006C\u0003K\u0001\u0011\u0005q\u0006C\u0003M\u0001\u0011\u0005q\u0006C\u0003O\u0001\u0011\u0005qFA\u0007D_J,W\u000b^5mgR+7\u000f\u001e\u0006\u0003\u001fA\tQ!\u001e;jYNT\u0011!E\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001AC\u0007\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005maR\"\u0001\b\n\u0005uq!a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"a\u0007\u0001\u0002!\rdWo\u001d;fe&#\u0007+\u0019;uKJtW#A\u0012\u0011\u0005\u0011ZS\"A\u0013\u000b\u0005\u0019:\u0013!\u0002:fO\u0016D(B\u0001\u0015*\u0003\u0011)H/\u001b7\u000b\u0003)\nAA[1wC&\u0011A&\n\u0002\b!\u0006$H/\u001a:o\u0003E\u0019G.^:uKJLE\rU1ui\u0016\u0014h\u000eI\u0001\fi\u0016\u001cHoU<bY2|w\u000fF\u00011!\t)\u0012'\u0003\u00023-\t!QK\\5uQ\t!A\u0007\u0005\u00026}5\taG\u0003\u00028q\u0005\u0019\u0011\r]5\u000b\u0005eR\u0014a\u00026va&$XM\u001d\u0006\u0003wq\nQA[;oSRT\u0011!P\u0001\u0004_J<\u0017BA 7\u0005\u0011!Vm\u001d;\u0002\u001bQ,7\u000f\u001e*fC\u0012\u0014\u0015\u0010^3tQ\t)A'A\u0004uKN$\u0018IY:)\u0005\u0019!\u0014a\u0003;fgR\u001c5O\u001e'jgRD#a\u0002\u001b\u0002\u0015Q,7\u000f^\"tm6\u000b\u0007\u000f\u000b\u0002\ti\u0005QA/Z:u\u0013:dunY6)\u0005%!\u0014a\u0007;fgR,&\u000f\\*bM\u0016\u0014\u0015m]37i\u0015s7m\u001c3f+VKE\t\u000b\u0002\u000bi\u0005AB/Z:u\u000f\u0016tWM]1uKV+\u0018\u000eZ!t\u0005\u0006\u001cXM\u000e\u001b)\u0005-!\u0014!\u0006;fgR\fEo\\7jG\u001e+Go\u0014:Va\u0012\fG/\u001a\u0015\u0003\u0019Q\u0002")
public class CoreUtilsTest
implements Logging {
    private final Pattern clusterIdPattern = Pattern.compile("[a-zA-Z0-9_\\-]+");
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Pattern clusterIdPattern() {
        return this.clusterIdPattern;
    }

    @Test
    public void testSwallow() {
        CoreUtils$.MODULE$.swallow((Function0 & Serializable)() -> {
            throw new KafkaException("test");
        }, (Logging)this, Level.INFO);
    }

    @Test
    public void testReadBytes() {
        new .colon.colon((Object)"", (List)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"abcd", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)testCase -> {
            CoreUtilsTest.$anonfun$testReadBytes$1(testCase);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAbs() {
        Assertions.assertEquals((int)0, (int)Utils.abs((int)Integer.MIN_VALUE));
        Assertions.assertEquals((int)1, (int)Utils.abs((int)-1));
        Assertions.assertEquals((int)0, (int)Utils.abs((int)0));
        Assertions.assertEquals((int)1, (int)Utils.abs((int)1));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)Utils.abs((int)Integer.MAX_VALUE));
    }

    @Test
    public void testCsvList() {
        String emptyString = "";
        Seq emptyList = CoreUtils$.MODULE$.parseCsvList(emptyString);
        Seq emptyListFromNullString = CoreUtils$.MODULE$.parseCsvList(null);
        scala.collection.immutable.Seq emptyStringList = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        Assertions.assertTrue((emptyList != null ? 1 : 0) != 0);
        Assertions.assertTrue((emptyListFromNullString != null ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)emptyStringList.equals((Object)emptyListFromNullString));
        Assertions.assertTrue((boolean)emptyStringList.equals((Object)emptyList));
    }

    @Test
    public void testCsvMap() {
        String emptyString = "";
        Map emptyMap = CoreUtils$.MODULE$.parseCsvMap(emptyString);
        scala.collection.immutable.Map emptyStringMap = Predef$.MODULE$.Map().empty();
        Assertions.assertTrue((emptyMap != null ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)emptyStringMap.equals((Object)emptyStringMap));
        String kvPairsIpV6 = "a:b:c:v,a:b:c:v";
        CoreUtils$.MODULE$.parseCsvMap(kvPairsIpV6).foreach((Function1 & Serializable)m -> {
            CoreUtilsTest.$anonfun$testCsvMap$1(m);
            return BoxedUnit.UNIT;
        });
        String singleEntry = "key:value";
        Assertions.assertTrue((boolean)CoreUtils$.MODULE$.parseCsvMap(singleEntry).getOrElse((Object)"key", (Function0)(JFunction0.mcI.sp & Serializable)() -> 0).equals("value"));
        String kvPairsIpV4 = "192.168.2.1/30:allow, 192.168.2.1/30:allow";
        CoreUtils$.MODULE$.parseCsvMap(kvPairsIpV4).foreach((Function1 & Serializable)m -> {
            CoreUtilsTest.$anonfun$testCsvMap$3(m);
            return BoxedUnit.UNIT;
        });
        String kvPairsSpaces = "key:value      , key:   value";
        CoreUtils$.MODULE$.parseCsvMap(kvPairsSpaces).foreach((Function1 & Serializable)m -> {
            CoreUtilsTest.$anonfun$testCsvMap$4(m);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testInLock() {
        int n;
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        try {
            n = CoreUtilsTest.$anonfun$testInLock$1(lock);
        }
        finally {
            lock.unlock();
        }
        int result = n;
        Assertions.assertEquals((int)2, (int)result);
        Assertions.assertFalse((boolean)lock.isLocked(), (String)"Should be unlocked");
    }

    @Test
    public void testUrlSafeBase64EncodeUUID() {
        String clusterId1 = Base64.getUrlEncoder().withoutPadding().encodeToString(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("a149b4a3-06e1-4b49-a8cb-8a9c4a59fa46")));
        Assertions.assertEquals((Object)clusterId1, (Object)"oUm0owbhS0moy4qcSln6Rg");
        Assertions.assertEquals((int)clusterId1.length(), (int)22);
        Assertions.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId1).matches());
        String clusterId2 = Base64.getUrlEncoder().withoutPadding().encodeToString(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("d418ec02-277e-4853-81e6-afe30259daec")));
        Assertions.assertEquals((Object)clusterId2, (Object)"1BjsAid-SFOB5q_jAlna7A");
        Assertions.assertEquals((int)clusterId2.length(), (int)22);
        Assertions.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId2).matches());
    }

    @Test
    public void testGenerateUuidAsBase64() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        Assertions.assertEquals((int)clusterId.length(), (int)22);
        Assertions.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId).matches());
    }

    @Test
    public void testAtomicGetOrUpdate() {
        int count = 1000;
        int nThreads = 5;
        AtomicInteger createdCount = new AtomicInteger();
        scala.collection.concurrent.Map map = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        ExecutionContextExecutorService executionContext = ExecutionContext$.MODULE$.fromExecutorService(Executors.newFixedThreadPool(nThreads));
        try {
            Await$.MODULE$.result((Awaitable)Future$.MODULE$.traverse((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count), (Function1 & Serializable)x$1 -> Future$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> {
                Object object;
                Integer atomicGetOrUpdate_key = BoxesRunTime.boxToInteger((int)0);
                Option option = map$1.get((Object)atomicGetOrUpdate_key);
                if (option instanceof Some) {
                    object = ((Some)option).value();
                } else if (None$.MODULE$.equals(option)) {
                    AtomicInteger atomicGetOrUpdate_value = CoreUtilsTest.$anonfun$testAtomicGetOrUpdate$3(createdCount$1);
                    object = map$1.putIfAbsent((Object)atomicGetOrUpdate_key, (Object)atomicGetOrUpdate_value).getOrElse(() -> CoreUtils$.$anonfun$atomicGetOrUpdate$1((Object)atomicGetOrUpdate_value));
                } else {
                    throw new MatchError((Object)option);
                }
                Object var2_2 = null;
                option = null;
                Object var4_4 = null;
                return ((AtomicInteger)object).incrementAndGet();
            }, (ExecutionContext)executionContext), BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)executionContext), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.MINUTES));
            Assertions.assertEquals((int)count, (int)((AtomicInteger)map.apply((Object)BoxesRunTime.boxToInteger((int)0))).get());
            int created = createdCount.get();
            Assertions.assertTrue((created > 0 && created <= nThreads ? 1 : 0) != 0, (String)new StringBuilder(19).append("Too many creations ").append(created).toString());
        }
        finally {
            executionContext.shutdownNow();
        }
    }

    public static final /* synthetic */ void $anonfun$testReadBytes$1(String testCase) {
        byte[] bytes = testCase.getBytes();
        Assertions.assertTrue((boolean)Arrays.equals(bytes, Utils.readBytes((ByteBuffer)ByteBuffer.wrap(bytes))));
    }

    public static final /* synthetic */ void $anonfun$testCsvMap$1(Tuple2 m) {
        Assertions.assertTrue((boolean)((String)m._1()).equals("a:b:c"));
        Assertions.assertTrue((boolean)((String)m._2()).equals("v"));
    }

    public static final /* synthetic */ void $anonfun$testCsvMap$3(Tuple2 m) {
        Assertions.assertTrue((boolean)((String)m._1()).equals("192.168.2.1/30"));
        Assertions.assertTrue((boolean)((String)m._2()).equals("allow"));
    }

    public static final /* synthetic */ void $anonfun$testCsvMap$4(Tuple2 m) {
        Assertions.assertTrue((boolean)((String)m._1()).equals("key"));
        Assertions.assertTrue((boolean)((String)m._2()).equals("value"));
    }

    public static final /* synthetic */ int $anonfun$testInLock$1(ReentrantLock lock$1) {
        Assertions.assertTrue((boolean)lock$1.isHeldByCurrentThread(), (String)"Should be in lock");
        return 2;
    }

    public static final /* synthetic */ AtomicInteger $anonfun$testAtomicGetOrUpdate$3(AtomicInteger createdCount$1) {
        createdCount$1.incrementAndGet();
        return new AtomicInteger();
    }
}

