/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005-d\u0001\u0002\b\u0010\u0001QAQa\b\u0001\u0005\u0002\u0001BQA\t\u0001\u0005\u0002\rBQ\u0001\u0016\u0001\u0005\u0002UCQA\u0017\u0001\u0005\nmCQ!\u001b\u0001\u0005\n)DQ\u0001\u001c\u0001\u0005\u00025DQA\u001d\u0001\u0005\nMDq!!\u0001\u0001\t\u0013\t\u0019\u0001C\u0004\u0002\u0014\u0001!\t!!\u0006\t\u000f\u0005\r\u0002\u0001\"\u0003\u0002&!9\u00111\u0006\u0001\u0005\n\u00055\u0002\"CA$\u0001E\u0005I\u0011BA%\u0011\u001d\ty\u0006\u0001C\u0001\u0003C\u0012q\u0003R3mKR,Gk\u001c9jGN\u0014V-];fgR$Vm\u001d;\u000b\u0005A\t\u0012AB:feZ,'OC\u0001\u0013\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u000b\u001a!\t1r#D\u0001\u0010\u0013\tArBA\bCCN,'+Z9vKN$H+Z:u!\tQR$D\u0001\u001c\u0015\ta\u0012#A\u0003vi&d7/\u0003\u0002\u001f7\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001\"!\t1\u0002!\u0001\u0017uKN$Hk\u001c9jG\u0012+G.\u001a;j_:\u001cE.^:uKJD\u0015m](gM2Lg.\u001a)beRLG/[8ogR\u0011AE\u000b\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0005+:LG\u000fC\u0003,\u0005\u0001\u0007A&\u0001\u0004rk>\u0014X/\u001c\t\u0003[Qr!A\f\u001a\u0011\u0005=2S\"\u0001\u0019\u000b\u0005E\u001a\u0012A\u0002\u001fs_>$h(\u0003\u00024M\u00051\u0001K]3eK\u001aL!!\u000e\u001c\u0003\rM#(/\u001b8h\u0015\t\u0019d\u0005\u000b\u0003\u0003q\u0011+\u0005CA\u001dC\u001b\u0005Q$BA\u001e=\u0003\u0019\u0001\u0018M]1ng*\u0011QHP\u0001\bUV\u0004\u0018\u000e^3s\u0015\ty\u0004)A\u0003kk:LGOC\u0001B\u0003\ry'oZ\u0005\u0003\u0007j\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0003\u0019\u000b!e\u001f3jgBd\u0017-\u001f(b[\u0016lhf_1sOVlWM\u001c;t/&$\bNT1nKNl\b\u0006\u0002\u0002I\u001d>\u0003\"!\u0013'\u000e\u0003)S!a\u0013\u001e\u0002\u0011A\u0014xN^5eKJL!!\u0014&\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\t\u0001&+I\u0001R\u0003\tQ8.I\u0001T\u0003\u0015Y'/\u00194u\u0003q!Xm\u001d;WC2LG\rR3mKR,Gk\u001c9jGJ+\u0017/^3tiN$\"\u0001\n,\t\u000b-\u001a\u0001\u0019\u0001\u0017)\t\rAD)\u0012\u0015\u0005\u0007!s\u0015\f\f\u0002Q%\u0006\u0001c/\u00197jI\u0006$XMV1mS\u0012$U\r\\3uKR{\u0007/[2SKF,Xm\u001d;t)\t!C\fC\u0003^\t\u0001\u0007a,A\u0004sKF,Xm\u001d;\u0011\u0005};W\"\u00011\u000b\u0005\u0005\u0014\u0017\u0001\u0003:fcV,7\u000f^:\u000b\u0005\r$\u0017AB2p[6|gN\u0003\u0002\u0013K*\u0011a\rQ\u0001\u0007CB\f7\r[3\n\u0005!\u0004'a\u0005#fY\u0016$X\rV8qS\u000e\u001c(+Z9vKN$\u0018a\n<bY&$\u0017\r^3WC2LG\rR3mKR,Gk\u001c9jGJ+\u0017/^3tiN<\u0016\u000e\u001e5JIN$\"\u0001J6\t\u000bu+\u0001\u0019\u00010\u00029Q,7\u000f^#se>\u0014H)\u001a7fi\u0016$v\u000e]5d%\u0016\fX/Z:ugR\u0011AE\u001c\u0005\u0006W\u0019\u0001\r\u0001\f\u0015\u0005\ra\"U\t\u000b\u0003\u0007\u0011:\u000bH&\u0001)\u0002AY\fG.\u001b3bi\u0016,%O]8s\t\u0016dW\r^3U_BL7MU3rk\u0016\u001cHo\u001d\u000b\u0004IQ,\b\"B/\b\u0001\u0004q\u0006\"\u0002<\b\u0001\u00049\u0018\u0001E3ya\u0016\u001cG/\u001a3SKN\u0004xN\\:f!\u0011i\u0003\u0010\f>\n\u0005e4$aA'baB\u00111P`\u0007\u0002y*\u0011QPY\u0001\taJ|Go\\2pY&\u0011q\u0010 \u0002\u0007\u000bJ\u0014xN]:\u0002OY\fG.\u001b3bi\u0016,%O]8s\t\u0016dW\r^3U_BL7MU3rk\u0016\u001cHo],ji\"LEm\u001d\u000b\u0006I\u0005\u0015\u0011q\u0001\u0005\u0006;\"\u0001\rA\u0018\u0005\u0007m\"\u0001\r!!\u0003\u0011\u000b5B\u00181\u0002>\u0011\t\u00055\u0011qB\u0007\u0002E&\u0019\u0011\u0011\u00032\u0003\tU+\u0018\u000eZ\u0001\u0012i\u0016\u001cHOT8u\u0007>tGO]8mY\u0016\u0014Hc\u0001\u0013\u0002\u0018!)1&\u0003a\u0001Y!\"\u0011\u0002\u000f#FQ\u0015I\u0001JTA\u000fY\r\u0001\u0016qD\u0011\u0003\u0003C\t1B_6NS\u001e\u0014\u0018\r^5p]\u00061b/\u00197jI\u0006$X\rV8qS\u000eL5\u000fR3mKR,G\rF\u0002%\u0003OAa!!\u000b\u000b\u0001\u0004a\u0013!\u0002;pa&\u001c\u0017aF:f]\u0012$U\r\\3uKR{\u0007/[2t%\u0016\fX/Z:u)\u0019\ty#!\u000e\u00028A\u0019q,!\r\n\u0007\u0005M\u0002M\u0001\u000bEK2,G/\u001a+pa&\u001c7OU3ta>t7/\u001a\u0005\u0006;.\u0001\rA\u0018\u0005\n\u0003sY\u0001\u0013!a\u0001\u0003w\tAb]8dW\u0016$8+\u001a:wKJ\u0004B!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u0003\n\u0012a\u00028fi^|'o[\u0005\u0005\u0003\u000b\nyD\u0001\u0007T_\u000e\\W\r^*feZ,'/A\u0011tK:$G)\u001a7fi\u0016$v\u000e]5dgJ+\u0017/^3ti\u0012\"WMZ1vYR$#'\u0006\u0002\u0002L)\"\u00111HA'W\t\ty\u0005\u0005\u0003\u0002R\u0005mSBAA*\u0015\u0011\t)&a\u0016\u0002\u0013Ut7\r[3dW\u0016$'bAA-M\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00131\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\u0007;fgR$U\r\\3uKR{\u0007/[2t-\u0016\u00148/[8ogR\u0019A%a\u0019\t\u000b-j\u0001\u0019\u0001\u0017)\t5AD)\u0012\u0015\u0006\u001b!s\u0015\u0011\u000e\u0017\u0002!\u0002")
public class DeleteTopicsRequestTest
extends BaseRequestTest {
    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicDeletionClusterHasOfflinePartitions(String quorum) {
        String offlineTopic = "topic-1";
        String onlineTopic = "topic-2";
        this.createTopicWithAssignment(offlineTopic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}))), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(onlineTopic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})))}))), this.createTopicWithAssignment$default$3());
        this.killBroker(0);
        this.ensureConsistentKRaftMetadata();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$1(this, onlineTopic, offlineTopic)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Topic partition is not offline");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.deleteTopic(onlineTopic, this.deleteTopic$default$2());
        this.deleteTopic(offlineTopic, this.deleteTopic$default$2());
        this.ensureConsistentKRaftMetadata();
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$5(this, onlineTopic, offlineTopic)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"The topics are found in the Broker's cache");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testValidDeleteTopicRequests(String quorum) {
        int timeout = 10000;
        this.createTopic("topic-1", 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.validateValidDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("topic-1")).setTimeoutMs(timeout)).build());
        this.createTopic("topic-3", 5, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic("topic-4", 1, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.validateValidDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("topic-3", "topic-4")).setTimeoutMs(timeout)).build());
        this.createTopic("topic-7", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic("topic-6", 1, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        scala.collection.immutable.Map<String, Uuid> ids = this.getTopicIds();
        this.validateValidDeleteTopicRequestsWithIds((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopics(Arrays.asList(new DeleteTopicsRequestData.DeleteTopicState().setTopicId((Uuid)ids.apply((Object)"topic-7")), new DeleteTopicsRequestData.DeleteTopicState().setTopicId((Uuid)ids.apply((Object)"topic-6")))).setTimeoutMs(timeout)).build());
    }

    private void validateValidDeleteTopicRequests(DeleteTopicsRequest request) {
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.adminSocketServer());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.MapHasAsScala(response.errorCounts()).asScala().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateValidDeleteTopicRequests$1(x$5))).isEmpty(), (String)new StringBuilder(33).append("There should be no errors, found ").append(CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.data().responses()).asScala()).toString());
        this.ensureConsistentKRaftMetadata();
        request.data().topicNames().forEach(topic -> this.validateTopicIsDeleted((String)topic));
    }

    private void validateValidDeleteTopicRequestsWithIds(DeleteTopicsRequest request) {
        DeleteTopicsResponse response2 = this.sendDeleteTopicsRequest(request, this.adminSocketServer());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.MapHasAsScala(response2.errorCounts()).asScala().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateValidDeleteTopicRequestsWithIds$1(x$6))).isEmpty(), (String)new StringBuilder(33).append("There should be no errors, found ").append(CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response2.data().responses()).asScala()).toString());
        this.ensureConsistentKRaftMetadata();
        response2.data().responses().forEach(response -> this.validateTopicIsDeleted(response.name()));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testErrorDeleteTopicRequests(String quorum) {
        int timeout = 30000;
        String timeoutTopic = "invalid-timeout";
        this.validateErrorDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("invalid-topic")).setTimeoutMs(timeout)).build(), (scala.collection.immutable.Map<String, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalid-topic"), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION)}))));
        this.createTopic("partial-topic-1", 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.validateErrorDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("partial-topic-1", "partial-invalid-topic")).setTimeoutMs(timeout)).build(), (scala.collection.immutable.Map<String, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-topic-1"), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-invalid-topic"), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION)}))));
        this.createTopic("topic-id-1", 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Uuid validId = (Uuid)this.getTopicIds().apply((Object)"topic-id-1");
        Uuid invalidId = Uuid.randomUuid();
        this.validateErrorDeleteTopicRequestsWithIds((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopics(Arrays.asList(new DeleteTopicsRequestData.DeleteTopicState().setTopicId(invalidId), new DeleteTopicsRequestData.DeleteTopicState().setTopicId(validId))).setTimeoutMs(timeout)).build(), (scala.collection.immutable.Map<Uuid, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)invalidId), (Object)Errors.UNKNOWN_TOPIC_ID), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)validId), (Object)Errors.NONE)}))));
        this.createTopic(timeoutTopic, 5, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.validateErrorDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList(timeoutTopic)).setTimeoutMs(0)).build(), (scala.collection.immutable.Map<String, Errors>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)timeoutTopic), (Object)Errors.REQUEST_TIMED_OUT)}))));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicsRequestTest.$anonfun$testErrorDeleteTopicRequests$1(this, timeoutTopic)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicsRequestTest.$anonfun$testErrorDeleteTopicRequests$2(timeoutTopic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.validateTopicIsDeleted(timeoutTopic);
    }

    private void validateErrorDeleteTopicRequests(DeleteTopicsRequest request, scala.collection.immutable.Map<String, Errors> expectedResponse) {
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.adminSocketServer());
        DeleteTopicsResponseData.DeletableTopicResultCollection errors = response.data().responses();
        int errorCount = BoxesRunTime.unboxToInt((Object)CollectionConverters$.MODULE$.MapHasAsScala(response.errorCounts()).asScala().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x$7, x$8) -> BoxesRunTime.boxToInteger((int)DeleteTopicsRequestTest.$anonfun$validateErrorDeleteTopicRequests$1(BoxesRunTime.unboxToInt((Object)x$7), x$8))));
        Assertions.assertEquals((int)expectedResponse.size(), (int)errorCount, (String)"The response size should match");
        expectedResponse.foreach((Function1 & Serializable)x0$1 -> {
            DeleteTopicsRequestTest.$anonfun$validateErrorDeleteTopicRequests$2(this, expectedResponse, errors, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void validateErrorDeleteTopicRequestsWithIds(DeleteTopicsRequest request, scala.collection.immutable.Map<Uuid, Errors> expectedResponse) {
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.adminSocketServer());
        DeleteTopicsResponseData.DeletableTopicResultCollection responses = response.data().responses();
        scala.collection.immutable.Map errors = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)responses).asScala().map((Function1 & Serializable)result -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.topicId()), (Object)BoxesRunTime.boxToShort((short)result.errorCode())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map names = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)responses).asScala().map((Function1 & Serializable)result -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.topicId()), (Object)result.name()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        int errorCount = BoxesRunTime.unboxToInt((Object)CollectionConverters$.MODULE$.MapHasAsScala(response.errorCounts()).asScala().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x$9, x$10) -> BoxesRunTime.boxToInteger((int)DeleteTopicsRequestTest.$anonfun$validateErrorDeleteTopicRequestsWithIds$3(BoxesRunTime.unboxToInt((Object)x$9), x$10))));
        Assertions.assertEquals((int)expectedResponse.size(), (int)errorCount, (String)"The response size should match");
        expectedResponse.foreach((Function1 & Serializable)x0$1 -> {
            DeleteTopicsRequestTest.$anonfun$validateErrorDeleteTopicRequestsWithIds$4(this, expectedResponse, errors, names, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "zkMigration"})
    public void testNotController(String quorum) {
        DeleteTopicsRequest request = (DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Collections.singletonList("not-controller")).setTimeoutMs(1000)).build();
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.notControllerSocketServer());
        Errors expectedError = this.isZkMigrationTest() ? Errors.NONE : Errors.NOT_CONTROLLER;
        short error = response.data().responses().find("not-controller").errorCode();
        Assertions.assertEquals((short)expectedError.code(), (short)error);
    }

    /*
     * WARNING - void declaration
     */
    private void validateTopicIsDeleted(String topic) {
        Iterable metadata = CollectionConverters$.MODULE$.CollectionHasAsScala(((MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava(), true).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).topicMetadata()).asScala();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$1(metadata, topic)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$3(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private DeleteTopicsResponse sendDeleteTopicsRequest(DeleteTopicsRequest request, SocketServer socketServer) {
        return (DeleteTopicsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteTopicsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private SocketServer sendDeleteTopicsRequest$default$2() {
        return this.adminSocketServer();
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testDeleteTopicsVersions(String quorum) {
        Assertions.assertEquals((int)0, (int)0);
        Assertions.assertEquals((int)6, (int)6);
        int timeout = 10000;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])DeleteTopicsRequestData.SCHEMAS))).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Creating and deleting tests for version ").append(version).toString());
            String topicName = new StringBuilder(6).append("topic-").append(version).toString();
            this.createTopic(topicName, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
            DeleteTopicsRequestData data = new DeleteTopicsRequestData().setTimeoutMs(timeout);
            if (version < 6) {
                data.setTopicNames(Arrays.asList(topicName));
            } else {
                data.setTopics(Arrays.asList(new DeleteTopicsRequestData.DeleteTopicState().setName(topicName)));
            }
            this.validateValidDeleteTopicRequests(new DeleteTopicsRequest.Builder(data).build((short)version));
        });
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$2(UpdateMetadataRequestData.UpdateMetadataPartitionState x$1) {
        return x$1.leader() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$3(UpdateMetadataRequestData.UpdateMetadataPartitionState x$2) {
        return x$2.leader() == -1;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$1(DeleteTopicsRequestTest $this, String onlineTopic$1, String offlineTopic$1) {
        return ((KafkaBroker)$this.aliveBrokers().head()).metadataCache().getPartitionInfo(onlineTopic$1, 0).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$2(x$1))) && ((KafkaBroker)$this.aliveBrokers().head()).metadataCache().getPartitionInfo(offlineTopic$1, 0).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$3(x$2)));
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletionClusterHasOfflinePartitions$4() {
        return "Topic partition is not offline";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$6(String onlineTopic$1, KafkaBroker x$3) {
        return x$3.metadataCache().contains(onlineTopic$1);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$7(String offlineTopic$1, KafkaBroker x$4) {
        return x$4.metadataCache().contains(offlineTopic$1);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$5(DeleteTopicsRequestTest $this, String onlineTopic$1, String offlineTopic$1) {
        return !$this.aliveBrokers().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$6(onlineTopic$1, x$3))) && !$this.aliveBrokers().forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$7(offlineTopic$1, x$4)));
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletionClusterHasOfflinePartitions$8() {
        return "The topics are found in the Broker's cache";
    }

    public static final /* synthetic */ boolean $anonfun$validateValidDeleteTopicRequests$1(Tuple2 x$5) {
        Object object = x$5._1();
        Errors errors = Errors.NONE;
        return object == null ? errors != null : !object.equals(errors);
    }

    public static final /* synthetic */ boolean $anonfun$validateValidDeleteTopicRequestsWithIds$1(Tuple2 x$6) {
        Object object = x$6._1();
        Errors errors = Errors.NONE;
        return object == null ? errors != null : !object.equals(errors);
    }

    public static final /* synthetic */ boolean $anonfun$testErrorDeleteTopicRequests$1(DeleteTopicsRequestTest $this, String timeoutTopic$1) {
        return !((KafkaBroker)$this.brokers().head()).metadataCache().contains(timeoutTopic$1);
    }

    public static final /* synthetic */ String $anonfun$testErrorDeleteTopicRequests$2(String timeoutTopic$1) {
        return new StringBuilder(23).append("Topic ").append(timeoutTopic$1).append(" is never deleted").toString();
    }

    public static final /* synthetic */ int $anonfun$validateErrorDeleteTopicRequests$1(int x$7, Tuple2 x$8) {
        return x$7 + Predef$.MODULE$.Integer2int((Integer)x$8._2());
    }

    public static final /* synthetic */ void $anonfun$validateErrorDeleteTopicRequests$2(DeleteTopicsRequestTest $this, scala.collection.immutable.Map expectedResponse$1, DeleteTopicsResponseData.DeletableTopicResultCollection errors$1, Tuple2 x0$1) {
        block5: {
            block8: {
                String topic;
                block7: {
                    Errors errors;
                    Errors errors2;
                    block6: {
                        if (x0$1 == null) break block5;
                        topic = (String)x0$1._1();
                        Errors expectedError = (Errors)x0$1._2();
                        Assertions.assertEquals((short)((Errors)expectedResponse$1.apply((Object)topic)).code(), (short)errors$1.find(topic).errorCode(), (String)"The response error should match");
                        errors2 = expectedError;
                        errors = Errors.NONE;
                        if (errors2 != null) break block6;
                        if (errors != null) {
                            return;
                        }
                        break block7;
                    }
                    if (!errors2.equals(errors)) break block8;
                }
                $this.validateTopicIsDeleted(topic);
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$validateErrorDeleteTopicRequestsWithIds$3(int x$9, Tuple2 x$10) {
        return x$9 + Predef$.MODULE$.Integer2int((Integer)x$10._2());
    }

    public static final /* synthetic */ void $anonfun$validateErrorDeleteTopicRequestsWithIds$4(DeleteTopicsRequestTest $this, scala.collection.immutable.Map expectedResponse$2, scala.collection.immutable.Map errors$2, scala.collection.immutable.Map names$1, Tuple2 x0$1) {
        block5: {
            block8: {
                Uuid topic;
                block7: {
                    Errors errors;
                    Errors errors2;
                    block6: {
                        if (x0$1 == null) break block5;
                        topic = (Uuid)x0$1._1();
                        Errors expectedError = (Errors)x0$1._2();
                        Assertions.assertEquals((short)((Errors)expectedResponse$2.apply((Object)topic)).code(), (short)BoxesRunTime.unboxToShort((Object)errors$2.apply((Object)topic)), (String)"The response error should match");
                        errors2 = expectedError;
                        errors = Errors.NONE;
                        if (errors2 != null) break block6;
                        if (errors != null) {
                            return;
                        }
                        break block7;
                    }
                    if (!errors2.equals(errors)) break block8;
                }
                $this.validateTopicIsDeleted((String)names$1.apply((Object)topic));
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicIsDeleted$2(String topic$1, MetadataResponse.TopicMetadata p) {
        if (p.topic().equals(topic$1)) {
            Errors errors = p.error();
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicIsDeleted$1(Iterable metadata$1, String topic$1) {
        return !metadata$1.exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$2(topic$1, p)));
    }

    public static final /* synthetic */ String $anonfun$validateTopicIsDeleted$3(String topic$1) {
        return new StringBuilder(27).append("The topic ").append(topic$1).append(" should not exist").toString();
    }
}

