/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Optional;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommand$;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005e3Aa\u0002\u0005\u0001\u001b!)!\u0003\u0001C\u0001'!)Q\u0003\u0001C\u0001-!)A\t\u0001C\u0001\u000b\")\u0011\n\u0001C\u0001\u000b\")Q\n\u0001C\u0001\u001d\")1\u000b\u0001C\u0001)\n)B*[:u\u0007>t7/^7fe\u001e\u0013x.\u001e9UKN$(BA\u0005\u000b\u0003\u0015\tG-\\5o\u0015\u0005Y\u0011!B6bM.\f7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003!I!!\u0005\u0005\u00031\r{gn];nKJ<%o\\;q\u0007>lW.\u00198e)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002)A\u0011q\u0002A\u0001\u0017i\u0016\u001cH\u000fT5ti\u000e{gn];nKJ<%o\\;qgR\u0011q#\b\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0005+:LG\u000fC\u0003\u001f\u0005\u0001\u0007q$\u0001\u0004rk>\u0014X/\u001c\t\u0003A\u001dr!!I\u0013\u0011\u0005\tJR\"A\u0012\u000b\u0005\u0011b\u0011A\u0002\u001fs_>$h(\u0003\u0002'3\u00051\u0001K]3eK\u001aL!\u0001K\u0015\u0003\rM#(/\u001b8h\u0015\t1\u0013\u0004\u000b\u0002\u0003WA\u0011A&N\u0007\u0002[)\u0011afL\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005A\n\u0014a\u00026va&$XM\u001d\u0006\u0003eM\nQA[;oSRT\u0011\u0001N\u0001\u0004_J<\u0017B\u0001\u001c.\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0015\u0005\u0005art\b\u0005\u0002:y5\t!H\u0003\u0002<[\u0005A\u0001O]8wS\u0012,'/\u0003\u0002>u\tYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONd#\u0001\u0011\"\"\u0003\u0005\u000b!A_6\"\u0003\r\u000bQa\u001b:bMR\f\u0011\u0006^3ti2K7\u000f^,ji\",fN]3d_\u001et\u0017N_3e\u001d\u0016<8i\u001c8tk6,'o\u00149uS>tG#A\f)\u0005\rY\u0003\u0006B\u00029}!c#\u0001\u0011\"\u0002AQ,7\u000f\u001e'jgR\u001cuN\\:v[\u0016\u0014xI]8vaN<\u0016\u000e\u001e5Ti\u0006$Xm\u001d\u0015\u0003\t-BC\u0001\u0002\u001d?\u00192\u0012\u0001IQ\u0001\"i\u0016\u001cHoQ8ogVlWM]$s_V\u00048\u000b^1uKN4%o\\7TiJLgn\u001a\u000b\u0003/=CQAH\u0003A\u0002}A#!B\u0016)\t\u0015AdH\u0015\u0017\u0003\u0001\n\u000bA\u0003^3ti2K7\u000f^$s_V\u00048i\\7nC:$GCA\fV\u0011\u0015qb\u00011\u0001 Q\t11\u0006\u000b\u0003\u0007qyBFF\u0001!C\u0001")
public class ListConsumerGroupTest
extends ConsumerGroupCommandTest {
    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testListConsumerGroups(String quorum) {
        String simpleGroup = "simple-group";
        Iterable<TopicPartition> x$2 = this.addSimpleGroupExecutor$default$1();
        this.addSimpleGroupExecutor(x$2, simpleGroup);
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--list"};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Set expectedGroups = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.group(), simpleGroup}));
        Predef$.MODULE$.Set().empty();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            Set set = service.listConsumerGroups().toSet();
            Set set2 = expectedGroups;
            if (!(set2 != null ? !set2.equals(set) : set != null)) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)new StringBuilder(44).append("Expected --list to show groups ").append(expectedGroups).append(", but found ").append(set).append(".").toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testListWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = new String[]{"--new-consumer", "--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--list"};
        Assertions.assertThrows(OptionException.class, () -> this.getConsumerGroupService(cgcArgs));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testListConsumerGroupsWithStates() {
        Set set;
        String simpleGroup = "simple-group";
        Iterable<TopicPartition> x$2 = this.addSimpleGroupExecutor$default$1();
        this.addSimpleGroupExecutor(x$2, simpleGroup);
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--list", "--state"};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Set expectedListing = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupListing[]{new ConsumerGroupListing(simpleGroup, true, Optional.of(ConsumerGroupState.EMPTY)), new ConsumerGroupListing(this.group(), false, Optional.of(ConsumerGroupState.STABLE))}));
        Predef$.MODULE$.Set().empty();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            set = service.listConsumerGroupsWithState(Predef$.MODULE$.wrapRefArray((Object[])ConsumerGroupState.values()).toSet()).toSet();
            Set set2 = expectedListing;
            if (!(set2 != null ? !set2.equals(set) : set != null)) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)new StringBuilder(36).append("Expected to show groups ").append(expectedListing).append(", but found ").append(set).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Set expectedListingStable = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupListing[]{new ConsumerGroupListing(this.group(), false, Optional.of(ConsumerGroupState.STABLE))}));
        Predef$.MODULE$.Set().empty();
        set = null;
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            set = service.listConsumerGroupsWithState((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE}))).toSet();
            Set set3 = expectedListingStable;
            if (!(set3 != null ? !set3.equals(set) : set != null)) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)new StringBuilder(36).append("Expected to show groups ").append(expectedListingStable).append(", but found ").append(set).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testConsumerGroupStatesFromString(String quorum) {
        Set result = ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("Stable");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE})), (Object)result);
        result = ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("Stable, PreparingRebalance");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE, ConsumerGroupState.PREPARING_REBALANCE})), (Object)result);
        result = ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("Dead,CompletingRebalance,");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.DEAD, ConsumerGroupState.COMPLETING_REBALANCE})), (Object)result);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("bad, wrong"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("stable"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("  bad, Stable"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("   ,   ,"));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testListGroupCommand(String quorum) {
        String string;
        String simpleGroup = "simple-group";
        Iterable<TopicPartition> x$2 = this.addSimpleGroupExecutor$default$1();
        this.addSimpleGroupExecutor(x$2, simpleGroup);
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        ObjectRef cgcArgs = ObjectRef.create((Object)new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--list"});
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(!(string = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$2.elem))).contains("STATE") && string.contains(simpleGroup) && string.contains(this.group()))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)new StringBuilder(45).append("Expected to find ").append(simpleGroup).append(", ").append(this.group()).append(" and no header, but found ").append(string).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        cgcArgs.elem = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--list", "--state"};
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!((string = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$2.elem))).contains("STATE") && string.contains(simpleGroup) && string.contains(this.group()))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)new StringBuilder(46).append("Expected to find ").append(simpleGroup).append(", ").append(this.group()).append(" and the header, but found ").append(string).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        cgcArgs.elem = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--list", "--state", "Stable"};
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!((string = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$2.elem))).contains("STATE") && string.contains(this.group()) && string.contains("Stable"))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)new StringBuilder(60).append("Expected to find ").append(this.group()).append(" in state Stable and the header, but found ").append(string).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testListConsumerGroups$1(ObjectRef foundGroups$1, ConsumerGroupCommand.ConsumerGroupService service$1, Set expectedGroups$1) {
        foundGroups$1.elem = service$1.listConsumerGroups().toSet();
        Set set = expectedGroups$1;
        Set set2 = (Set)foundGroups$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testListConsumerGroups$2(Set expectedGroups$1, ObjectRef foundGroups$1) {
        return new StringBuilder(44).append("Expected --list to show groups ").append(expectedGroups$1).append(", but found ").append((Set)foundGroups$1.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListConsumerGroupsWithStates$1(ObjectRef foundListing$1, ConsumerGroupCommand.ConsumerGroupService service$2, Set expectedListing$1) {
        foundListing$1.elem = service$2.listConsumerGroupsWithState(Predef$.MODULE$.wrapRefArray((Object[])ConsumerGroupState.values()).toSet()).toSet();
        Set set = expectedListing$1;
        Set set2 = (Set)foundListing$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testListConsumerGroupsWithStates$2(Set expectedListing$1, ObjectRef foundListing$1) {
        return new StringBuilder(36).append("Expected to show groups ").append(expectedListing$1).append(", but found ").append((Set)foundListing$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListConsumerGroupsWithStates$3(ObjectRef foundListing$1, ConsumerGroupCommand.ConsumerGroupService service$2, Set expectedListingStable$1) {
        foundListing$1.elem = service$2.listConsumerGroupsWithState((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE}))).toSet();
        Set set = expectedListingStable$1;
        Set set2 = (Set)foundListing$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testListConsumerGroupsWithStates$4(Set expectedListingStable$1, ObjectRef foundListing$1) {
        return new StringBuilder(36).append("Expected to show groups ").append(expectedListingStable$1).append(", but found ").append((Set)foundListing$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListGroupCommand$1(ListConsumerGroupTest $this, ObjectRef out$1, ObjectRef cgcArgs$2, String simpleGroup$1) {
        out$1.elem = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$2.elem));
        return !((String)out$1.elem).contains("STATE") && ((String)out$1.elem).contains(simpleGroup$1) && ((String)out$1.elem).contains($this.group());
    }

    public static final /* synthetic */ String $anonfun$testListGroupCommand$3(ListConsumerGroupTest $this, String simpleGroup$1, ObjectRef out$1) {
        return new StringBuilder(45).append("Expected to find ").append(simpleGroup$1).append(", ").append($this.group()).append(" and no header, but found ").append((String)out$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListGroupCommand$4(ListConsumerGroupTest $this, ObjectRef out$1, ObjectRef cgcArgs$2, String simpleGroup$1) {
        out$1.elem = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$2.elem));
        return ((String)out$1.elem).contains("STATE") && ((String)out$1.elem).contains(simpleGroup$1) && ((String)out$1.elem).contains($this.group());
    }

    public static final /* synthetic */ String $anonfun$testListGroupCommand$6(ListConsumerGroupTest $this, String simpleGroup$1, ObjectRef out$1) {
        return new StringBuilder(46).append("Expected to find ").append(simpleGroup$1).append(", ").append($this.group()).append(" and the header, but found ").append((String)out$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListGroupCommand$7(ListConsumerGroupTest $this, ObjectRef out$1, ObjectRef cgcArgs$2) {
        out$1.elem = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$2.elem));
        return ((String)out$1.elem).contains("STATE") && ((String)out$1.elem).contains($this.group()) && ((String)out$1.elem).contains("Stable");
    }

    public static final /* synthetic */ String $anonfun$testListGroupCommand$9(ListConsumerGroupTest $this, ObjectRef out$1) {
        return new StringBuilder(60).append("Expected to find ").append($this.group()).append(" in state Stable and the header, but found ").append((String)out$1.elem).toString();
    }
}

