/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.ServiceTicketGeneratorAuthority;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.CasWebflowCredentialProvider;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ServiceWarningAction
extends BaseCasWebflowAction {
    public static final String PARAMETER_NAME_IGNORE_WARNING = "ignorewarn";
    private final CentralAuthenticationService centralAuthenticationService;
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final TicketRegistrySupport ticketRegistrySupport;
    private final CasCookieBuilder warnCookieGenerator;
    private final PrincipalElectionStrategy principalElectionStrategy;
    private final List<ServiceTicketGeneratorAuthority> serviceTicketAuthorities;
    private final CasWebflowCredentialProvider casWebflowCredentialProvider;

    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        String ticketGrantingTicket = WebUtils.getTicketGrantingTicketId((RequestContext)requestContext);
        FunctionUtils.throwIf((boolean)StringUtils.isBlank((CharSequence)ticketGrantingTicket), () -> new InvalidTicketException((Throwable)new AuthenticationException("No ticket-granting ticket could be found in the context"), ticketGrantingTicket));
        Authentication authentication = this.ticketRegistrySupport.getAuthenticationFrom(ticketGrantingTicket);
        FunctionUtils.throwIfNull((Object)authentication, () -> new InvalidTicketException((Throwable)new AuthenticationException("No authentication found for ticket " + ticketGrantingTicket), ticketGrantingTicket));
        List credentials = this.casWebflowCredentialProvider.extract(requestContext);
        AuthenticationResultBuilder authenticationResultBuilder = this.authenticationSystemSupport.establishAuthenticationContextFromInitial(authentication, credentials.toArray(credentials.toArray(new Credential[0])));
        AuthenticationResult authenticationResult = (AuthenticationResult)FunctionUtils.doUnchecked(() -> authenticationResultBuilder.build(this.principalElectionStrategy, (Service)service));
        this.grantServiceTicket(authenticationResult, (Service)service, requestContext);
        if (request.getParameterMap().containsKey(PARAMETER_NAME_IGNORE_WARNING) && BooleanUtils.toBoolean((String)request.getParameter(PARAMETER_NAME_IGNORE_WARNING))) {
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
            this.warnCookieGenerator.removeCookie(response);
        }
        return new Event((Object)this, "redirect");
    }

    private void grantServiceTicket(AuthenticationResult authenticationResult, Service service, RequestContext requestContext) {
        this.serviceTicketAuthorities.stream().sorted(AnnotationAwareOrderComparator.INSTANCE).filter(auth -> auth.supports(authenticationResult, service)).findFirst().ifPresent(Unchecked.consumer(auth -> {
            String ticketGrantingTicket = WebUtils.getTicketGrantingTicketId((RequestContext)requestContext);
            Ticket serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicket, service, authenticationResult);
            WebUtils.putServiceTicketInRequestScope((RequestContext)requestContext, (Ticket)serviceTicketId);
        }));
    }

    @Generated
    public ServiceWarningAction(CentralAuthenticationService centralAuthenticationService, AuthenticationSystemSupport authenticationSystemSupport, TicketRegistrySupport ticketRegistrySupport, CasCookieBuilder warnCookieGenerator, PrincipalElectionStrategy principalElectionStrategy, List<ServiceTicketGeneratorAuthority> serviceTicketAuthorities, CasWebflowCredentialProvider casWebflowCredentialProvider) {
        this.centralAuthenticationService = centralAuthenticationService;
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.ticketRegistrySupport = ticketRegistrySupport;
        this.warnCookieGenerator = warnCookieGenerator;
        this.principalElectionStrategy = principalElectionStrategy;
        this.serviceTicketAuthorities = serviceTicketAuthorities;
        this.casWebflowCredentialProvider = casWebflowCredentialProvider;
    }
}

