/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.support.TriStateBoolean;
import org.apereo.cas.monitor.Monitorable;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.SingleSignOnParticipationRequest;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.cas.web.support.gen.CookieRetrievingCookieGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@Monitorable
public class SendTicketGrantingTicketAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SendTicketGrantingTicketAction.class);
    private final TicketRegistry ticketRegistry;
    private final CasCookieBuilder ticketGrantingCookieBuilder;
    private final SingleSignOnParticipationStrategy singleSignOnParticipationStrategy;
    private final ApplicationContext applicationContext;

    protected Event doExecuteInternal(RequestContext context) throws Throwable {
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        String ticketGrantingTicketValueFromCookie = WebUtils.getTicketGrantingTicketIdFrom((MutableAttributeMap)context.getFlowScope());
        if (StringUtils.isBlank((CharSequence)ticketGrantingTicketId)) {
            LOGGER.debug("No ticket-granting ticket is found in the context.");
            return this.success();
        }
        Event finalEvent = this.success();
        SingleSignOnParticipationRequest ssoRequest = SingleSignOnParticipationRequest.builder().requestContext(context).build();
        if (WebUtils.isAuthenticatingAtPublicWorkstation((RequestContext)context)) {
            LOGGER.info("Authentication is at a public workstation. SSO cookie will not be generated");
        } else if (this.singleSignOnParticipationStrategy.supports(ssoRequest)) {
            boolean createCookie = this.shouldCreateSingleSignOnCookie(ssoRequest, ticketGrantingTicketId);
            if (createCookie) {
                LOGGER.debug("Setting ticket-granting cookie for current session linked to [{}].", (Object)ticketGrantingTicketId);
                finalEvent = this.createSingleSignOnCookie(context, ticketGrantingTicketId);
            } else {
                LOGGER.info("Authentication session is renewed but CAS is not configured to create the SSO session. SSO cookie will not be generated. Subsequent requests will be challenged for credentials.");
            }
        }
        if (ticketGrantingTicketValueFromCookie != null && !ticketGrantingTicketId.equals(ticketGrantingTicketValueFromCookie)) {
            LOGGER.debug("Ticket-granting ticket from ticket-granting cookie does not match the ticket-granting ticket from context");
            this.ticketRegistry.deleteTicket(ticketGrantingTicketValueFromCookie);
        }
        return finalEvent;
    }

    protected boolean shouldCreateSingleSignOnCookie(SingleSignOnParticipationRequest ssoRequest, String ticketGrantingTicketId) throws Throwable {
        return this.singleSignOnParticipationStrategy.isCreateCookieOnRenewedAuthentication(ssoRequest) == TriStateBoolean.TRUE || this.singleSignOnParticipationStrategy.isParticipating(ssoRequest);
    }

    protected Event createSingleSignOnCookie(RequestContext requestContext, String ticketGrantingTicketId) throws Exception {
        Ticket ticketGrantingTicket = this.ticketRegistry.getTicket(ticketGrantingTicketId);
        if (ticketGrantingTicket.isStateless()) {
            return this.result("writeToBrowserStorage", (AttributeMap)new LocalAttributeMap(TicketGrantingTicket.class.getName(), (Object)ticketGrantingTicketId));
        }
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        Boolean rememberMeAuthentication = CookieRetrievingCookieGenerator.isRememberMeAuthentication((RequestContext)requestContext);
        this.ticketGrantingCookieBuilder.addCookie(request, response, rememberMeAuthentication.booleanValue(), ticketGrantingTicketId);
        return this.success();
    }

    @Generated
    public SendTicketGrantingTicketAction(TicketRegistry ticketRegistry, CasCookieBuilder ticketGrantingCookieBuilder, SingleSignOnParticipationStrategy singleSignOnParticipationStrategy, ApplicationContext applicationContext) {
        this.ticketRegistry = ticketRegistry;
        this.ticketGrantingCookieBuilder = ticketGrantingCookieBuilder;
        this.singleSignOnParticipationStrategy = singleSignOnParticipationStrategy;
        this.applicationContext = applicationContext;
    }

    @Generated
    public TicketRegistry getTicketRegistry() {
        return this.ticketRegistry;
    }

    @Generated
    public CasCookieBuilder getTicketGrantingCookieBuilder() {
        return this.ticketGrantingCookieBuilder;
    }

    @Generated
    public SingleSignOnParticipationStrategy getSingleSignOnParticipationStrategy() {
        return this.singleSignOnParticipationStrategy;
    }

    @Generated
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

