/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import java.net.URI;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.util.scripting.ScriptResourceCacheManager;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class RedirectUnauthorizedServiceUrlAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RedirectUnauthorizedServiceUrlAction.class);
    private final ServicesManager servicesManager;
    private final ApplicationContext applicationContext;

    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        URI redirectUrl = this.determineUnauthorizedServiceRedirectUrl(requestContext);
        String url = redirectUrl.toString();
        Optional scriptFactory = ExecutableCompiledScriptFactory.findExecutableCompiledScriptFactory();
        if (scriptFactory.isPresent() && ((ExecutableCompiledScriptFactory)scriptFactory.get()).isScript(url)) {
            redirectUrl = (URI)FunctionUtils.doUnchecked(() -> {
                RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)requestContext);
                Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
                Map args = CollectionUtils.wrap((String)"registeredService", (Object)registeredService, (String)"authentication", (Object)authentication, (String)"requestContext", (Object)requestContext, (String)"applicationContext", (Object)this.applicationContext, (String)"logger", (Object)LOGGER);
                ScriptResourceCacheManager scriptResourceCacheManager = (ScriptResourceCacheManager)ApplicationContextProvider.getScriptResourceCacheManager().orElseThrow();
                ExecutableCompiledScript scriptToExec = scriptResourceCacheManager.resolveScriptableResource(url, new String[0]);
                scriptToExec.setBinding(args);
                return (URI)scriptToExec.execute(args.values().toArray(), URI.class);
            });
        }
        LOGGER.debug("Redirecting to unauthorized redirect URL [{}]", (Object)redirectUrl);
        WebUtils.putUnauthorizedRedirectUrlIntoFlowScope((RequestContext)requestContext, (URI)redirectUrl);
        return null;
    }

    protected URI determineUnauthorizedServiceRedirectUrl(RequestContext context) {
        URI redirectUrl = WebUtils.getUnauthorizedRedirectUrlFromFlowScope((RequestContext)context);
        Event currentEvent = context.getCurrentEvent();
        AttributeMap eventAttributes = currentEvent.getAttributes();
        LOGGER.debug("Finalizing the unauthorized redirect URL [{}] when processing event [{}] with attributes [{}]", new Object[]{redirectUrl, currentEvent.getId(), eventAttributes});
        return redirectUrl;
    }

    @Generated
    public RedirectUnauthorizedServiceUrlAction(ServicesManager servicesManager, ApplicationContext applicationContext) {
        this.servicesManager = servicesManager;
        this.applicationContext = applicationContext;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

