/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalProvisioner;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PrincipalProvisionerAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PrincipalProvisionerAction.class);
    private final PrincipalProvisioner principalProvisioner;

    protected Event doExecuteInternal(RequestContext requestContext) {
        Credential credential = WebUtils.getCredential((RequestContext)requestContext);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        if (credential == null || authentication == null) {
            LOGGER.warn("No credential or authentication found in the request context to provision");
            return this.success();
        }
        Principal principal = authentication.getPrincipal();
        RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)requestContext);
        LOGGER.debug("Starting to provision principal [{}] with registered service [{}]", (Object)principal, (Object)registeredService);
        boolean res = this.principalProvisioner.provision(authentication, credential, registeredService);
        String msg = String.format("Provisioning of principal %s is%s done successfully", principal, BooleanUtils.toString((boolean)res, (String)"", (String)" not"));
        LOGGER.debug(msg);
        return res ? this.success() : this.error();
    }

    @Generated
    public PrincipalProvisionerAction(PrincipalProvisioner principalProvisioner) {
        this.principalProvisioner = principalProvisioner;
    }
}

