/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PopulateSpringSecurityContextAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PopulateSpringSecurityContextAction.class);
    private final ObjectProvider<SecurityContextRepository> securityContextRepository;

    protected Event doExecuteInternal(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        SecurityContext context = this.buildAuthenticationContext(requestContext);
        this.securityContextRepository.ifAvailable(secContext -> secContext.saveContext(context, request, response));
        SecurityContextHolder.setContext((SecurityContext)context);
        return null;
    }

    protected SecurityContext buildAuthenticationContext(RequestContext requestContext) {
        org.apereo.cas.authentication.Authentication authn = WebUtils.getAuthentication((RequestContext)requestContext);
        Principal principal = this.resolvePrincipal(authn.getPrincipal(), requestContext);
        List authorities = principal.getAttributes().keySet().stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
        authorities.add(new SimpleGrantedAuthority("ROLE_USER"));
        PreAuthenticatedAuthenticationToken secAuth = new PreAuthenticatedAuthenticationToken((Object)principal, (Object)authn.getCredentials(), authorities);
        secAuth.setAuthenticated(true);
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        secAuth.setDetails((Object)new PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails(request, authorities));
        SecurityContext context = SecurityContextHolder.getContext();
        context.setAuthentication((Authentication)secAuth);
        HttpSession session = request.getSession(true);
        LOGGER.trace("Storing security context in session [{}] for [{}]", (Object)session.getId(), (Object)principal);
        session.setAttribute("SPRING_SECURITY_CONTEXT", (Object)context);
        return context;
    }

    protected Principal resolvePrincipal(Principal principal, RequestContext requestContext) {
        ArrayList resolvers = new ArrayList(requestContext.getActiveFlow().getApplicationContext().getBeansOfType(MultifactorAuthenticationPrincipalResolver.class).values());
        AnnotationAwareOrderComparator.sort(resolvers);
        return resolvers.stream().filter(resolver -> resolver.supports(principal)).findFirst().map(r -> r.resolve(principal)).orElse(principal);
    }

    @Generated
    public PopulateSpringSecurityContextAction(ObjectProvider<SecurityContextRepository> securityContextRepository) {
        this.securityContextRepository = securityContextRepository;
    }
}

