/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web.flow.action;

import java.util.ArrayList;
import java.util.Objects;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityDirectCredential;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.duo.web.flow.action.DuoSecurityAuthenticationWebflowAction;
import org.apereo.cas.api.PasswordlessUserAccount;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.flow.PasswordlessWebflowUtils;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DuoSecurityVerifyPasswordlessAuthenticationAction
extends DuoSecurityAuthenticationWebflowAction {
    private final AuthenticationSystemSupport authenticationSystemSupport;

    public DuoSecurityVerifyPasswordlessAuthenticationAction(AuthenticationSystemSupport authenticationSystemSupport, CasWebflowEventResolver duoAuthenticationWebflowEventResolver) {
        super(duoAuthenticationWebflowEventResolver);
        this.authenticationSystemSupport = authenticationSystemSupport;
    }

    @Override
    protected Event doExecuteInternal(RequestContext requestContext) throws Exception {
        ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)requestContext.getActiveFlow().getApplicationContext()).getBeanFactory();
        ArrayList providers = new ArrayList(BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, DuoSecurityMultifactorAuthenticationProvider.class).values());
        return providers.stream().filter(Objects::nonNull).filter(BeanSupplier::isNotProxy).map(DuoSecurityMultifactorAuthenticationProvider.class::cast).filter(provider -> provider.getDuoAuthenticationService().getProperties().isPasswordlessAuthenticationEnabled()).map(provider -> (Event)FunctionUtils.doAndHandle(() -> {
            PasswordlessUserAccount account = (PasswordlessUserAccount)PasswordlessWebflowUtils.getPasswordlessAuthenticationAccount((RequestContext)requestContext, PasswordlessUserAccount.class);
            Principal principal = PrincipalFactoryUtils.newPrincipalFactory().createPrincipal(account.getUsername());
            DuoSecurityDirectCredential credential = new DuoSecurityDirectCredential(principal, provider.getId());
            WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
            AuthenticationResultBuilder authenticationResultBuilder = this.authenticationSystemSupport.handleInitialAuthenticationTransaction((Service)service, new Credential[]{credential});
            AuthenticationResult authenticationResult = this.authenticationSystemSupport.finalizeAllAuthenticationTransactions(authenticationResultBuilder, (Service)service);
            WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)authenticationResultBuilder, (RequestContext)requestContext);
            WebUtils.putAuthenticationResult((AuthenticationResult)authenticationResult, (RequestContext)requestContext);
            WebUtils.putAuthentication((Authentication)authenticationResult.getAuthentication(), (RequestContext)requestContext);
            WebUtils.putCredential((RequestContext)requestContext, (Credential)credential);
            return this.success();
        }, e -> this.error()).get()).findFirst().orElseGet(() -> this.error());
    }
}

