/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web.flow.action;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityUniversalPromptCredential;
import org.apereo.cas.adaptors.duo.web.flow.action.DuoSecurityAuthenticationWebflowAction;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.pac4j.BrowserWebStorageSessionStore;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.scope.ConversationScope;
import org.springframework.webflow.scope.FlashScope;
import org.springframework.webflow.scope.FlowScope;
import org.springframework.webflow.scope.RequestScope;

public class DuoSecurityUniversalPromptValidateLoginAction
extends DuoSecurityAuthenticationWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DuoSecurityUniversalPromptValidateLoginAction.class);
    static final String REQUEST_PARAMETER_CODE = "duo_code";
    static final String REQUEST_PARAMETER_STATE = "state";
    private final BrowserWebStorageSessionStore sessionStore;
    private final ConfigurableApplicationContext applicationContext;
    private final AuthenticationSystemSupport authenticationSystemSupport;

    public DuoSecurityUniversalPromptValidateLoginAction(CasWebflowEventResolver duoAuthenticationWebflowEventResolver, BrowserWebStorageSessionStore sessionStore, ConfigurableApplicationContext applicationContext, AuthenticationSystemSupport authenticationSystemSupport) {
        super(duoAuthenticationWebflowEventResolver);
        this.sessionStore = sessionStore;
        this.applicationContext = applicationContext;
        this.authenticationSystemSupport = authenticationSystemSupport;
    }

    @Override
    protected Event doExecuteInternal(RequestContext requestContext) throws Exception {
        ParameterMap requestParameters = requestContext.getRequestParameters();
        if (requestParameters.contains(REQUEST_PARAMETER_CODE) && requestParameters.contains(REQUEST_PARAMETER_STATE)) {
            return this.handleDuoSecurityUniversalPromptResponse(requestContext);
        }
        return new EventFactorySupport().event((Object)this, "skip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event handleDuoSecurityUniversalPromptResponse(RequestContext requestContext) throws Exception {
        Optional browserStorage = WebUtils.getBrowserStoragePayload((RequestContext)requestContext);
        if (browserStorage.isEmpty()) {
            WebUtils.putTargetTransition((RequestContext)requestContext, (String)"switch");
            WebUtils.putTargetState((RequestContext)requestContext, (String)requestContext.getCurrentState().getId());
            WebUtils.putBrowserStorageContextKey((RequestContext)requestContext, (String)this.sessionStore.getBrowserStorageContextKey());
            return new EventFactorySupport().event((Object)this, "restore");
        }
        String duoState = (String)WebUtils.getRequestParameterOrAttribute((RequestContext)requestContext, (String)REQUEST_PARAMETER_STATE).orElseThrow();
        LOGGER.trace("Received Duo Security state [{}]", (Object)duoState);
        BrowserWebStorageSessionStore browserSessionStore = null;
        JEEContext webContext = DuoSecurityUniversalPromptValidateLoginAction.toWebContext(requestContext);
        try {
            browserSessionStore = this.sessionStore.buildFromTrackableSession((WebContext)webContext, browserStorage.get()).map(BrowserWebStorageSessionStore.class::cast).orElseThrow(() -> new IllegalArgumentException("Unable to determine Duo authentication context from session store"));
            browserSessionStore.getSessionAttributes((WebContext)webContext).forEach((key, value) -> {
                if (key.equalsIgnoreCase(FlowScope.class.getSimpleName())) {
                    DuoSecurityUniversalPromptValidateLoginAction.populateRequestContextScope(value, (MutableAttributeMap<Object>)requestContext.getFlowScope());
                } else if (key.equalsIgnoreCase(FlashScope.class.getSimpleName())) {
                    DuoSecurityUniversalPromptValidateLoginAction.populateRequestContextScope(value, (MutableAttributeMap<Object>)requestContext.getFlashScope());
                } else if (key.equalsIgnoreCase(RequestScope.class.getSimpleName())) {
                    DuoSecurityUniversalPromptValidateLoginAction.populateRequestContextScope(value, (MutableAttributeMap<Object>)requestContext.getRequestScope());
                } else if (key.equalsIgnoreCase(ConversationScope.class.getSimpleName())) {
                    DuoSecurityUniversalPromptValidateLoginAction.populateRequestContextScope(value, (MutableAttributeMap<Object>)requestContext.getConversationScope());
                } else {
                    requestContext.getFlowScope().put(key, value);
                }
            });
            this.populateContextWithCredential(requestContext, browserSessionStore);
            this.populateContextWithAuthentication(requestContext, browserSessionStore);
            this.populateContextWithService(requestContext, browserSessionStore);
            Event event = super.doExecuteInternal(requestContext);
            return event;
        }
        catch (Throwable e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
        }
        finally {
            if (browserSessionStore != null) {
                Credential credential = (Credential)browserSessionStore.getSessionAttributes((WebContext)webContext).get(Credential.class.getSimpleName());
                WebUtils.putCredential((RequestContext)requestContext, (Credential)credential);
            }
        }
        return new EventFactorySupport().event((Object)this, "error");
    }

    private static JEEContext toWebContext(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        return new JEEContext(request, response);
    }

    private static void populateRequestContextScope(Object flowAttributes, MutableAttributeMap<Object> requestContext) {
        LinkedHashMap mappedAttributes = new LinkedHashMap((Map)flowAttributes);
        CollectionUtils.filter(mappedAttributes.values(), (Predicate)PredicateUtils.notNullPredicate());
        requestContext.putAll((AttributeMap)new LocalAttributeMap(mappedAttributes));
    }

    protected void populateContextWithService(RequestContext requestContext, BrowserWebStorageSessionStore sessionStorage) {
        JEEContext webContext = DuoSecurityUniversalPromptValidateLoginAction.toWebContext(requestContext);
        RegisteredService registeredService = (RegisteredService)sessionStorage.getSessionAttributes((WebContext)webContext).get(RegisteredService.class.getSimpleName());
        WebUtils.putRegisteredService((RequestContext)requestContext, (RegisteredService)registeredService);
        LOGGER.debug("Restored registered service [{}] into webflow context", (Object)registeredService);
        Service service = (Service)sessionStorage.getSessionAttributes((WebContext)webContext).get(Service.class.getSimpleName());
        WebUtils.putServiceIntoFlowScope((RequestContext)requestContext, (Service)service);
        LOGGER.debug("Restored service [{}] into webflow context", (Object)service);
    }

    protected void populateContextWithCredential(RequestContext requestContext, BrowserWebStorageSessionStore sessionStorage) {
        JEEContext webContext = DuoSecurityUniversalPromptValidateLoginAction.toWebContext(requestContext);
        Authentication authentication = (Authentication)sessionStorage.getSessionAttributes((WebContext)webContext).get(Authentication.class.getSimpleName());
        String duoCode = (String)WebUtils.getRequestParameterOrAttribute((RequestContext)requestContext, (String)REQUEST_PARAMETER_CODE).orElseThrow();
        LOGGER.trace("Received Duo Security code [{}]", (Object)duoCode);
        String duoSecurityIdentifier = (String)sessionStorage.getSessionAttributes((WebContext)webContext).get("duoProviderId");
        DuoSecurityUniversalPromptCredential credential = new DuoSecurityUniversalPromptCredential(duoCode, authentication);
        MultifactorAuthenticationProvider provider = (MultifactorAuthenticationProvider)MultifactorAuthenticationUtils.getMultifactorAuthenticationProviderById((String)duoSecurityIdentifier, (ApplicationContext)this.applicationContext).orElseThrow(() -> new IllegalArgumentException("Unable to locate multifactor authentication provider by id " + duoSecurityIdentifier));
        credential.setProviderId(provider.getId());
        WebUtils.putCredential((RequestContext)requestContext, (Credential)credential);
    }

    protected void populateContextWithAuthentication(RequestContext requestContext, BrowserWebStorageSessionStore sessionStorage) throws Throwable {
        JEEContext webContext = DuoSecurityUniversalPromptValidateLoginAction.toWebContext(requestContext);
        AuthenticationResultBuilder authenticationResultBuilder = (AuthenticationResultBuilder)sessionStorage.getSessionAttributes((WebContext)webContext).get(AuthenticationResultBuilder.class.getSimpleName());
        FunctionUtils.doIfNotNull((Object)authenticationResultBuilder, value -> WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)value, (RequestContext)requestContext));
        AuthenticationResult authenticationResult = authenticationResultBuilder.build(this.authenticationSystemSupport.getPrincipalElectionStrategy());
        WebUtils.putAuthenticationResult((AuthenticationResult)authenticationResult, (RequestContext)requestContext);
        Objects.requireNonNull(authenticationResult.getAuthentication());
        WebUtils.putAuthentication((Authentication)authenticationResult.getAuthentication(), (RequestContext)requestContext);
    }
}

