/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web.flow.action;

import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccount;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccountStatus;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationRegistrationCipherExecutor;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionOptionalSigningOptionalJwtCryptographyProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DuoSecurityDetermineUserAccountAction
extends AbstractMultifactorAuthenticationAction<DuoSecurityMultifactorAuthenticationProvider> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DuoSecurityDetermineUserAccountAction.class);
    private final CasConfigurationProperties casProperties;
    private final ServicesManager servicesManager;
    private final PrincipalResolver principalResolver;

    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        Principal principal = this.resolvePrincipal(authentication.getPrincipal(), requestContext);
        DuoSecurityUserAccount account = this.getDuoSecurityUserAccount(principal);
        EventFactorySupport eventFactorySupport = new EventFactorySupport();
        if (account.getStatus() == DuoSecurityUserAccountStatus.ENROLL && StringUtils.isNotBlank((CharSequence)((DuoSecurityMultifactorAuthenticationProvider)this.provider).getRegistration().getRegistrationUrl())) {
            String url = this.buildDuoRegistrationUrlFor(requestContext, (DuoSecurityMultifactorAuthenticationProvider)this.provider, principal);
            LOGGER.info("Duo Security registration url for enrollment is [{}]", (Object)url);
            requestContext.getFlowScope().put("duoRegistrationUrl", (Object)url);
            return eventFactorySupport.event((Object)this, "enroll");
        }
        if (account.getStatus() == DuoSecurityUserAccountStatus.ALLOW) {
            return eventFactorySupport.event((Object)this, "bypass");
        }
        if (account.getStatus() == DuoSecurityUserAccountStatus.DENY) {
            return eventFactorySupport.event((Object)this, "deny");
        }
        if (account.getStatus() == DuoSecurityUserAccountStatus.UNAVAILABLE) {
            return eventFactorySupport.event((Object)this, "unavailable");
        }
        return this.success();
    }

    protected DuoSecurityUserAccount getDuoSecurityUserAccount(Principal principal) {
        DuoSecurityAuthenticationService duoAuthenticationService = ((DuoSecurityMultifactorAuthenticationProvider)this.provider).getDuoAuthenticationService();
        if (!duoAuthenticationService.getProperties().isAccountStatusEnabled()) {
            LOGGER.debug("Checking Duo Security for user's [{}] account status is disabled", (Object)principal.getId());
            DuoSecurityUserAccount account = new DuoSecurityUserAccount(principal.getId());
            account.setStatus(DuoSecurityUserAccountStatus.AUTH);
            return account;
        }
        return duoAuthenticationService.getUserAccount(principal.getId());
    }

    protected String buildDuoRegistrationUrlFor(RequestContext requestContext, DuoSecurityMultifactorAuthenticationProvider provider, Principal principal) throws Throwable {
        ApplicationContext applicationContext = requestContext.getActiveFlow().getApplicationContext();
        DuoSecurityAuthenticationRegistrationCipherExecutor cipher = (DuoSecurityAuthenticationRegistrationCipherExecutor)CipherExecutorUtils.newStringCipherExecutor((EncryptionOptionalSigningOptionalJwtCryptographyProperties)provider.getRegistration().getCrypto(), DuoSecurityAuthenticationRegistrationCipherExecutor.class);
        URIBuilder builder = new URIBuilder(provider.getRegistration().getRegistrationUrl());
        if (cipher.isEnabled()) {
            JwtBuilder jwtBuilder = new JwtBuilder((CipherExecutor)cipher, applicationContext, this.servicesManager, this.principalResolver, this.casProperties);
            JwtBuilder.JwtRequest jwtRequest = JwtBuilder.JwtRequest.builder().serviceAudience(Set.of(builder.getHost())).subject(principal.getId()).jwtId(UUID.randomUUID().toString()).issuer(this.casProperties.getServer().getName()).build();
            String jwt = jwtBuilder.build(jwtRequest);
            builder.addParameter("principal", jwt);
        }
        return builder.toString();
    }

    @Generated
    public DuoSecurityDetermineUserAccountAction(CasConfigurationProperties casProperties, ServicesManager servicesManager, PrincipalResolver principalResolver) {
        this.casProperties = casProperties;
        this.servicesManager = servicesManager;
        this.principalResolver = principalResolver;
    }
}

