/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccount;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;

@Endpoint(id="duoAccountStatus", enableByDefault=false)
public class DuoSecurityUserAccountStatusEndpoint
extends BaseCasActuatorEndpoint {
    private final ApplicationContext applicationContext;

    public DuoSecurityUserAccountStatusEndpoint(CasConfigurationProperties casProperties, ApplicationContext applicationContext) {
        super(casProperties);
        this.applicationContext = applicationContext;
    }

    @ReadOperation(produces={"application/json"})
    @Operation(summary="Fetch Duo Security user account status", parameters={@Parameter(name="username", required=true, description="The username to fetch"), @Parameter(name="providerId", description="The multifactor authentication provider id defined in CAS settings")})
    public Map<?, ?> fetchAccountStatus(@Selector String username, @Nullable String providerId) {
        SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
        LinkedHashMap results = new LinkedHashMap();
        Collection providers = this.applicationContext.getBeansOfType(DuoSecurityMultifactorAuthenticationProvider.class).values();
        providers.stream().filter(Objects::nonNull).filter(BeanSupplier::isNotProxy).map(DuoSecurityMultifactorAuthenticationProvider.class::cast).filter(provider -> StringUtils.isBlank((CharSequence)providerId) || provider.matches(providerId)).forEach(provider -> {
            DuoSecurityAuthenticationService duoService = provider.getDuoAuthenticationService();
            DuoSecurityUserAccount accountStatus = duoService.getUserAccount(username);
            results.put(provider.getId(), CollectionUtils.wrap((String)"duoApiHost", (Object)resolver.resolve(duoService.getProperties().getDuoApiHost()), (String)"name", (Object)provider.getFriendlyName(), (String)"accountStatus", (Object)accountStatus));
        });
        return results;
    }
}

