/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.authn.passwordless;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccountStatus;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.api.PasswordlessAuthenticationRequest;
import org.apereo.cas.api.PasswordlessUserAccount;
import org.apereo.cas.api.PasswordlessUserAccountStore;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.springframework.context.ConfigurableApplicationContext;

public class DuoSecurityPasswordlessUserAccountStore
implements PasswordlessUserAccountStore {
    private final ConfigurableApplicationContext applicationContext;

    public Optional<? extends PasswordlessUserAccount> findUser(PasswordlessAuthenticationRequest request) throws Throwable {
        Collection providers = this.applicationContext.getBeansOfType(DuoSecurityMultifactorAuthenticationProvider.class).values();
        return providers.stream().filter(Objects::nonNull).filter(BeanSupplier::isNotProxy).map(DuoSecurityMultifactorAuthenticationProvider.class::cast).filter(provider -> provider.getDuoAuthenticationService().getProperties().isPasswordlessAuthenticationEnabled()).map(provider -> {
            DuoSecurityAuthenticationService duoService = provider.getDuoAuthenticationService();
            return duoService.getAdminApiService().flatMap(admin -> (Optional)FunctionUtils.doUnchecked(() -> admin.getDuoSecurityUserAccount(request.getUsername(), false)));
        }).filter(Optional::isPresent).map(Optional::get).filter(account -> account.getStatus() != DuoSecurityUserAccountStatus.ENROLL).map(duoAccount -> PasswordlessUserAccount.builder().username(duoAccount.getUsername()).email(duoAccount.getEmail()).name(duoAccount.getFirstName()).phone(duoAccount.getPhone()).source(duoAccount.getProviderId()).build()).findFirst();
    }

    @Generated
    public DuoSecurityPasswordlessUserAccountStore(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

