/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.authn;

import com.duosecurity.Client;
import com.duosecurity.model.AccessDevice;
import com.duosecurity.model.Application;
import com.duosecurity.model.AuthContext;
import com.duosecurity.model.AuthDevice;
import com.duosecurity.model.AuthResult;
import com.duosecurity.model.HealthCheckResponse;
import com.duosecurity.model.Location;
import com.duosecurity.model.Token;
import com.github.benmanes.caffeine.cache.Cache;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccount;
import org.apereo.cas.adaptors.duo.authn.BaseDuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationResult;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityUniversalPromptCredential;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.mfa.duo.DuoSecurityMultifactorAuthenticationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.http.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalPromptDuoSecurityAuthenticationService
extends BaseDuoSecurityAuthenticationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(UniversalPromptDuoSecurityAuthenticationService.class);
    private static final long serialVersionUID = -1690808348975271382L;
    private final Client duoClient;

    public UniversalPromptDuoSecurityAuthenticationService(DuoSecurityMultifactorAuthenticationProperties duoProperties, HttpClient httpClient, Client duoClient, List<MultifactorAuthenticationPrincipalResolver> multifactorAuthenticationPrincipalResolver, Cache<String, DuoSecurityUserAccount> userAccountCache) {
        super(duoProperties, httpClient, multifactorAuthenticationPrincipalResolver, userAccountCache);
        this.duoClient = duoClient;
    }

    public Optional<Object> getDuoClient() {
        return Optional.of(this.duoClient);
    }

    @Override
    public DuoSecurityAuthenticationResult authenticateInternal(Credential credential) throws Exception {
        DuoSecurityUniversalPromptCredential duoCredential = (DuoSecurityUniversalPromptCredential)credential;
        LOGGER.trace("Exchanging Duo Security authorization code [{}]", (Object)credential.getId());
        Principal principal = this.resolvePrincipal(duoCredential.getAuthentication().getPrincipal());
        Token result = this.duoClient.exchangeAuthorizationCodeFor2FAResult(credential.getId(), principal.getId());
        LOGGER.debug("Validated Duo Security code [{}] with result [{}]", (Object)credential.getId(), (Object)result);
        String username = (String)StringUtils.defaultIfBlank((CharSequence)result.getPreferred_username(), (CharSequence)result.getSub());
        LinkedHashMap<String, List> attributes = new LinkedHashMap<String, List>();
        if (this.getProperties().isCollectDuoAttributes()) {
            AuthResult authResult;
            attributes.put("duoExp", CollectionUtils.wrap((Object)result.getExp()));
            attributes.put("duoIss", CollectionUtils.wrap((Object)result.getIss()));
            attributes.put("duoIat", CollectionUtils.wrap((Object)result.getIat()));
            attributes.put("duoAuthTime", CollectionUtils.wrap((Object)result.getAuth_time()));
            attributes.put("duoSub", CollectionUtils.wrap((Object)result.getSub()));
            attributes.put("duoPreferredUsername", CollectionUtils.wrap((Object)result.getPreferred_username()));
            attributes.put("duoAud", CollectionUtils.wrap((Object)result.getAud()));
            AuthContext authContext = result.getAuth_context();
            if (authContext != null) {
                AuthDevice authDevice;
                Application application;
                attributes.put("duoAuthCtxEventType", CollectionUtils.wrap((Object)authContext.getEvent_type()));
                attributes.put("duoAuthCtxFactor", CollectionUtils.wrap((Object)authContext.getFactor()));
                attributes.put("duoAuthCtxReason", CollectionUtils.wrap((Object)authContext.getReason()));
                attributes.put("duoAuthCtxResult", CollectionUtils.wrap((Object)authContext.getResult()));
                attributes.put("duoAuthCtxTimestamp", CollectionUtils.wrap((Object)authContext.getTimestamp()));
                attributes.put("duoAuthCtxTxId", CollectionUtils.wrap((Object)authContext.getTxid()));
                attributes.put("duoAuthCtxUserKey", CollectionUtils.wrap((Object)authContext.getUser().getKey()));
                AccessDevice accessDevice = authContext.getAccess_device();
                if (accessDevice != null) {
                    if (StringUtils.isNotBlank((CharSequence)accessDevice.getHostname())) {
                        attributes.put("duoAuthCtxAccessDeviceHostname", CollectionUtils.wrap((Object)accessDevice.getHostname()));
                    }
                    attributes.put("duoAuthCtxAccessDeviceIp", CollectionUtils.wrap((Object)accessDevice.getIp()));
                    Location accessLocation = accessDevice.getLocation();
                    if (accessLocation != null) {
                        attributes.put("duoAuthCtxAccessDeviceLocationCity", CollectionUtils.wrap((Object)accessLocation.getCity()));
                        attributes.put("duoAuthCtxAccessDeviceLocationCountry", CollectionUtils.wrap((Object)accessLocation.getCountry()));
                        attributes.put("duoAuthCtxAccessDeviceLocationState", CollectionUtils.wrap((Object)accessLocation.getState()));
                    }
                }
                if ((application = authContext.getApplication()) != null) {
                    attributes.put("duoAuthCtxApplicationName", CollectionUtils.wrap((Object)application.getName()));
                }
                if ((authDevice = authContext.getAuth_device()) != null) {
                    attributes.put("duoAuthCtxAuthDeviceHostname", CollectionUtils.wrap((Object)authDevice.getName()));
                    attributes.put("duoAuthCtxAuthDeviceIp", CollectionUtils.wrap((Object)authDevice.getIp()));
                    Location authLocation = authDevice.getLocation();
                    if (authLocation != null) {
                        attributes.put("duoAuthCtxAuthDeviceLocationCity", CollectionUtils.wrap((Object)authLocation.getCity()));
                        attributes.put("duoAuthCtxAuthDeviceLocationCountry", CollectionUtils.wrap((Object)authLocation.getCountry()));
                        attributes.put("duoAuthCtxAuthDeviceLocationState", CollectionUtils.wrap((Object)authLocation.getState()));
                    }
                }
            }
            if ((authResult = result.getAuth_result()) != null) {
                attributes.put("duoAuthResult", CollectionUtils.wrap((Object)authResult.getResult()));
                attributes.put("duoAuthResultStatus", CollectionUtils.wrap((Object)authResult.getStatus()));
                attributes.put("duoAuthResultStatusMessage", CollectionUtils.wrap((Object)authResult.getStatus_msg()));
            }
        }
        return DuoSecurityAuthenticationResult.builder().success(true).username(username).attributes(attributes).build();
    }

    public boolean ping() {
        try {
            HealthCheckResponse response = this.duoClient.healthCheck();
            LOGGER.debug("Received Duo Security health check response [{}]", (Object)response);
            return true;
        }
        catch (Exception e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
            return false;
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UniversalPromptDuoSecurityAuthenticationService)) {
            return false;
        }
        UniversalPromptDuoSecurityAuthenticationService other = (UniversalPromptDuoSecurityAuthenticationService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Client this$duoClient = this.duoClient;
        Client other$duoClient = other.duoClient;
        return !(this$duoClient == null ? other$duoClient != null : !this$duoClient.equals(other$duoClient));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UniversalPromptDuoSecurityAuthenticationService;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Client $duoClient = this.duoClient;
        result = result * 59 + ($duoClient == null ? 43 : $duoClient.hashCode());
        return result;
    }
}

