/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.audit.support;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.common.web.ClientInfo;

public abstract class AbstractStringAuditTrailManager
implements AuditTrailManager {
    private AuditTrailManager.AuditFormats auditFormat = AuditTrailManager.AuditFormats.DEFAULT;
    private boolean useSingleLine;
    private String entrySeparator = ",";
    private List<AuditTrailManager.AuditableFields> auditableFields = new ArrayList<AuditTrailManager.AuditableFields>();

    protected String toString(AuditActionContext auditActionContext) {
        if (this.auditFormat == AuditTrailManager.AuditFormats.JSON) {
            StringBuilder builder = new StringBuilder();
            try {
                ObjectWriter writer = this.useSingleLine ? MAPPER.writer((PrettyPrinter)new MinimalPrettyPrinter()) : MAPPER.writerWithDefaultPrettyPrinter();
                builder.append(writer.writeValueAsString(this.getMappedAuditActionContext(auditActionContext)));
                if (!this.useSingleLine) {
                    builder.append('\n');
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            return builder.toString();
        }
        return this.getAuditLineString(auditActionContext);
    }

    protected void buildSingleAuditLineForField(AuditTrailManager.AuditableFields field, Object value, StringBuilder builder) {
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(field)) {
            if (this.useSingleLine) {
                builder.append(value);
                builder.append(this.getEntrySeparator());
            } else {
                builder.append("%s: ".formatted(field.name()));
                builder.append(value);
                builder.append('\n');
            }
        }
    }

    protected String getAuditLineString(AuditActionContext auditActionContext) {
        StringBuilder builder = new StringBuilder();
        if (!this.useSingleLine) {
            builder.append("Audit trail record BEGIN\n");
            builder.append("=============================================================\n");
        }
        ClientInfo clientInfo = auditActionContext.getClientInfo();
        this.buildSingleAuditLineForField(AuditTrailManager.AuditableFields.WHEN, auditActionContext.getWhenActionWasPerformed(), builder);
        this.buildSingleAuditLineForField(AuditTrailManager.AuditableFields.WHO, auditActionContext.getPrincipal(), builder);
        this.buildSingleAuditLineForField(AuditTrailManager.AuditableFields.WHAT, auditActionContext.getResourceOperatedUpon(), builder);
        this.buildSingleAuditLineForField(AuditTrailManager.AuditableFields.ACTION, auditActionContext.getActionPerformed(), builder);
        this.buildSingleAuditLineForField(AuditTrailManager.AuditableFields.APPLICATION, auditActionContext.getApplicationCode(), builder);
        this.buildSingleAuditLineForField(AuditTrailManager.AuditableFields.USER_AGENT, clientInfo.getUserAgent(), builder);
        this.buildSingleAuditLineForField(AuditTrailManager.AuditableFields.CLIENT_IP, clientInfo.getClientIpAddress(), builder);
        this.buildSingleAuditLineForField(AuditTrailManager.AuditableFields.SERVER_IP, clientInfo.getServerIpAddress(), builder);
        this.buildSingleAuditLineForField(AuditTrailManager.AuditableFields.DEVICE_FINGERPRINT, clientInfo.getDeviceFingerprint(), builder);
        if (!this.useSingleLine) {
            builder.append("=============================================================");
            builder.append("\n\n");
        }
        return builder.toString();
    }

    private static Object readFieldValue(String value) {
        try {
            return MAPPER.readValue(value, Map.class);
        }
        catch (Exception e) {
            return value;
        }
    }

    protected Map<String, ?> getMappedAuditActionContext(AuditActionContext auditActionContext) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.WHO)) {
            map.put("who", AbstractStringAuditTrailManager.readFieldValue(auditActionContext.getPrincipal()));
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.WHAT)) {
            map.put("what", AbstractStringAuditTrailManager.readFieldValue(auditActionContext.getResourceOperatedUpon()));
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.ACTION)) {
            map.put("action", AbstractStringAuditTrailManager.readFieldValue(auditActionContext.getActionPerformed()));
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.APPLICATION)) {
            map.put("application", AbstractStringAuditTrailManager.readFieldValue(auditActionContext.getApplicationCode()));
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.WHEN)) {
            map.put("when", AbstractStringAuditTrailManager.readFieldValue(auditActionContext.getWhenActionWasPerformed().toString()));
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.CLIENT_IP)) {
            map.put("clientIpAddress", AbstractStringAuditTrailManager.readFieldValue(auditActionContext.getClientInfo().getClientIpAddress()));
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.SERVER_IP)) {
            map.put("serverIpAddress", AbstractStringAuditTrailManager.readFieldValue(auditActionContext.getClientInfo().getServerIpAddress()));
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.USER_AGENT)) {
            map.put("userAgent", AbstractStringAuditTrailManager.readFieldValue(auditActionContext.getClientInfo().getUserAgent()));
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.HEADERS)) {
            map.put("headers", auditActionContext.getClientInfo().getHeaders());
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.GEO_LOCATION)) {
            map.put("geoLocation", AbstractStringAuditTrailManager.readFieldValue(auditActionContext.getClientInfo().getGeoLocation()));
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.DEVICE_FINGERPRINT)) {
            map.put("deviceFingerprint", AbstractStringAuditTrailManager.readFieldValue(auditActionContext.getClientInfo().getDeviceFingerprint()));
        }
        return map;
    }

    @Generated
    public void setAuditFormat(AuditTrailManager.AuditFormats auditFormat) {
        this.auditFormat = auditFormat;
    }

    @Generated
    public void setUseSingleLine(boolean useSingleLine) {
        this.useSingleLine = useSingleLine;
    }

    @Generated
    public void setEntrySeparator(String entrySeparator) {
        this.entrySeparator = entrySeparator;
    }

    @Generated
    public void setAuditableFields(List<AuditTrailManager.AuditableFields> auditableFields) {
        this.auditableFields = auditableFields;
    }

    @Generated
    public AuditTrailManager.AuditFormats getAuditFormat() {
        return this.auditFormat;
    }

    @Generated
    public boolean isUseSingleLine() {
        return this.useSingleLine;
    }

    @Generated
    public String getEntrySeparator() {
        return this.entrySeparator;
    }

    @Generated
    public List<AuditTrailManager.AuditableFields> getAuditableFields() {
        return this.auditableFields;
    }
}

