/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi.resource;

import java.util.Map;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.RegisteredServiceAwareAuthenticationTransaction;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.core.audit.AuditEngineProperties;
import org.apereo.cas.util.AopUtils;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.aspectj.lang.JoinPoint;

public class CredentialsAsFirstParameterResourceResolver
implements AuditResourceResolver {
    protected final AuthenticationServiceSelectionPlan serviceSelectionStrategy;
    protected final AuditEngineProperties properties;

    public String[] resolveFrom(JoinPoint joinPoint, Object retval) {
        return this.toResources(AopUtils.unWrapJoinPoint((JoinPoint)joinPoint).getArgs());
    }

    public String[] resolveFrom(JoinPoint joinPoint, Exception exception) {
        return this.toResources(AopUtils.unWrapJoinPoint((JoinPoint)joinPoint).getArgs());
    }

    protected String[] toResources(Object[] args) {
        Object object = args[0];
        if (object instanceof AuthenticationTransaction) {
            AuthenticationTransaction transaction = (AuthenticationTransaction)object;
            return new String[]{this.tranactionToResourceString(transaction)};
        }
        return new String[]{this.toResourceString(CollectionUtils.wrap((Object)object))};
    }

    protected String tranactionToResourceString(AuthenticationTransaction transaction) {
        Map payload = CollectionUtils.wrap((String)"credential", (Object)transaction.getCredentials());
        if (transaction instanceof RegisteredServiceAwareAuthenticationTransaction) {
            RegisteredServiceAwareAuthenticationTransaction rsat = (RegisteredServiceAwareAuthenticationTransaction)transaction;
            FunctionUtils.doIfNotNull((Object)rsat.getRegisteredService(), registeredService -> {
                payload.put("registeredServiceId", registeredService.getServiceId());
                payload.put("registeredServiceName", registeredService.getName());
                payload.put("service", this.getServiceId(transaction.getService()));
            });
        }
        AuditTrailManager.AuditFormats auditFormat = AuditTrailManager.AuditFormats.valueOf((String)this.properties.getAuditFormat().name());
        return auditFormat.serialize((Object)payload);
    }

    protected String toResourceString(Object credential) {
        AuditTrailManager.AuditFormats auditFormat = AuditTrailManager.AuditFormats.valueOf((String)this.properties.getAuditFormat().name());
        return auditFormat.serialize(credential);
    }

    private String getServiceId(Service service) {
        String serviceId = (String)FunctionUtils.doUnchecked(() -> this.serviceSelectionStrategy.resolveService(service).getId());
        return DigestUtils.abbreviate((String)serviceId, (int)this.properties.getAbbreviationLength());
    }

    @Generated
    public CredentialsAsFirstParameterResourceResolver(AuthenticationServiceSelectionPlan serviceSelectionStrategy, AuditEngineProperties properties) {
        this.serviceSelectionStrategy = serviceSelectionStrategy;
        this.properties = properties;
    }
}

