/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.batch;

import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.rest.api.batch.BatchItem;
import org.apache.syncope.common.rest.api.batch.BatchPayloadLine;
import org.apache.syncope.common.rest.api.batch.BatchPayloadLineReader;
import org.apache.syncope.common.rest.api.batch.BatchRequestItem;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BatchPayloadParser {
    private static final Logger LOG = LoggerFactory.getLogger(BatchPayloadParser.class);
    private static final Pattern PATTERN_LAST_CRLF = Pattern.compile("(.*)\\r\\n\\s*", 32);
    private static final Pattern PATTERN_HEADER_LINE = Pattern.compile("((?:\\w|[!#$%\\&'*+\\-.^`|~])+):\\s?(.*)\\s*");
    private static final Pattern PATTERN_BLANK_LINE = Pattern.compile("\\s*\r?\n\\s*");
    private static final String[] HTTP_METHODS = new String[]{"DELETE", "PATCH", "POST", "PUT"};

    private static BatchPayloadLine removeEndingCRLF(BatchPayloadLine line) {
        Matcher matcher = PATTERN_LAST_CRLF.matcher(line.toString());
        return matcher.matches() ? new BatchPayloadLine(matcher.group(1), line.getLineNumber()) : line;
    }

    private static void removeEndingCRLFFromList(List<BatchPayloadLine> lines) {
        if (!lines.isEmpty()) {
            BatchPayloadLine lastLine = lines.remove(lines.size() - 1);
            lines.add(BatchPayloadParser.removeEndingCRLF(lastLine));
        }
    }

    private static List<List<BatchPayloadLine>> split(List<BatchPayloadLine> lines, String boundary) {
        ArrayList<List<BatchPayloadLine>> messageParts = new ArrayList<List<BatchPayloadLine>>();
        ArrayList<BatchPayloadLine> currentPart = new ArrayList<BatchPayloadLine>();
        boolean isEndReached = false;
        String quotedBoundary = Pattern.quote(boundary);
        Pattern boundaryDelimiterPattern = Pattern.compile("--" + quotedBoundary + "--\\s*");
        Pattern boundaryPattern = Pattern.compile("--" + quotedBoundary + "\\s*");
        for (BatchPayloadLine line : lines) {
            if (boundaryDelimiterPattern.matcher(line.toString()).matches()) {
                BatchPayloadParser.removeEndingCRLFFromList(currentPart);
                messageParts.add(currentPart);
                isEndReached = true;
            } else if (boundaryPattern.matcher(line.toString()).matches()) {
                BatchPayloadParser.removeEndingCRLFFromList(currentPart);
                messageParts.add(currentPart);
                currentPart = new ArrayList();
            } else {
                currentPart.add(line);
            }
            if (!isEndReached) continue;
            break;
        }
        if (!messageParts.isEmpty()) {
            messageParts.remove(0);
        }
        if (!isEndReached) {
            int lineNumber = lines.isEmpty() ? 0 : lines.get(0).getLineNumber();
            throw new IllegalArgumentException("Missing close boundary delimiter around line " + lineNumber);
        }
        return messageParts;
    }

    private static void consumeHeaders(List<BatchPayloadLine> bodyPart, BatchItem item) {
        Matcher headerMatcher;
        BatchPayloadLine currentLine;
        HashMap<String, List<Object>> headers = new HashMap<String, List<Object>>();
        boolean isHeader = true;
        Iterator<BatchPayloadLine> itor = bodyPart.iterator();
        while (itor.hasNext() && isHeader) {
            currentLine = itor.next();
            headerMatcher = PATTERN_HEADER_LINE.matcher(currentLine.toString());
            if (headerMatcher.matches() && headerMatcher.groupCount() == 2) {
                itor.remove();
                continue;
            }
            isHeader = false;
        }
        BatchPayloadParser.consumeBlankLine(bodyPart);
        isHeader = true;
        itor = bodyPart.iterator();
        while (itor.hasNext() && isHeader) {
            currentLine = itor.next();
            if (currentLine.toString().contains("HTTP/1.1")) {
                BatchItem bri;
                itor.remove();
                if (ArrayUtils.contains((Object[])HTTP_METHODS, (Object)StringUtils.substringBefore((String)currentLine.toString(), (String)" ")) && item instanceof BatchRequestItem) {
                    bri = (BatchRequestItem)BatchRequestItem.class.cast(item);
                    String[] parts = currentLine.toString().split(" ");
                    ((BatchRequestItem)bri).setMethod(parts[0]);
                    String[] target = parts[1].split("\\?");
                    ((BatchRequestItem)bri).setRequestURI(target[0]);
                    if (target.length <= 1) continue;
                    ((BatchRequestItem)bri).setQueryString(target[1]);
                    continue;
                }
                if (!(item instanceof BatchResponseItem)) continue;
                bri = (BatchResponseItem)BatchResponseItem.class.cast(item);
                try {
                    ((BatchResponseItem)bri).setStatus(Integer.parseInt(StringUtils.substringBefore((String)StringUtils.substringAfter((String)currentLine.toString(), (String)" "), (String)" ").trim()));
                }
                catch (NumberFormatException e) {
                    LOG.error("Invalid value found in response for HTTP status", (Throwable)e);
                }
                continue;
            }
            headerMatcher = PATTERN_HEADER_LINE.matcher(currentLine.toString());
            if (headerMatcher.matches() && headerMatcher.groupCount() == 2) {
                itor.remove();
                String headerName = headerMatcher.group(1).trim();
                String headerValue = headerMatcher.group(2).trim();
                ArrayList<String> header = (ArrayList<String>)headers.get(headerName);
                if (header == null) {
                    header = new ArrayList<String>();
                    headers.put(headerName, header);
                }
                header.addAll(Stream.of(headerValue.split(",")).map(String::trim).toList());
                continue;
            }
            isHeader = false;
        }
        BatchPayloadParser.consumeBlankLine(bodyPart);
        item.setHeaders(headers);
    }

    private static void consumeBlankLine(List<BatchPayloadLine> bodyPart) {
        if (!bodyPart.isEmpty() && PATTERN_BLANK_LINE.matcher(bodyPart.get(0).toString()).matches()) {
            bodyPart.remove(0);
        }
    }

    public static <T extends BatchItem> List<T> parse(InputStream in, MediaType multipartMixed, T template) throws IOException {
        List<BatchPayloadLine> lines;
        try (BatchPayloadLineReader lineReader = new BatchPayloadLineReader(in, multipartMixed);){
            lines = lineReader.read();
        }
        return BatchPayloadParser.split(lines, (String)multipartMixed.getParameters().get("boundary")).stream().map(bodyPart -> {
            LOG.debug("Body part:\n{}", bodyPart);
            BatchItem item = (BatchItem)SerializationUtils.clone((Serializable)template);
            BatchPayloadParser.consumeHeaders(bodyPart, item);
            item.setContent(bodyPart.stream().map(BatchPayloadLine::toString).collect(Collectors.joining()));
            return item;
        }).toList();
    }

    private BatchPayloadParser() {
    }
}

