/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationDiscoverySelectionProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.flow.DelegatedClientWebflowCustomizer;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.binding.mapping.Mapper;
import org.springframework.binding.mapping.Mapping;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.webflow.action.EvaluateAction;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.EndState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.History;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.SubflowAttributeMapper;
import org.springframework.webflow.engine.SubflowState;
import org.springframework.webflow.engine.TransitionSet;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.ViewFactory;

public class DelegatedAuthenticationWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    private final FlowDefinitionRegistry delegatedClientRedirectFlowRegistry;

    public DelegatedAuthenticationWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, FlowDefinitionRegistry logoutFlowDefinitionRegistry, FlowDefinitionRegistry delegationRedirectFlowRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        this.delegatedClientRedirectFlowRegistry = delegationRedirectFlowRegistry;
        this.setLogoutFlowDefinitionRegistry(logoutFlowDefinitionRegistry);
        this.setOrder(casProperties.getAuthn().getPac4j().getWebflow().getOrder());
    }

    protected void doInitialize() {
        Flow flowDefn = this.getLoginFlow();
        Optional.ofNullable(flowDefn).ifPresent(flow -> {
            this.createClientActionState((Flow)flow);
            this.createStopWebflowViewState((Flow)flow);
            this.createDelegatedClientLogoutAction();
            this.createClientRedirectSubflow((Flow)flow);
            this.createIdentityProviderLogoutState((Flow)flow);
            Pac4jDelegatedAuthenticationDiscoverySelectionProperties.Pac4jDelegatedAuthenticationSelectionTypes selectionType = this.casProperties.getAuthn().getPac4j().getCore().getDiscoverySelection().getSelectionType();
            if (selectionType.isDynamic()) {
                this.createDynamicDiscoveryViewState((Flow)flow);
                this.createDynamicDiscoveryActionState((Flow)flow);
                this.createRedirectToProviderViewState((Flow)flow);
            }
        });
    }

    protected void createDelegatedClientLogoutAction() {
        Flow logoutFlow = this.getLogoutFlow();
        TransitionableState terminateSessionState = this.getState(logoutFlow, "terminateSession");
        terminateSessionState.getEntryActionList().add((Action)this.createEvaluateAction("delegatedAuthenticationClientLogoutAction"));
    }

    protected void createDelegatedClientCredentialSelectionState(Flow flow) {
        ViewState viewState = this.createViewState(flow, "viewDelegatedAuthnCredentials", "delegated-authn/casDelegatedAuthnSelectionView.html");
        ActionState selectState = this.createActionState(flow, "delegatedAuthenticationSelectCredential", new String[]{"delegatedAuthenticationClientCredentialSelectionAction"});
        this.createTransitionForState((TransitionableState)selectState, "select", viewState.getId());
        this.createTransitionForState((TransitionableState)selectState, "finalize", "delegatedAuthenticationFinalizeCredential");
        this.createTransitionForState((TransitionableState)viewState, "select", "delegatedAuthenticationFinalizeCredential");
        this.createTransitionForState((TransitionableState)viewState, "cancel", "stopWebflow");
        ActionState finalize = this.createActionState(flow, "delegatedAuthenticationFinalizeCredential", (Action)this.createEvaluateAction("delegatedAuthenticationClientCredentialSelectionFinalizeAction"));
        this.createTransitionForState((TransitionableState)finalize, "success", "delegatedAuthentication");
    }

    protected void createIdentityProviderLogoutState(Flow flow) {
        ActionState logoutState = this.createActionState(flow, "delegatedAuthenticationIdPLogout", (Action)this.createEvaluateAction("delegatedAuthenticationIdentityProviderLogoutAction"));
        this.createTransitionForState((TransitionableState)logoutState, "proceed", "redirectToCasLogout");
        this.createTransitionForState((TransitionableState)logoutState, "done", "logoutCompleted");
        EndState redirectToLogout = this.createEndState(flow, "redirectToCasLogout");
        redirectToLogout.getEntryActionList().add((Action)this.createEvaluateAction("delegatedAuthenticationIdentityProviderFinalizeLogoutAction"));
        EndState logoutCompleted = this.createEndState(flow, "logoutCompleted");
        logoutCompleted.setFinalResponseAction(ConsumerExecutionAction.OK);
    }

    protected void createClientActionState(Flow flow) {
        ActionState delegatedAuthentication = this.createActionState(flow, "delegatedAuthentication", (Action)this.createEvaluateAction("delegatedAuthenticationAction"));
        TransitionSet transitionSet = delegatedAuthentication.getTransitionSet();
        transitionSet.add(this.createTransition("success", "createTicketGrantingTicket"));
        transitionSet.add(this.createTransition("select", "delegatedAuthenticationSelectCredential"));
        String currentStartState = this.getStartState(flow).getId();
        transitionSet.add(this.createTransition("generate", currentStartState));
        transitionSet.add(this.createTransition("logout", "delegatedAuthenticationIdPLogout"));
        transitionSet.add(this.createTransition("successWithWarnings", "showAuthenticationWarningMessages"));
        transitionSet.add(this.createTransition("resume", "createTicketGrantingTicket"));
        transitionSet.add(this.createTransition("authenticationFailure", "checkDelegatedAuthnFailureDecision"));
        transitionSet.add(this.createTransition("stop", "stopWebflow"));
        transitionSet.add(this.createTransition("warn", "warn"));
        transitionSet.add(this.createTransition("generateServiceTicket", "generateServiceTicket"));
        ViewState viewLogin = (ViewState)this.getTransitionableState(flow, "viewLoginForm", ViewState.class);
        EvaluateAction delegatedClients = this.createEvaluateAction("delegatedAuthenticationCreateClientsAction");
        viewLogin.getRenderActionList().add((Action)delegatedClients);
        this.createDelegatedClientCredentialSelectionState(flow);
        this.setStartState(flow, (TransitionableState)delegatedAuthentication);
    }

    protected void createStopWebflowViewState(Flow flow) {
        this.createDecisionState(flow, "checkDelegatedAuthnFailureDecision", "flowScope.unauthorizedRedirectUrl != null", "serviceUnauthorizedCheck", "stopWebflow");
        ViewState stopWebflowState = this.createViewState(flow, "stopWebflow", "delegated-authn/casDelegatedAuthnStopWebflow");
        stopWebflowState.getEntryActionList().add((Action)this.createEvaluateAction("delegatedAuthenticationFailureAction"));
        this.createTransitionForState((TransitionableState)stopWebflowState, "retry", "delegatedAuthenticationClientRetry");
        EndState retryState = this.createEndState(flow, "delegatedAuthenticationClientRetry");
        retryState.setFinalResponseAction((Action)this.createEvaluateAction("delegatedAuthenticationClientRetryAction"));
    }

    private void createDynamicDiscoveryViewState(Flow flow) {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>();
        attributes.put("bind", Boolean.FALSE);
        attributes.put("validate", Boolean.FALSE);
        attributes.put("history", (Boolean)History.INVALIDATE);
        ViewState discoveryViewState = this.createViewState(flow, "delegatedAuthenticationDynamicDiscoveryView", "delegated-authn/casDynamicDiscoveryView");
        this.createTransitionForState((TransitionableState)discoveryViewState, "execute", "delegatedAuthenticationProviderDiscoveryExecution");
        this.createTransitionForState((TransitionableState)discoveryViewState, "back", "initializeLoginForm");
        TransitionableState casLoginViewState = this.getState(flow, "viewLoginForm");
        this.createTransitionForState(casLoginViewState, "discovery", "delegatedAuthenticationDynamicDiscoveryView", attributes);
    }

    private void createDynamicDiscoveryActionState(Flow flow) {
        ActionState discoveryActionState = this.createActionState(flow, "delegatedAuthenticationProviderDiscoveryExecution", new String[]{"delegatedAuthenticationProviderDynamicDiscoveryExecutionAction"});
        this.createTransitionForState((TransitionableState)discoveryActionState, "error", "delegatedAuthenticationDynamicDiscoveryView");
        this.createTransitionForState((TransitionableState)discoveryActionState, "redirect", "redirectToDelegatedAuthnProviderView");
    }

    private void createRedirectToProviderViewState(Flow flow) {
        ViewFactory factory = this.createExternalRedirectViewFactory("requestScope.delegatedAuthProviderRedirectUrl");
        this.createViewState(flow, "redirectToDelegatedAuthnProviderView", factory);
    }

    private void createClientRedirectSubflow(Flow flow) {
        Flow redirectFlow = this.buildFlow("clientredirect");
        this.createEndState(redirectFlow, "success");
        ActionState storeWebflowAction = this.createActionState(redirectFlow, "delegatedAuthenticationStoreWebflowState", new String[]{"delegatedAuthenticationStoreWebflowAction"});
        this.createTransitionForState((TransitionableState)storeWebflowAction, "redirect", "delegatedAuthenticationClientRedirect");
        ActionState redirectAction = this.createActionState(redirectFlow, "delegatedAuthenticationClientRedirect", new String[]{"delegatedAuthenticationRedirectToClientAction"});
        this.createTransitionForState((TransitionableState)redirectAction, "success", "success");
        redirectFlow.setStartState((State)storeWebflowAction);
        this.delegatedClientRedirectFlowRegistry.registerFlowDefinition((FlowDefinition)redirectFlow);
        this.mainFlowDefinitionRegistry.registerFlowDefinition((FlowDefinition)redirectFlow);
        TransitionableState casLoginViewState = this.getState(flow, "viewLoginForm");
        this.createTransitionForState(casLoginViewState, "delegatedAuthenticationRedirect", "delegatedAuthenticationClientSubflow");
        SubflowState subflowState = this.createSubflowState(flow, "delegatedAuthenticationClientSubflow", "clientredirect");
        this.createTransitionForState((TransitionableState)subflowState, "success", "endWebflowExecution");
        List<DelegatedClientWebflowCustomizer> customizers = this.applicationContext.getBeansOfType(DelegatedClientWebflowCustomizer.class).values().stream().filter(BeanSupplier::isNotProxy).sorted((Comparator<DelegatedClientWebflowCustomizer>)AnnotationAwareOrderComparator.INSTANCE).toList();
        Mapping attrMapping = this.createFlowMapping("flowScope.service", "service");
        List attrMappings = CollectionUtils.wrapList((Object[])new Mapping[]{attrMapping});
        customizers.forEach(c -> c.getWebflowAttributeMappings().forEach(key -> attrMappings.add(this.createFlowMapping("flowScope." + key, (String)key))));
        Mapper attributeMapper = this.createFlowInputMapper(attrMappings);
        SubflowAttributeMapper subflowMapper = this.createSubflowAttributeMapper(attributeMapper, null);
        subflowState.setAttributeMapper(subflowMapper);
        Mapping mapping = this.createFlowMapping("service", "flowScope.service", false, Service.class);
        List flowMappings = CollectionUtils.wrapList((Object[])new Mapping[]{mapping});
        customizers.forEach(c -> c.getWebflowAttributeMappings().forEach(key -> flowMappings.add(this.createFlowMapping((String)key, "flowScope." + key))));
        this.createFlowInputMapper(flowMappings, redirectFlow);
    }
}

