/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.authentication.principal.provision.DelegatedAuthenticationFailureException;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationDiscoverySelectionProperties;
import org.apereo.cas.pac4j.client.DelegatedClientAuthenticationRequestCustomizer;
import org.apereo.cas.pac4j.client.DelegatedClientIdentityProviderRedirectionStrategy;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviders;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.DelegatedClientIdentityProviderConfiguration;
import org.apereo.cas.web.DelegatedClientIdentityProviderConfigurationFactory;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.flow.DelegatedClientIdentityProviderConfigurationProducer;
import org.apereo.cas.web.flow.DelegationWebflowUtils;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.http.HttpStatus;
import org.springframework.webflow.execution.RequestContext;

public class DefaultDelegatedClientIdentityProviderConfigurationProducer
implements DelegatedClientIdentityProviderConfigurationProducer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDelegatedClientIdentityProviderConfigurationProducer.class);
    private final ObjectProvider<DelegatedClientAuthenticationConfigurationContext> configurationContext;

    public Set<DelegatedClientIdentityProviderConfiguration> produce(RequestContext context) throws Throwable {
        WebApplicationService currentService = WebUtils.getService((RequestContext)context);
        AuthenticationServiceSelectionPlan selectionStrategies = ((DelegatedClientAuthenticationConfigurationContext)this.configurationContext.getObject()).getAuthenticationRequestServiceSelectionStrategies();
        WebApplicationService service = (WebApplicationService)selectionStrategies.resolveService((Service)currentService, WebApplicationService.class);
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        JEEContext webContext = new JEEContext(request, response);
        LOGGER.debug("Initialized context with request parameters [{}]", (Object)webContext.getRequestParameters());
        DelegatedIdentityProviders clients = ((DelegatedClientAuthenticationConfigurationContext)this.configurationContext.getObject()).getIdentityProviders();
        List allClients = clients.findAllClients();
        LinkedHashSet providers = allClients.stream().filter(client -> client instanceof IndirectClient && this.isDelegatedClientAuthorizedForService((Client)client, (Service)service, context)).map(IndirectClient.class::cast).map(Unchecked.function(client -> this.produce(context, (IndirectClient)client))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(LinkedHashSet::new));
        DelegatedClientIdentityProviderRedirectionStrategy delegatedClientIdentityProviderRedirectionStrategy = ((DelegatedClientAuthenticationConfigurationContext)this.configurationContext.getObject()).getDelegatedClientIdentityProviderRedirectionStrategy();
        delegatedClientIdentityProviderRedirectionStrategy.select(context, service, (Set)providers).ifPresent(p -> DelegationWebflowUtils.putDelegatedAuthenticationProviderPrimary(context, (Serializable)p));
        if (!providers.isEmpty()) {
            CasConfigurationProperties casProperties = ((DelegatedClientAuthenticationConfigurationContext)this.configurationContext.getObject()).getCasProperties();
            Pac4jDelegatedAuthenticationDiscoverySelectionProperties.Pac4jDelegatedAuthenticationSelectionTypes selectionType = casProperties.getAuthn().getPac4j().getCore().getDiscoverySelection().getSelectionType();
            switch (selectionType) {
                case DYNAMIC: {
                    DelegationWebflowUtils.putDelegatedAuthenticationProviderConfigurations(context, new HashSet());
                    DelegationWebflowUtils.putDelegatedAuthenticationDynamicProviderSelection(context, Boolean.TRUE);
                    break;
                }
                case MENU: {
                    DelegationWebflowUtils.putDelegatedAuthenticationProviderConfigurations(context, providers);
                    DelegationWebflowUtils.putDelegatedAuthenticationDynamicProviderSelection(context, Boolean.FALSE);
                }
            }
        } else if (response.getStatus() != HttpStatus.UNAUTHORIZED.value()) {
            LOGGER.warn("No delegated authentication providers could be determined based on the provided configuration. Either no identity providers are configured, or the current access strategy rules prohibit CAS from using authentication providers");
        }
        return providers;
    }

    public Optional<DelegatedClientIdentityProviderConfiguration> produce(RequestContext requestContext, IndirectClient client) throws Throwable {
        return (Optional)FunctionUtils.doAndHandle(() -> {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
            JEEContext webContext = new JEEContext(request, response);
            WebApplicationService currentService = WebUtils.getService((RequestContext)requestContext);
            LOGGER.debug("Initializing client [{}] with request parameters [{}] and service [{}]", new Object[]{client, requestContext.getRequestParameters(), currentService});
            this.initializeClientIdentityProvider(client);
            List<DelegatedClientAuthenticationRequestCustomizer> customizers = ((DelegatedClientAuthenticationConfigurationContext)this.configurationContext.getObject()).getDelegatedClientAuthenticationRequestCustomizers();
            if (customizers.isEmpty() || customizers.stream().filter(BeanSupplier::isNotProxy).anyMatch(Unchecked.predicate(clientConfig -> clientConfig.isAuthorized((WebContext)webContext, client, currentService)))) {
                return ((DelegatedClientIdentityProviderConfigurationFactory)((DelegatedClientIdentityProviderConfigurationFactory.DelegatedClientIdentityProviderConfigurationFactoryBuilder)((DelegatedClientIdentityProviderConfigurationFactory.DelegatedClientIdentityProviderConfigurationFactoryBuilder)((DelegatedClientIdentityProviderConfigurationFactory.DelegatedClientIdentityProviderConfigurationFactoryBuilder)((DelegatedClientIdentityProviderConfigurationFactory.DelegatedClientIdentityProviderConfigurationFactoryBuilder)DelegatedClientIdentityProviderConfigurationFactory.builder().client(client)).webContext((WebContext)webContext)).service(currentService)).casProperties(((DelegatedClientAuthenticationConfigurationContext)this.configurationContext.getObject()).getCasProperties())).build()).resolve();
            }
            return Optional.empty();
        }, throwable -> Optional.empty()).get();
    }

    protected void initializeClientIdentityProvider(IndirectClient client) throws Throwable {
        if (!client.isInitialized()) {
            client.init(true);
        }
        FunctionUtils.throwIf((!client.isInitialized() ? 1 : 0) != 0, DelegatedAuthenticationFailureException::new);
    }

    protected boolean isDelegatedClientAuthorizedForService(Client client, Service service, RequestContext context) {
        return ((DelegatedClientAuthenticationConfigurationContext)this.configurationContext.getObject()).getDelegatedClientIdentityProviderAuthorizers().stream().allMatch(Unchecked.predicate(authz -> authz.isDelegatedClientAuthorizedForService(client, service, context)));
    }

    @Generated
    public DefaultDelegatedClientIdentityProviderConfigurationProducer(ObjectProvider<DelegatedClientAuthenticationConfigurationContext> configurationContext) {
        this.configurationContext = configurationContext;
    }
}

