/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationWebflowStateContributor;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.webflow.execution.RequestContext;

@Order(value=-2147483648)
public class DefaultDelegatedClientAuthenticationWebflowStateContributor
implements DelegatedClientAuthenticationWebflowStateContributor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDelegatedClientAuthenticationWebflowStateContributor.class);
    private final DelegatedClientAuthenticationConfigurationContext configContext;

    protected Map<String, Serializable> buildTicketProperties(WebContext webContext) {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        String themeParamName = this.configContext.getCasProperties().getTheme().getParamName();
        String localParamName = this.configContext.getCasProperties().getLocale().getParamName();
        webContext.getRequestParameter(themeParamName).ifPresent(value -> properties.put(themeParamName, (Serializable)value));
        webContext.getRequestParameter(localParamName).ifPresent(value -> properties.put(localParamName, (Serializable)value));
        webContext.getRequestParameter("method").ifPresent(value -> properties.put("method", (Serializable)value));
        LOGGER.debug("Built ticket properties [{}]", properties);
        return properties;
    }

    public Map<String, ? extends Serializable> store(RequestContext requestContext, WebContext webContext, Client client) throws Throwable {
        HttpServletRequest httpRequest = ((JEEContext)webContext).getNativeRequest();
        WebApplicationService originalService = this.configContext.getArgumentExtractor().extractService(httpRequest);
        Service service = this.configContext.getAuthenticationRequestServiceSelectionStrategies().resolveService((Service)originalService);
        Map<String, Serializable> properties = this.buildTicketProperties(webContext);
        properties.put("service", (Serializable)originalService);
        properties.put("targetService", (Serializable)service);
        properties.put(Client.class.getName(), (Serializable)((Object)client.getName()));
        RegisteredService registeredService = this.configContext.getServicesManager().findServiceBy(service);
        webContext.getRequestParameter("ForceAuthn").or(() -> Optional.of(Boolean.toString(RegisteredServiceProperty.RegisteredServiceProperties.DELEGATED_AUTHN_FORCE_AUTHN.isAssignedTo(registeredService)))).filter(value -> StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)"true")).ifPresent(attr -> properties.put("ForceAuthn", (Serializable)true));
        webContext.getRequestParameter("Passive").or(() -> Optional.of(Boolean.toString(RegisteredServiceProperty.RegisteredServiceProperties.DELEGATED_AUTHN_PASSIVE_AUTHN.isAssignedTo(registeredService)))).filter(value -> StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)"true")).ifPresent(attr -> properties.put("Passive", (Serializable)true));
        return properties;
    }

    public Service restore(RequestContext requestContext, WebContext webContext, Optional<TransientSessionTicket> givenSessionTicket, Client client) {
        return givenSessionTicket.map(ticket -> {
            Service service = ticket.getService();
            LOGGER.trace("Restoring requested service [{}] back in the authentication flow", (Object)service);
            WebUtils.putServiceIntoFlowScope((RequestContext)requestContext, (Service)service);
            webContext.setRequestAttribute("service", (Object)service);
            String themeParamName = this.configContext.getCasProperties().getTheme().getParamName();
            String localParamName = this.configContext.getCasProperties().getLocale().getParamName();
            Map properties = ticket.getProperties();
            webContext.setRequestAttribute(themeParamName, properties.get(themeParamName));
            Object localeValue = properties.get(localParamName);
            Optional.ofNullable(localeValue).ifPresent(locale -> {
                webContext.setRequestAttribute(localParamName, locale);
                HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
                HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
                Optional.ofNullable(RequestContextUtils.getLocaleResolver((HttpServletRequest)request)).ifPresent(localeResolver -> localeResolver.setLocale(request, response, Locale.forLanguageTag(locale.toString())));
            });
            webContext.setRequestAttribute("method", properties.get("method"));
            return service;
        }).orElse(null);
    }

    @Generated
    public DefaultDelegatedClientAuthenticationWebflowStateContributor(DelegatedClientAuthenticationConfigurationContext configContext) {
        this.configContext = configContext;
    }
}

