/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.serialization.StringSerializer;
import org.hjson.JsonValue;
import org.jooq.lambda.fi.util.function.CheckedConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class AbstractJacksonBackedStringSerializer<T>
implements StringSerializer<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJacksonBackedStringSerializer.class);
    protected static final PrettyPrinter MINIMAL_PRETTY_PRINTER = new MinimalPrettyPrinter();
    private static final long serialVersionUID = -8415599777321259365L;
    private final PrettyPrinter prettyPrinter;
    private final ConfigurableApplicationContext applicationContext;
    private ObjectMapper objectMapper;

    protected AbstractJacksonBackedStringSerializer(ConfigurableApplicationContext applicationContext) {
        this((PrettyPrinter)new DefaultPrettyPrinter(), applicationContext);
    }

    public T from(String json) {
        String jsonString = this.isJsonFormat() && this.isLenient() ? AbstractJacksonBackedStringSerializer.readHumanJson(json) : json;
        return this.readObjectFromString(jsonString);
    }

    public T from(Reader json) {
        return (T)FunctionUtils.doAndHandle(() -> {
            String data = this.isJsonFormat() && this.isLenient() ? AbstractJacksonBackedStringSerializer.readHumanJson(json) : String.join((CharSequence)"\n", IOUtils.readLines((Reader)json));
            return this.readObjectFromString(data);
        }, throwable -> null).get();
    }

    public T from(InputStream json) {
        return (T)FunctionUtils.doAndHandle(() -> {
            String jsonString = this.readJsonFrom(json);
            return this.readObjectFromString(jsonString);
        }, throwable -> null).get();
    }

    public T from(File json) {
        return (T)FunctionUtils.doAndHandle(() -> {
            String data = this.isJsonFormat() && this.isLenient() ? AbstractJacksonBackedStringSerializer.readHumanJson(FileUtils.readFileToString((File)json, (Charset)StandardCharsets.UTF_8)) : FileUtils.readFileToString((File)json, (Charset)StandardCharsets.UTF_8);
            return this.readObjectFromString(data);
        }, throwable -> null).get();
    }

    public T from(Writer writer) {
        return this.from(writer.toString());
    }

    public void to(OutputStream out, T object) {
        FunctionUtils.doUnchecked((CheckedConsumer<Object>)((CheckedConsumer)__ -> this.objectWriterFor(object).writeValue(out, object)), new Object[0]);
    }

    public void to(Writer writer, T object) {
        FunctionUtils.doUnchecked((CheckedConsumer<Object>)((CheckedConsumer)__ -> this.objectWriterFor(object).writeValue(writer, object)), new Object[0]);
    }

    public void to(File out, T object) {
        FunctionUtils.doUnchecked((CheckedConsumer<Object>)((CheckedConsumer)__ -> this.objectWriterFor(object).writeValue(out, object)), new Object[0]);
    }

    public String toString(T object) {
        return (String)FunctionUtils.doUnchecked(() -> {
            try (StringWriter writer = new StringWriter();){
                this.to(writer, object);
                String string = writer.toString();
                return string;
            }
        });
    }

    public String fromList(Collection<T> object) {
        return (String)FunctionUtils.doUnchecked(() -> {
            try (StringWriter writer = new StringWriter();){
                this.objectWriterFor(object.getClass()).writeValue((Writer)writer, (Object)object);
                String string = writer.toString();
                return string;
            }
        });
    }

    public List<T> fromList(String json) {
        String jsonString = this.isJsonFormat() && this.isLenient() ? AbstractJacksonBackedStringSerializer.readHumanJson(json) : json;
        return this.readObjectsFromString(jsonString);
    }

    public T merge(T baseEntity, T childEntity) {
        return FunctionUtils.doUnchecked(() -> {
            ObjectReader reader = this.getObjectMapper().readerForUpdating(baseEntity);
            return reader.readValue(this.toString(childEntity));
        });
    }

    protected boolean isLenient() {
        return false;
    }

    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = ((JacksonObjectMapperFactory)((JacksonObjectMapperFactory.JacksonObjectMapperFactoryBuilder)((JacksonObjectMapperFactory.JacksonObjectMapperFactoryBuilder)JacksonObjectMapperFactory.builder().defaultTypingEnabled(this.isDefaultTypingEnabled())).jsonFactory(this.getJsonFactory())).build()).toObjectMapper();
            this.configureObjectMapper(this.objectMapper);
        }
        return this.objectMapper;
    }

    protected String readJsonFrom(InputStream json) throws IOException {
        return this.isJsonFormat() && this.isLenient() ? AbstractJacksonBackedStringSerializer.readHumanJson(IOUtils.toString((InputStream)json, (Charset)StandardCharsets.UTF_8)) : String.join((CharSequence)"\n", IOUtils.readLines((InputStream)json, (Charset)StandardCharsets.UTF_8));
    }

    protected void configureObjectMapper(ObjectMapper mapper) {
    }

    protected boolean isDefaultTypingEnabled() {
        return true;
    }

    protected JsonFactory getJsonFactory() {
        return null;
    }

    protected T readObjectFromString(String jsonString) {
        try {
            LOGGER.trace("Attempting to parse [{}]", (Object)jsonString);
            return (T)this.getObjectMapper().readerFor(this.getTypeToSerialize()).readValue(jsonString);
        }
        catch (Exception e) {
            LOGGER.error("Cannot read/parse [{}] to deserialize into type [{}]. This may be caused in the absence of a configuration/support module that knows how to interpret the fragment, specially if the fragment describes a CAS registered service definition. Internal parsing error is [{}]", new Object[]{DigestUtils.abbreviate(jsonString), this.getTypeToSerialize(), e.getMessage()});
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected List<T> readObjectsFromString(String jsonString) {
        try {
            LOGGER.trace("Attempting to consume [{}]", (Object)jsonString);
            JavaType expectedType = this.getObjectMapper().getTypeFactory().constructParametricType(List.class, new Class[]{this.getTypeToSerialize()});
            return (List)this.getObjectMapper().readerFor(expectedType).readValue(jsonString);
        }
        catch (Exception e) {
            LOGGER.error("Cannot read/parse [{}] to deserialize into List of type [{}].Internal parsing error is [{}]", new Object[]{DigestUtils.abbreviate(jsonString), this.getTypeToSerialize(), e.getMessage()});
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private boolean isJsonFormat() {
        return !(this.getObjectMapper().getFactory() instanceof YAMLFactory);
    }

    private ObjectWriter objectWriterFor(T object) {
        return this.objectWriterFor(object.getClass());
    }

    private ObjectWriter objectWriterFor(Class object) {
        return this.getObjectMapper().writerFor(object).with(this.prettyPrinter);
    }

    private static String readHumanJson(String json) {
        return JsonValue.readHjson((String)json).toString();
    }

    private static String readHumanJson(Reader json) throws Exception {
        return JsonValue.readHjson((Reader)json).toString();
    }

    @Generated
    public PrettyPrinter getPrettyPrinter() {
        return this.prettyPrinter;
    }

    @Generated
    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    protected AbstractJacksonBackedStringSerializer(PrettyPrinter prettyPrinter, ConfigurableApplicationContext applicationContext) {
        this.prettyPrinter = prettyPrinter;
        this.applicationContext = applicationContext;
    }
}

