/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.syncope.common.lib.types.ResourceOperation;

public class PropagationByResource<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = -5699740428104336636L;
    private final Set<T> toBeCreated = new HashSet<T>();
    private final Set<T> toBeUpdated = new HashSet<T>();
    private final Set<T> toBeDeleted = new HashSet<T>();
    private final Map<String, String> oldConnObjectKeys = new HashMap<String, String>();

    public final void purge() {
        this.toBeCreated.removeAll(this.toBeDeleted);
        this.toBeCreated.removeAll(this.toBeUpdated);
        this.toBeUpdated.removeAll(this.toBeDeleted);
    }

    public final boolean add(ResourceOperation type, T key) {
        return (switch (type) {
            case ResourceOperation.CREATE -> this.toBeCreated;
            case ResourceOperation.UPDATE -> this.toBeUpdated;
            default -> this.toBeDeleted;
        }).add(key);
    }

    public boolean addAll(ResourceOperation type, Collection<T> keys) {
        return (switch (type) {
            case ResourceOperation.CREATE -> this.toBeCreated;
            case ResourceOperation.UPDATE -> this.toBeUpdated;
            default -> this.toBeDeleted;
        }).addAll(keys);
    }

    public final boolean remove(ResourceOperation type, T key) {
        boolean result = false;
        switch (type) {
            case CREATE: {
                result = this.toBeCreated.remove(key);
                break;
            }
            case UPDATE: {
                result = this.toBeUpdated.remove(key);
                break;
            }
            case DELETE: {
                result = this.toBeDeleted.remove(key);
                break;
            }
        }
        return result;
    }

    public boolean removeAll(ResourceOperation type, Set<T> keys) {
        return (switch (type) {
            case ResourceOperation.CREATE -> this.toBeCreated;
            case ResourceOperation.UPDATE -> this.toBeUpdated;
            default -> this.toBeDeleted;
        }).removeAll(keys);
    }

    public boolean removeAll(Collection<T> keys) {
        return this.toBeCreated.removeAll(keys) || this.toBeUpdated.removeAll(keys) || this.toBeDeleted.removeAll(keys);
    }

    public boolean retainAll(Collection<T> keys) {
        return this.toBeCreated.retainAll(keys) || this.toBeUpdated.retainAll(keys) || this.toBeDeleted.retainAll(keys);
    }

    public boolean contains(ResourceOperation type, T key) {
        boolean result = false;
        switch (type) {
            case CREATE: {
                result = this.toBeCreated.contains(key);
                break;
            }
            case UPDATE: {
                result = this.toBeUpdated.contains(key);
                break;
            }
            case DELETE: {
                result = this.toBeDeleted.contains(key);
                break;
            }
        }
        return result;
    }

    public boolean contains(T key) {
        return this.toBeCreated.contains(key) || this.toBeUpdated.contains(key) || this.toBeDeleted.contains(key);
    }

    public final Set<T> get(ResourceOperation type) {
        Set<Object> result = Set.of();
        switch (type) {
            case CREATE: {
                result = this.toBeCreated;
                break;
            }
            case UPDATE: {
                result = this.toBeUpdated;
                break;
            }
            case DELETE: {
                result = this.toBeDeleted;
                break;
            }
        }
        return result;
    }

    public Map<T, ResourceOperation> asMap() {
        HashMap result = new HashMap();
        Stream.of(ResourceOperation.values()).forEach(operation -> this.get((ResourceOperation)operation).forEach(resource -> result.put(resource, operation)));
        return result;
    }

    public final void set(ResourceOperation type, Collection<T> keys) {
        switch (type) {
            case CREATE: {
                this.toBeCreated.clear();
                this.toBeCreated.addAll(keys);
                break;
            }
            case UPDATE: {
                this.toBeUpdated.clear();
                this.toBeUpdated.addAll(keys);
                break;
            }
            case DELETE: {
                this.toBeDeleted.clear();
                this.toBeDeleted.addAll(keys);
                break;
            }
        }
    }

    public final void merge(PropagationByResource<T> propByRes) {
        if (propByRes != null) {
            this.toBeCreated.addAll(propByRes.get(ResourceOperation.CREATE));
            this.toBeUpdated.addAll(propByRes.get(ResourceOperation.UPDATE));
            this.toBeDeleted.addAll(propByRes.get(ResourceOperation.DELETE));
            this.oldConnObjectKeys.putAll(propByRes.getOldConnObjectKeys());
        }
    }

    public void clear() {
        this.toBeCreated.clear();
        this.toBeUpdated.clear();
        this.toBeDeleted.clear();
    }

    public final boolean isEmpty() {
        return this.toBeCreated.isEmpty() && this.toBeUpdated.isEmpty() && this.toBeDeleted.isEmpty() && this.oldConnObjectKeys.isEmpty();
    }

    public Map<String, String> getOldConnObjectKeys() {
        return this.oldConnObjectKeys;
    }

    public String getOldConnObjectKey(String resourceKey) {
        return this.oldConnObjectKeys.get(resourceKey);
    }

    public void addOldConnObjectKey(String resourceKey, String oldConnObjectKey) {
        if (resourceKey != null && oldConnObjectKey != null) {
            this.oldConnObjectKeys.put(resourceKey, oldConnObjectKey);
        }
    }

    public String toString() {
        return "To be Created: " + String.valueOf(this.toBeCreated) + ";\nTo be Updated: " + String.valueOf(this.toBeUpdated) + ";\nTo be Deleted: " + String.valueOf(this.toBeDeleted) + ";\nOld connObjectKeys: " + String.valueOf(this.oldConnObjectKeys);
    }
}

