/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.init;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.policy.AccountRuleConf;
import org.apache.syncope.common.lib.policy.InboundCorrelationRuleConf;
import org.apache.syncope.common.lib.policy.PasswordRuleConf;
import org.apache.syncope.common.lib.policy.PushCorrelationRuleConf;
import org.apache.syncope.common.lib.report.ReportConf;
import org.apache.syncope.common.lib.types.IdMImplementationType;
import org.apache.syncope.common.lib.types.IdRepoImplementationType;
import org.apache.syncope.common.lib.types.ImplementationTypesHolder;
import org.apache.syncope.core.logic.api.LogicActions;
import org.apache.syncope.core.persistence.api.attrvalue.DropdownValueProvider;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValueValidator;
import org.apache.syncope.core.provisioning.api.ImplementationLookup;
import org.apache.syncope.core.provisioning.api.LiveSyncDeltaMapper;
import org.apache.syncope.core.provisioning.api.ProvisionSorter;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;
import org.apache.syncope.core.provisioning.api.job.SchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.api.job.report.ReportConfClass;
import org.apache.syncope.core.provisioning.api.job.report.ReportJobDelegate;
import org.apache.syncope.core.provisioning.api.macro.Command;
import org.apache.syncope.core.provisioning.api.macro.MacroActions;
import org.apache.syncope.core.provisioning.api.notification.RecipientsProvider;
import org.apache.syncope.core.provisioning.api.propagation.PropagationActions;
import org.apache.syncope.core.provisioning.api.pushpull.InboundActions;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.ReconFilterBuilder;
import org.apache.syncope.core.provisioning.api.rules.AccountRule;
import org.apache.syncope.core.provisioning.api.rules.AccountRuleConfClass;
import org.apache.syncope.core.provisioning.api.rules.InboundCorrelationRule;
import org.apache.syncope.core.provisioning.api.rules.InboundCorrelationRuleConfClass;
import org.apache.syncope.core.provisioning.api.rules.PasswordRule;
import org.apache.syncope.core.provisioning.api.rules.PasswordRuleConfClass;
import org.apache.syncope.core.provisioning.api.rules.PushCorrelationRule;
import org.apache.syncope.core.provisioning.api.rules.PushCorrelationRuleConfClass;
import org.apache.syncope.core.provisioning.java.data.JEXLItemTransformerImpl;
import org.apache.syncope.core.provisioning.java.job.GroupMemberProvisionTaskJobDelegate;
import org.apache.syncope.core.provisioning.java.job.MacroJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.LiveSyncJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.PullJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.PushJobDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class ClassPathScanImplementationLookup
implements ImplementationLookup {
    private static final Logger LOG = LoggerFactory.getLogger(ImplementationLookup.class);
    private static final String DEFAULT_BASE_PACKAGE = "org.apache.syncope.core";
    private Map<String, Set<String>> classNames;
    private Map<Class<? extends ReportConf>, Class<? extends ReportJobDelegate>> reportJobDelegateClasses;
    private Map<Class<? extends AccountRuleConf>, Class<? extends AccountRule>> accountRuleClasses;
    private Map<Class<? extends PasswordRuleConf>, Class<? extends PasswordRule>> passwordRuleClasses;
    private Map<Class<? extends InboundCorrelationRuleConf>, Class<? extends InboundCorrelationRule>> inboundCRClasses;
    private Map<Class<? extends PushCorrelationRuleConf>, Class<? extends PushCorrelationRule>> pushCRClasses;

    public int getOrder() {
        return -2147483647;
    }

    protected static String getBasePackage() {
        return DEFAULT_BASE_PACKAGE;
    }

    public void load() {
        this.classNames = new HashMap<String, Set<String>>();
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        ImplementationTypesHolder.getInstance().getValues().forEach((typeName, typeInterface) -> {
            this.classNames.put((String)typeName, new HashSet());
            try {
                scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(ClassUtils.resolveClassName((String)typeInterface, (ClassLoader)ClassUtils.getDefaultClassLoader())));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Could not find class, ignoring...", (Throwable)e);
            }
        });
        Map<String, String> extImplTypes = ImplementationTypesHolder.getInstance().getValues().entrySet().stream().filter(e -> !IdRepoImplementationType.values().containsKey(e.getKey()) && !IdMImplementationType.values().containsKey(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.reportJobDelegateClasses = new HashMap<Class<? extends ReportConf>, Class<? extends ReportJobDelegate>>();
        this.accountRuleClasses = new HashMap<Class<? extends AccountRuleConf>, Class<? extends AccountRule>>();
        this.passwordRuleClasses = new HashMap<Class<? extends PasswordRuleConf>, Class<? extends PasswordRule>>();
        this.inboundCRClasses = new HashMap<Class<? extends InboundCorrelationRuleConf>, Class<? extends InboundCorrelationRule>>();
        this.pushCRClasses = new HashMap<Class<? extends PushCorrelationRuleConf>, Class<? extends PushCorrelationRule>>();
        for (BeanDefinition bd : scanner.findCandidateComponents(ClassPathScanImplementationLookup.getBasePackage())) {
            try {
                AccountRuleConfClass annotation;
                Class clazz = ClassUtils.resolveClassName((String)Objects.requireNonNull(bd.getBeanClassName()), (ClassLoader)ClassUtils.getDefaultClassLoader());
                if (Modifier.isAbstract(clazz.getModifiers())) continue;
                if (AccountRule.class.isAssignableFrom(clazz)) {
                    annotation = clazz.getAnnotation(AccountRuleConfClass.class);
                    if (annotation == null) {
                        LOG.warn("Found account policy rule {} without declared configuration", (Object)clazz.getName());
                        continue;
                    }
                    this.classNames.get("ACCOUNT_RULE").add(clazz.getName());
                    this.accountRuleClasses.put(annotation.value(), clazz);
                    continue;
                }
                if (PasswordRule.class.isAssignableFrom(clazz)) {
                    annotation = clazz.getAnnotation(PasswordRuleConfClass.class);
                    if (annotation == null) {
                        LOG.warn("Found password policy rule {} without declared configuration", (Object)clazz.getName());
                        continue;
                    }
                    this.classNames.get("PASSWORD_RULE").add(clazz.getName());
                    this.passwordRuleClasses.put(annotation.value(), clazz);
                    continue;
                }
                if (!(!SchedTaskJobDelegate.class.isAssignableFrom(clazz) || PullJobDelegate.class.isAssignableFrom(clazz) || PushJobDelegate.class.isAssignableFrom(clazz) || GroupMemberProvisionTaskJobDelegate.class.isAssignableFrom(clazz) || MacroJobDelegate.class.isAssignableFrom(clazz) || LiveSyncJobDelegate.class.isAssignableFrom(clazz))) {
                    this.classNames.get("TASKJOB_DELEGATE").add(bd.getBeanClassName());
                    continue;
                }
                if (ReportJobDelegate.class.isAssignableFrom(clazz)) {
                    annotation = clazz.getAnnotation(ReportConfClass.class);
                    if (annotation == null) {
                        LOG.warn("Found Report {} without declared configuration", (Object)clazz.getName());
                        continue;
                    }
                    this.classNames.get("REPORT_DELEGATE").add(clazz.getName());
                    this.reportJobDelegateClasses.put(annotation.value(), clazz);
                    continue;
                }
                if (LogicActions.class.isAssignableFrom(clazz)) {
                    this.classNames.get("LOGIC_ACTIONS").add(bd.getBeanClassName());
                    continue;
                }
                if (MacroActions.class.isAssignableFrom(clazz)) {
                    this.classNames.get("MACRO_ACTIONS").add(bd.getBeanClassName());
                    continue;
                }
                if (PlainAttrValueValidator.class.isAssignableFrom(clazz)) {
                    this.classNames.get("ATTR_VALUE_VALIDATOR").add(bd.getBeanClassName());
                    continue;
                }
                if (DropdownValueProvider.class.isAssignableFrom(clazz)) {
                    this.classNames.get("DROPDOWN_VALUE_PROVIDER").add(bd.getBeanClassName());
                    continue;
                }
                if (Command.class.isAssignableFrom(clazz)) {
                    this.classNames.get("COMMAND").add(bd.getBeanClassName());
                    continue;
                }
                if (RecipientsProvider.class.isAssignableFrom(clazz)) {
                    this.classNames.get("RECIPIENTS_PROVIDER").add(bd.getBeanClassName());
                    continue;
                }
                if (ItemTransformer.class.isAssignableFrom(clazz) && !clazz.equals(JEXLItemTransformerImpl.class)) {
                    this.classNames.get("ITEM_TRANSFORMER").add(clazz.getName());
                    continue;
                }
                if (ReconFilterBuilder.class.isAssignableFrom(clazz)) {
                    this.classNames.get("RECON_FILTER_BUILDER").add(bd.getBeanClassName());
                    continue;
                }
                if (PropagationActions.class.isAssignableFrom(clazz)) {
                    this.classNames.get("PROPAGATION_ACTIONS").add(bd.getBeanClassName());
                    continue;
                }
                if (InboundActions.class.isAssignableFrom(clazz)) {
                    this.classNames.get("INBOUND_ACTIONS").add(bd.getBeanClassName());
                    continue;
                }
                if (PushActions.class.isAssignableFrom(clazz)) {
                    this.classNames.get("PUSH_ACTIONS").add(bd.getBeanClassName());
                    continue;
                }
                if (InboundCorrelationRule.class.isAssignableFrom(clazz)) {
                    annotation = clazz.getAnnotation(InboundCorrelationRuleConfClass.class);
                    if (annotation == null) {
                        LOG.warn("Found pull correlation rule {} without declared configuration", (Object)clazz.getName());
                        continue;
                    }
                    this.classNames.get("INBOUND_CORRELATION_RULE").add(clazz.getName());
                    this.inboundCRClasses.put(annotation.value(), clazz);
                    continue;
                }
                if (PushCorrelationRule.class.isAssignableFrom(clazz)) {
                    annotation = clazz.getAnnotation(PushCorrelationRuleConfClass.class);
                    if (annotation == null) {
                        LOG.warn("Found push correlation rule {} without declared configuration", (Object)clazz.getName());
                        continue;
                    }
                    this.classNames.get("PUSH_CORRELATION_RULE").add(clazz.getName());
                    this.pushCRClasses.put(annotation.value(), clazz);
                    continue;
                }
                if (ProvisionSorter.class.isAssignableFrom(clazz)) {
                    this.classNames.get("PROVISION_SORTER").add(bd.getBeanClassName());
                    continue;
                }
                if (LiveSyncDeltaMapper.class.isAssignableFrom(clazz)) {
                    this.classNames.get("LIVE_SYNC_DELTA_MAPPER").add(bd.getBeanClassName());
                    continue;
                }
                extImplTypes.forEach((typeName, typeInterface) -> {
                    Class tic = ClassUtils.resolveClassName((String)typeInterface, (ClassLoader)ClassUtils.getDefaultClassLoader());
                    if (tic.isAssignableFrom(clazz)) {
                        this.classNames.get(typeName).add(bd.getBeanClassName());
                    }
                });
            }
            catch (Throwable t) {
                LOG.warn("Could not inspect class {}", (Object)bd.getBeanClassName(), (Object)t);
            }
        }
        this.classNames = Collections.unmodifiableMap(this.classNames);
        LOG.debug("Implementation classes found: {}", this.classNames);
        this.reportJobDelegateClasses = Collections.unmodifiableMap(this.reportJobDelegateClasses);
        this.accountRuleClasses = Collections.unmodifiableMap(this.accountRuleClasses);
        this.passwordRuleClasses = Collections.unmodifiableMap(this.passwordRuleClasses);
        this.inboundCRClasses = Collections.unmodifiableMap(this.inboundCRClasses);
        this.pushCRClasses = Collections.unmodifiableMap(this.pushCRClasses);
    }

    public Set<String> getClassNames(String type) {
        return this.classNames.get(type);
    }

    public Class<? extends ReportJobDelegate> getReportClass(Class<? extends ReportConf> reportConfClass) {
        return this.reportJobDelegateClasses.get(reportConfClass);
    }

    public Class<? extends AccountRule> getAccountRuleClass(Class<? extends AccountRuleConf> accountRuleConfClass) {
        return this.accountRuleClasses.get(accountRuleConfClass);
    }

    public Class<? extends PasswordRule> getPasswordRuleClass(Class<? extends PasswordRuleConf> passwordRuleConfClass) {
        return this.passwordRuleClasses.get(passwordRuleConfClass);
    }

    public Class<? extends InboundCorrelationRule> getInboundCorrelationRuleClass(Class<? extends InboundCorrelationRuleConf> inboundCorrelationRuleConfClass) {
        return this.inboundCRClasses.get(inboundCorrelationRuleConfClass);
    }

    public Class<? extends PushCorrelationRule> getPushCorrelationRuleClass(Class<? extends PushCorrelationRuleConf> correlationRuleConfClass) {
        return this.pushCRClasses.get(correlationRuleConfClass);
    }
}

