/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.logic.AbstractLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.content.ContentExporter;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.group.TypeExtension;
import org.apache.syncope.core.persistence.api.search.SyncopePage;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class SyncopeLogic
extends AbstractLogic<EntityTO> {
    protected final RealmSearchDAO realmSearchDAO;
    protected final AnyTypeDAO anyTypeDAO;
    protected final GroupDAO groupDAO;
    protected final AnySearchDAO anySearchDAO;
    protected final GroupDataBinder groupDataBinder;
    protected final ConfParamOps confParamOps;
    protected final ContentExporter exporter;

    public SyncopeLogic(RealmSearchDAO realmSearchDAO, AnyTypeDAO anyTypeDAO, GroupDAO groupDAO, AnySearchDAO anySearchDAO, GroupDataBinder groupDataBinder, ConfParamOps confParamOps, ContentExporter exporter) {
        this.realmSearchDAO = realmSearchDAO;
        this.anyTypeDAO = anyTypeDAO;
        this.groupDAO = groupDAO;
        this.anySearchDAO = anySearchDAO;
        this.groupDataBinder = groupDataBinder;
        this.confParamOps = confParamOps;
        this.exporter = exporter;
    }

    public boolean isSelfRegAllowed() {
        return (Boolean)this.confParamOps.get(AuthContextUtils.getDomain(), "selfRegistration.allowed", (Object)false, Boolean.class);
    }

    public boolean isPwdResetAllowed() {
        return (Boolean)this.confParamOps.get(AuthContextUtils.getDomain(), "passwordReset.allowed", (Object)false, Boolean.class);
    }

    public boolean isPwdResetRequiringSecurityQuestions() {
        return (Boolean)this.confParamOps.get(AuthContextUtils.getDomain(), "passwordReset.securityQuestion", (Object)true, Boolean.class);
    }

    @PreAuthorize(value="isAuthenticated()")
    public Page<GroupTO> searchAssignableGroups(String realm, String term, Pageable pageable) {
        AnyCond termCond;
        Realm base = (Realm)this.realmSearchDAO.findByFullPath(realm).orElseThrow(() -> new NotFoundException("Realm " + realm));
        if (StringUtils.isNotBlank((CharSequence)term)) {
            termCond = new AnyCond(AttrCond.Type.ILIKE);
            termCond.setSchema("name");
            termCond.setExpression(term.replace("*", "%"));
        } else {
            termCond = new AnyCond(AttrCond.Type.ISNOTNULL);
            termCond.setSchema("key");
        }
        SearchCond searchCond = SearchCond.getLeaf((AbstractSearchCond)termCond);
        long count = this.anySearchDAO.count(base, true, SyncopeConstants.FULL_ADMIN_REALMS, searchCond, AnyTypeKind.GROUP);
        List matching = this.anySearchDAO.search(base, true, SyncopeConstants.FULL_ADMIN_REALMS, searchCond, pageable, AnyTypeKind.GROUP);
        List<GroupTO> result = matching.stream().map(group -> this.groupDataBinder.getGroupTO(group, false)).toList();
        return new SyncopePage(result, pageable, count);
    }

    @PreAuthorize(value="isAuthenticated()")
    public TypeExtensionTO readTypeExtension(String groupName) {
        Group group = (Group)this.groupDAO.findByName(groupName).orElseThrow(() -> new NotFoundException("Group " + groupName));
        TypeExtension typeExt = (TypeExtension)group.getTypeExtension(this.anyTypeDAO.getUser()).orElseThrow(() -> new NotFoundException("TypeExtension in " + groupName + " for users"));
        return this.groupDataBinder.getTypeExtensionTO(typeExt);
    }

    @PreAuthorize(value="hasRole('KEYMASTER')")
    @Transactional(readOnly=true)
    public void exportInternalStorageContent(int tableThreshold, OutputStream os) {
        try {
            this.exporter.export(AuthContextUtils.getDomain(), tableThreshold, os);
            LOG.debug("Internal storage content successfully exported");
        }
        catch (Exception e) {
            LOG.error("While exporting internal storage content", (Throwable)e);
        }
    }

    @Override
    protected EntityTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

